/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import gnu.java.awt.peer.ClasspathFontPeer;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ColorModel;
import java.awt.image.ImageProducer;
import java.io.File;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public abstract class ClasspathToolkit
extends Toolkit {
    private Map imageCache;

    public abstract GraphicsEnvironment getLocalGraphicsEnvironment();

    public Dimension getScreenSize() {
        DisplayMode mode = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDisplayMode();
        return new Dimension(mode.getWidth(), mode.getHeight());
    }

    public ColorModel getColorModel() {
        return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getColorModel();
    }

    public FontMetrics getFontMetrics(Font font) {
        return ((ClasspathFontPeer)font.getPeer()).getFontMetrics(font);
    }

    public abstract ClasspathFontPeer getClasspathFontPeer(String var1, Map var2);

    public Font getFont(String name, Map attrs) {
        return new Font(name, attrs);
    }

    public abstract Font createFont(int var1, InputStream var2);

    public Image getImage(String path) {
        try {
            return this.getImage(new File(path).toURL());
        }
        catch (MalformedURLException muex) {
            throw (IllegalArgumentException)new IllegalArgumentException(path).initCause(muex);
        }
    }

    public Image getImage(URL url) {
        ClasspathToolkit classpathToolkit = this;
        synchronized (classpathToolkit) {
            Image image;
            try {
                Image result;
                if (this.imageCache == null) {
                    this.imageCache = new HashMap();
                } else {
                    result = (Image)this.imageCache.get(url);
                    if (result != null) {
                        Image image2 = result;
                        Object var5_6 = null;
                        return image2;
                    }
                }
                result = this.createImage(url);
                this.imageCache.put(url, result);
                image = result;
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                throw throwable;
            }
            Object var5_7 = null;
            return image;
        }
    }

    public Image createImage(String path) {
        try {
            return this.createImage(new File(path).toURL());
        }
        catch (MalformedURLException muex) {
            throw (IllegalArgumentException)new IllegalArgumentException(path).initCause(muex);
        }
    }

    public ImageProducer createImageProducer(URL url) {
        return null;
    }
}

