/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class GThreadNativeMethodRunner
extends Thread {
    private final long funcPtr;
    private final long funcArg;
    private static WeakReference[] threads = new WeakReference[17];
    private static final Set joinable = Collections.synchronizedSet(new HashSet());

    GThreadNativeMethodRunner(long funcPtr, long funcArg, boolean joinable) {
        this.funcPtr = funcPtr;
        this.funcArg = funcArg;
        if (joinable) {
            this.registerSelfJoinable();
        }
    }

    public void run() {
        this.nativeRun(this.funcPtr, this.funcArg);
    }

    private native void nativeRun(long var1, long var3);

    private static synchronized int registerThread(Thread t) {
        WeakReference ref;
        int i;
        for (i = 0; i < threads.length && (ref = threads[i]) != null; ++i) {
        }
        if (i == threads.length) {
            WeakReference[] bigger = new WeakReference[threads.length * 2];
            System.arraycopy(threads, 0, bigger, 0, threads.length);
            threads = bigger;
        }
        GThreadNativeMethodRunner.threads[i] = new WeakReference(t);
        return i;
    }

    static synchronized int threadToThreadID(Thread t) {
        for (int i = 0; i < threads.length; ++i) {
            if (threads[i] == null) continue;
            Thread referent = (Thread)threads[i].get();
            if (referent == null) {
                GThreadNativeMethodRunner.threads[i] = null;
                continue;
            }
            if (!referent.equals(t)) continue;
            return i;
        }
        return GThreadNativeMethodRunner.registerThread(t);
    }

    static Thread threadIDToThread(int threadID) throws IllegalArgumentException {
        if (threadID < 0) {
            throw new IllegalArgumentException("Received a negative threadID, " + threadID);
        }
        if (threadID >= threads.length) {
            throw new IllegalArgumentException("Received a threadID (" + threadID + ") higher than was" + " ever issued");
        }
        WeakReference threadRef = threads[threadID];
        if (threadRef == null) {
            throw new IllegalArgumentException("Asked to look up a stale or unissuedthreadID (" + threadID + ")");
        }
        Thread referent = (Thread)threadRef.get();
        if (referent == null) {
            throw new IllegalArgumentException("Asked to look up a stale threadID (" + threadID + ")");
        }
        return referent;
    }

    private void registerSelfJoinable() {
        joinable.add(this);
    }

    static void deRegisterJoinable(Thread thread) {
        joinable.remove(thread);
    }
}

