/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkFontMetrics;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkImagePainter;
import gnu.java.awt.peer.gtk.GtkOffScreenImage;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.SystemColor;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public class GdkGraphics
extends Graphics {
    private final int native_state;
    Color color;
    Color xorColor;
    GtkComponentPeer component;
    Font font;
    Rectangle clip;
    int xOffset;
    int yOffset;
    static final int GDK_COPY = 0;
    static final int GDK_XOR = 2;

    private /* synthetic */ void finit$() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
        this.xOffset = 0;
        this.yOffset = 0;
    }

    native void initState(GtkComponentPeer var1);

    native void initState(int var1, int var2);

    native void copyState(GdkGraphics var1);

    GdkGraphics(GdkGraphics g) {
        this.finit$();
        this.color = g.color;
        this.xorColor = g.xorColor;
        this.font = g.font;
        this.clip = new Rectangle(g.clip);
        this.component = g.component;
        this.copyState(g);
    }

    GdkGraphics(int width, int height) {
        this.finit$();
        this.initState(width, height);
        this.color = Color.black;
        this.clip = new Rectangle(0, 0, width, height);
        this.font = new Font("Dialog", 0, 12);
    }

    GdkGraphics(GtkComponentPeer component) {
        this.finit$();
        this.component = component;
        this.initState(component);
        this.color = component.awtComponent.getForeground();
        this.font = component.awtComponent.getFont();
        Dimension d = component.awtComponent.getSize();
        this.clip = new Rectangle(0, 0, d.width, d.height);
    }

    public native void clearRect(int var1, int var2, int var3, int var4);

    public void clipRect(int x, int y, int width, int height) {
        this.clip = this.clip.intersection(new Rectangle(x, y, width, height));
        this.setClipRectangle(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public native void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public Graphics create() {
        return new GdkGraphics(this);
    }

    public native void dispose();

    native void copyPixmap(Graphics var1, int var2, int var3, int var4, int var5);

    native void copyAndScalePixmap(Graphics var1, boolean var2, boolean var3, int var4, int var5, int var6, int var7, int var8, int var9, int var10, int var11);

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        if (img instanceof GtkOffScreenImage) {
            this.copyPixmap(img.getGraphics(), x, y, img.getWidth(null), img.getHeight(null));
            return true;
        }
        GtkImage image = (GtkImage)img;
        new GtkImagePainter(image, this, x, y, -1, -1, bgcolor);
        return image.isLoaded();
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        if (img instanceof GtkOffScreenImage) {
            this.copyPixmap(img.getGraphics(), x, y, img.getWidth(null), img.getHeight(null));
            return true;
        }
        if (this.component != null) {
            return this.drawImage(img, x, y, this.component.getBackground(), observer);
        }
        return this.drawImage(img, x, y, SystemColor.window, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (img instanceof GtkOffScreenImage) {
            this.copyAndScalePixmap(img.getGraphics(), false, false, 0, 0, img.getWidth(null), img.getHeight(null), x, y, width, height);
            return true;
        }
        GtkImage image = (GtkImage)img;
        new GtkImagePainter(image, this, x, y, width, height, bgcolor);
        return image.isLoaded();
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        if (this.component != null) {
            return this.drawImage(img, x, y, width, height, this.component.getBackground(), observer);
        }
        return this.drawImage(img, x, y, width, height, SystemColor.window, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (img instanceof GtkOffScreenImage) {
            int s_height;
            int sy_start;
            int s_width;
            int sx_start;
            int d_height;
            int dy_start;
            int d_width;
            int dx_start;
            boolean x_flip = false;
            boolean y_flip = false;
            if (dx1 < dx2) {
                dx_start = dx1;
                d_width = dx2 - dx1;
            } else {
                dx_start = dx2;
                d_width = dx1 - dx2;
                x_flip ^= true;
            }
            if (dy1 < dy2) {
                dy_start = dy1;
                d_height = dy2 - dy1;
            } else {
                dy_start = dy2;
                d_height = dy1 - dy2;
                y_flip ^= true;
            }
            if (sx1 < sx2) {
                sx_start = sx1;
                s_width = sx2 - sx1;
            } else {
                sx_start = sx2;
                s_width = sx1 - sx2;
                x_flip ^= true;
            }
            if (sy1 < sy2) {
                sy_start = sy1;
                s_height = sy2 - sy1;
            } else {
                sy_start = sy2;
                s_height = sy1 - sy2;
                y_flip ^= true;
            }
            this.copyAndScalePixmap(img.getGraphics(), x_flip, y_flip, sx_start, sy_start, s_width, s_height, dx_start, dy_start, d_width, d_height);
            return true;
        }
        GtkImage image = (GtkImage)img;
        new GtkImagePainter(image, this, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor);
        return image.isLoaded();
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        if (this.component != null) {
            return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.component.getBackground(), observer);
        }
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, SystemColor.window, observer);
    }

    public native void drawLine(int var1, int var2, int var3, int var4);

    public native void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public native void drawOval(int var1, int var2, int var3, int var4);

    public native void fillOval(int var1, int var2, int var3, int var4);

    public native void drawPolygon(int[] var1, int[] var2, int var3);

    public native void fillPolygon(int[] var1, int[] var2, int var3);

    public native void drawPolyline(int[] var1, int[] var2, int var3);

    public native void drawRect(int var1, int var2, int var3, int var4);

    public native void fillRect(int var1, int var2, int var3, int var4);

    native void drawString(String var1, int var2, int var3, String var4, int var5, int var6);

    public void drawString(String str, int x, int y) {
        this.drawString(str, x, y, this.font.getName(), this.font.getStyle(), this.font.getSize());
    }

    public void drawString(AttributedCharacterIterator ci, int x, int y) {
        throw new Error("not implemented");
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (arcWidth > width) {
            arcWidth = width;
        }
        if (arcHeight > height) {
            arcHeight = height;
        }
        int xx = x + width - arcWidth;
        int yy = y + height - arcHeight;
        this.drawArc(x, y, arcWidth, arcHeight, 90, 90);
        this.drawArc(xx, y, arcWidth, arcHeight, 0, 90);
        this.drawArc(xx, yy, arcWidth, arcHeight, 270, 90);
        this.drawArc(x, yy, arcWidth, arcHeight, 180, 90);
        int y1 = y + arcHeight / 2;
        int y2 = y + height - arcHeight / 2;
        this.drawLine(x, y1, x, y2);
        this.drawLine(x + width, y1, x + width, y2);
        int x1 = x + arcWidth / 2;
        int x2 = x + width - arcWidth / 2;
        this.drawLine(x1, y, x2, y);
        this.drawLine(x1, y + height, x2, y + height);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (arcWidth > width) {
            arcWidth = width;
        }
        if (arcHeight > height) {
            arcHeight = height;
        }
        int xx = x + width - arcWidth;
        int yy = y + height - arcHeight;
        this.fillArc(x, y, arcWidth, arcHeight, 90, 90);
        this.fillArc(xx, y, arcWidth, arcHeight, 0, 90);
        this.fillArc(xx, yy, arcWidth, arcHeight, 270, 90);
        this.fillArc(x, yy, arcWidth, arcHeight, 180, 90);
        this.fillRect(x, y + arcHeight / 2, width, height - arcHeight + 1);
        this.fillRect(x + arcWidth / 2, y, width - arcWidth + 1, height);
    }

    public Shape getClip() {
        return this.getClipBounds();
    }

    public Rectangle getClipBounds() {
        return new Rectangle(this.clip.x, this.clip.y, this.clip.width, this.clip.height);
    }

    public Color getColor() {
        return this.color;
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics(Font font) {
        return new GdkFontMetrics(font);
    }

    native void setClipRectangle(int var1, int var2, int var3, int var4);

    public void setClip(int x, int y, int width, int height) {
        this.clip.x = x;
        this.clip.y = y;
        this.clip.width = width;
        this.clip.height = height;
        this.setClipRectangle(x, y, width, height);
    }

    public void setClip(Rectangle clip) {
        this.setClip(clip.x, clip.y, clip.width, clip.height);
    }

    public void setClip(Shape clip) {
        this.setClip(clip.getBounds());
    }

    private native void setFGColor(int var1, int var2, int var3);

    public void setColor(Color c) {
        this.color = c == null ? new Color(0, 0, 0) : c;
        if (this.xorColor == null) {
            this.setFGColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
        } else {
            this.setFGColor(this.color.getRed() ^ this.xorColor.getRed(), this.color.getGreen() ^ this.xorColor.getGreen(), this.color.getBlue() ^ this.xorColor.getBlue());
        }
    }

    public void setFont(Font font) {
        this.font = font;
    }

    native void setFunction(int var1);

    public void setPaintMode() {
        this.xorColor = null;
        this.setFunction(0);
        this.setFGColor(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public void setXORMode(Color c) {
        this.xorColor = c;
        this.setFunction(2);
        this.setFGColor(this.color.getRed() ^ this.xorColor.getRed(), this.color.getGreen() ^ this.xorColor.getGreen(), this.color.getBlue() ^ this.xorColor.getBlue());
    }

    public native void translateNative(int var1, int var2);

    public void translate(int x, int y) {
        this.clip.x -= x;
        this.clip.y -= y;
        this.translateNative(x, y);
    }
}

