/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Configuration;
import gnu.java.awt.BitwiseXORComposite;
import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.gtk.GdkClasspathFontPeer;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkOffScreenImage;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.CropImageFilter;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImagingOpException;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Stack;

public class GdkGraphics2D
extends Graphics2D {
    private final int native_state;
    private Paint paint;
    private Stroke stroke;
    private Color fg;
    private Color bg;
    private Shape clip;
    private AffineTransform transform;
    private GtkComponentPeer component;
    private Font font;
    private RenderingHints hints;
    private BufferedImage bimage;
    private Stack stateStack;
    double x;
    double y;

    private /* synthetic */ void finit$() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
    }

    static native void initStaticState();

    private native void initState(GtkComponentPeer var1);

    private native void initState(int var1, int var2);

    private native void copyState(GdkGraphics2D var1);

    public native void dispose();

    private native int[] getImagePixels();

    private native void cairoSurfaceSetFilter(int var1);

    public void finalize() {
        this.dispose();
    }

    public Graphics create() {
        return new GdkGraphics2D(this);
    }

    public Graphics create(int x, int y, int width, int height) {
        return new GdkGraphics2D(width, height);
    }

    GdkGraphics2D(GdkGraphics2D g) {
        this.finit$();
        this.paint = g.paint;
        this.stroke = g.stroke;
        this.hints = g.hints;
        this.fg = g.fg.getAlpha() != -1 ? new Color(g.fg.getRed(), g.fg.getGreen(), g.fg.getBlue(), g.fg.getAlpha()) : new Color(g.fg.getRGB());
        this.bg = g.bg.getAlpha() != -1 ? new Color(g.bg.getRed(), g.bg.getGreen(), g.bg.getBlue(), g.bg.getAlpha()) : new Color(g.bg.getRGB());
        this.clip = g.clip == null ? null : new Rectangle(g.getClipBounds());
        this.transform = g.transform == null ? new AffineTransform() : new AffineTransform(g.transform);
        this.font = g.font;
        this.component = g.component;
        this.copyState(g);
        this.setColor(this.fg);
        this.setBackground(this.bg);
        this.setPaint(this.paint);
        this.setStroke(this.stroke);
        this.setClip(this.clip);
        this.setTransform(this.transform);
        this.stateStack = new Stack();
    }

    GdkGraphics2D(int width, int height) {
        this.finit$();
        this.initState(width, height);
        this.setColor(Color.black);
        this.setBackground(Color.black);
        this.setPaint(this.getColor());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setTransform(new AffineTransform());
        this.setStroke(new BasicStroke());
        this.setRenderingHints(this.getDefaultHints());
        this.stateStack = new Stack();
    }

    GdkGraphics2D(GtkComponentPeer component) {
        this.finit$();
        this.component = component;
        this.initState(component);
        this.setColor(component.awtComponent.getForeground());
        this.setBackground(component.awtComponent.getBackground());
        this.setPaint(this.getColor());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setTransform(new AffineTransform());
        this.setStroke(new BasicStroke());
        this.setRenderingHints(this.getDefaultHints());
        this.stateStack = new Stack();
    }

    GdkGraphics2D(BufferedImage bimage) {
        this.finit$();
        this.bimage = bimage;
        this.initState(bimage.getWidth(), bimage.getHeight());
        this.setColor(Color.black);
        this.setBackground(Color.black);
        this.setPaint(this.getColor());
        this.setFont(new Font("SansSerif", 0, 12));
        this.setTransform(new AffineTransform());
        this.setStroke(new BasicStroke());
        this.setRenderingHints(this.getDefaultHints());
        this.stateStack = new Stack();
        this.drawImage((Image)bimage, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f), this.bg, null);
    }

    private native void gdkDrawDrawable(GdkGraphics2D var1, int var2, int var3);

    private native void drawPixels(int[] var1, int var2, int var3, int var4, double[] var5);

    private native void setTexturePixels(int[] var1, int var2, int var3, int var4);

    private native void setGradient(double var1, double var3, double var5, double var7, int var9, int var10, int var11, int var12, int var13, int var14, int var15, int var16, boolean var17);

    private native void cairoSave();

    private native void cairoRestore();

    private native void cairoSetMatrix(double[] var1);

    private native void cairoSetFont(GdkClasspathFontPeer var1);

    private native void cairoShowGlyphs(int[] var1, float[] var2);

    private native void cairoSetOperator(int var1);

    private native void cairoSetRGBColor(double var1, double var3, double var5);

    private native void cairoSetAlpha(double var1);

    private native void cairoSetFillRule(int var1);

    private native void cairoSetLineWidth(double var1);

    private native void cairoSetLineCap(int var1);

    private native void cairoSetLineJoin(int var1);

    private native void cairoSetDash(double[] var1, int var2, double var3);

    private native void cairoSetMiterLimit(double var1);

    private native void cairoNewPath();

    private native void cairoMoveTo(double var1, double var3);

    private native void cairoLineTo(double var1, double var3);

    private native void cairoCurveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    private native void cairoRelMoveTo(double var1, double var3);

    private native void cairoRelLineTo(double var1, double var3);

    private native void cairoRelCurveTo(double var1, double var3, double var5, double var7, double var9, double var11);

    private native void cairoRectangle(double var1, double var3, double var5, double var7);

    private native void cairoClosePath();

    private native void cairoStroke();

    private native void cairoFill();

    private native void cairoClip();

    private void stateSave() {
        this.stateStack.push(new DrawState(this, this));
        this.cairoSave();
    }

    private void stateRestore() {
        ((DrawState)this.stateStack.pop()).restore(this);
        this.cairoRestore();
    }

    private void setPos(double nx, double ny) {
        this.x = nx;
        this.y = ny;
    }

    private void walkPath(PathIterator p) {
        double[] coords = new double[6];
        this.cairoSetFillRule(p.getWindingRule());
        while (!p.isDone()) {
            int seg = p.currentSegment(coords);
            switch (seg) {
                case 0: {
                    this.setPos(coords[0], coords[1]);
                    this.cairoMoveTo(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    this.setPos(coords[0], coords[1]);
                    this.cairoLineTo(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    double x1 = this.x + 0.6666666666666666 * (coords[0] - this.x);
                    double y1 = this.y + 0.6666666666666666 * (coords[1] - this.y);
                    double x2 = x1 + 0.3333333333333333 * (coords[2] - this.x);
                    double y2 = y1 + 0.3333333333333333 * (coords[3] - this.y);
                    this.setPos(coords[2], coords[3]);
                    this.cairoCurveTo(x1, y1, x2, y2, coords[2], coords[3]);
                    break;
                }
                case 3: {
                    this.setPos(coords[4], coords[5]);
                    this.cairoCurveTo(coords[0], coords[1], coords[2], coords[3], coords[4], coords[5]);
                    break;
                }
                case 4: {
                    this.cairoClosePath();
                }
            }
            p.next();
        }
    }

    private Map getDefaultHints() {
        HashMap defaultHints = new HashMap();
        defaultHints.put(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT);
        defaultHints.put(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_DEFAULT);
        defaultHints.put(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        defaultHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        defaultHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_DEFAULT);
        return defaultHints;
    }

    private void updateBufferedImage() {
        int[] pixels = this.getImagePixels();
        this.updateImagePixels(pixels);
    }

    private boolean isBufferedImageGraphics() {
        return this.bimage != null;
    }

    private void updateImagePixels(int[] pixels) {
        if (!this.isBufferedImageGraphics()) {
            return;
        }
        WritableRaster raster = this.bimage.getRaster();
        DataBuffer db = raster.getDataBuffer();
        if (raster.getSampleModel().getDataType() == 3 && db instanceof DataBufferInt && db.getNumBanks() == 1) {
            DataBufferInt dbi = (DataBufferInt)raster.getDataBuffer();
            for (int i = 0; i < pixels.length; ++i) {
                dbi.setElem(i, pixels[i]);
            }
        } else {
            this.bimage.getRaster().setPixels(0, 0, raster.getWidth(), raster.getHeight(), pixels);
        }
    }

    private boolean drawImage(Image img, AffineTransform xform, Color bgcolor, ImageObserver obs) {
        if (img instanceof GtkOffScreenImage && img.getGraphics() instanceof GdkGraphics2D && (xform == null || xform.getType() == 0 || xform.getType() == 1)) {
            GdkGraphics2D g2 = (GdkGraphics2D)img.getGraphics();
            this.gdkDrawDrawable(g2, (int)xform.getTranslateX(), (int)xform.getTranslateY());
            if (this.isBufferedImageGraphics()) {
                this.updateBufferedImage();
            }
            return true;
        }
        AffineTransform invertedXform = new AffineTransform();
        try {
            invertedXform = xform.createInverse();
            if (img instanceof BufferedImage) {
                BufferedImage b = (BufferedImage)img;
                return this.drawRaster(b.getColorModel(), b.getData(), invertedXform, bgcolor);
            }
            new PainterThread(this, this, img, invertedXform, bgcolor);
            return false;
        }
        catch (NoninvertibleTransformException e) {
            throw new ImagingOpException("Unable to invert transform " + xform.toString());
        }
    }

    public void draw(Shape s) {
        boolean normalize;
        if (this.stroke != null && !(this.stroke instanceof BasicStroke)) {
            this.fill(this.stroke.createStrokedShape(s));
            return;
        }
        this.stateSave();
        this.cairoNewPath();
        boolean bl = normalize = this.hints.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || this.hints.containsValue(RenderingHints.VALUE_STROKE_DEFAULT);
        if (normalize) {
            this.translate(0.5, 0.5);
        }
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.cairoRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else {
            this.walkPath(s.getPathIterator(null));
        }
        this.cairoStroke();
        if (normalize) {
            this.translate(-0.5, -0.5);
        }
        this.stateRestore();
        if (this.isBufferedImageGraphics()) {
            this.updateBufferedImage();
        }
    }

    public void fill(Shape s) {
        this.stateSave();
        this.cairoNewPath();
        if (s instanceof Rectangle2D) {
            Rectangle2D r = (Rectangle2D)s;
            this.cairoRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
        } else {
            this.walkPath(s.getPathIterator(null));
        }
        this.cairoFill();
        this.stateRestore();
        if (this.isBufferedImageGraphics()) {
            this.updateBufferedImage();
        }
    }

    public void clip(Shape s) {
        Rectangle2D r;
        if (this.clip == null || s == null) {
            this.clip = s;
        } else if (s instanceof Rectangle2D && this.clip instanceof Rectangle2D) {
            r = (Rectangle2D)s;
            Rectangle2D curr = (Rectangle2D)this.clip;
            this.clip = curr.createIntersection(r);
        } else {
            throw new UnsupportedOperationException();
        }
        if (this.clip != null) {
            this.cairoNewPath();
            if (this.clip instanceof Rectangle2D) {
                r = (Rectangle2D)this.clip;
                this.cairoRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            } else {
                this.walkPath(this.clip.getPathIterator(null));
            }
            this.cairoClosePath();
            this.cairoClip();
        }
    }

    public Paint getPaint() {
        return this.paint;
    }

    public AffineTransform getTransform() {
        return (AffineTransform)this.transform.clone();
    }

    public void setPaint(Paint p) {
        if (this.paint == null) {
            return;
        }
        this.paint = p;
        if (this.paint instanceof Color) {
            this.setColor((Color)this.paint);
        } else if (this.paint instanceof TexturePaint) {
            TexturePaint tp = (TexturePaint)this.paint;
            BufferedImage img = tp.getImage();
            int width = (int)tp.getAnchorRect().getWidth();
            int height = (int)tp.getAnchorRect().getHeight();
            double scaleX = (double)width / (double)img.getWidth();
            double scaleY = (double)width / (double)img.getHeight();
            AffineTransform at = new AffineTransform(scaleX, 0.0, 0.0, scaleY, 0.0, 0.0);
            AffineTransformOp op = new AffineTransformOp(at, this.getRenderingHints());
            BufferedImage texture = op.filter(img, null);
            int[] pixels = texture.getRGB(0, 0, width, height, null, 0, width);
            this.setTexturePixels(pixels, width, height, width);
        } else if (this.paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)this.paint;
            Point2D p1 = gp.getPoint1();
            Point2D p2 = gp.getPoint2();
            Color c1 = gp.getColor1();
            Color c2 = gp.getColor2();
            this.setGradient(p1.getX(), p1.getY(), p2.getX(), p2.getY(), c1.getRed(), c1.getGreen(), c1.getBlue(), c1.getAlpha(), c2.getRed(), c2.getGreen(), c2.getBlue(), c2.getAlpha(), gp.isCyclic());
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public void setTransform(AffineTransform tx) {
        this.transform = tx;
        if (this.transform != null) {
            double[] m = new double[6];
            this.transform.getMatrix(m);
            this.cairoSetMatrix(m);
        }
    }

    public void transform(AffineTransform tx) {
        if (this.transform == null) {
            this.transform = new AffineTransform(tx);
        } else {
            this.transform.concatenate(tx);
        }
        this.setTransform(this.transform);
        if (this.clip != null) {
            Rectangle2D r = this.clip.getBounds2D();
            double[] coords = new double[]{r.getX(), r.getY(), r.getX() + r.getWidth(), r.getY() + r.getHeight()};
            try {
                tx.createInverse().transform(coords, 0, coords, 0, 2);
                r.setRect(coords[0], coords[1], coords[2] - coords[0], coords[3] - coords[1]);
                this.clip = r;
            }
            catch (NoninvertibleTransformException e) {
                // empty catch block
            }
        }
    }

    public void rotate(double theta) {
        this.transform(AffineTransform.getRotateInstance(theta));
    }

    public void rotate(double theta, double x, double y) {
        this.transform(AffineTransform.getRotateInstance(theta, x, y));
    }

    public void scale(double sx, double sy) {
        this.transform(AffineTransform.getScaleInstance(sx, sy));
    }

    public void translate(double tx, double ty) {
        this.transform(AffineTransform.getTranslateInstance(tx, ty));
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void shear(double shearX, double shearY) {
        this.transform(AffineTransform.getShearInstance(shearX, shearY));
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setStroke(Stroke st) {
        this.stroke = st;
        if (this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            this.cairoSetLineCap(bs.getEndCap());
            this.cairoSetLineWidth((double)bs.getLineWidth() / 2.0);
            this.cairoSetLineJoin(bs.getLineJoin());
            this.cairoSetMiterLimit(bs.getMiterLimit());
            float[] dashes = bs.getDashArray();
            if (dashes != null) {
                double[] double_dashes = new double[dashes.length];
                for (int i = 0; i < dashes.length; ++i) {
                    double_dashes[i] = dashes[i];
                }
                this.cairoSetDash(double_dashes, double_dashes.length, bs.getDashPhase());
            }
        }
    }

    public void setPaintMode() {
        this.setComposite(AlphaComposite.SrcOver);
    }

    public void setXORMode(Color c) {
        this.setComposite(new BitwiseXORComposite(c));
    }

    public void setColor(Color c) {
        this.fg = c;
        this.paint = c;
        this.cairoSetRGBColor((double)this.fg.getRed() / 255.0, (double)this.fg.getGreen() / 255.0, (double)this.fg.getBlue() / 255.0);
        this.cairoSetAlpha((double)(this.fg.getAlpha() & 0xFF) / 255.0);
    }

    public Color getColor() {
        return this.fg;
    }

    public void clipRect(int x, int y, int width, int height) {
        this.clip(new Rectangle(x, y, width, height));
    }

    public Shape getClip() {
        return this.getClipInDevSpace();
    }

    public Rectangle getClipBounds() {
        if (this.clip == null) {
            return null;
        }
        return this.clip.getBounds();
    }

    protected Rectangle2D getClipInDevSpace() {
        Rectangle2D uclip = this.clip.getBounds2D();
        if (this.transform == null) {
            return uclip;
        }
        Point2D pos = this.transform.transform(new Point2D.Double(uclip.getX(), uclip.getY()), null);
        Point2D extent = this.transform.deltaTransform(new Point2D.Double(uclip.getWidth(), uclip.getHeight()), null);
        return new Rectangle2D.Double(pos.getX(), pos.getY(), extent.getX(), extent.getY());
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClip(new Rectangle2D.Double(x, y, width, height));
    }

    public void setClip(Shape s) {
        this.clip = s;
        if (s != null) {
            this.cairoNewPath();
            if (s instanceof Rectangle2D) {
                Rectangle2D r = (Rectangle2D)s;
                this.cairoRectangle(r.getX(), r.getY(), r.getWidth(), r.getHeight());
            } else {
                this.walkPath(s.getPathIterator(null));
            }
            this.cairoClosePath();
            this.cairoClip();
        }
    }

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        boolean normalize;
        Color std = this.fg;
        Color light = std.brighter();
        Color dark = std.darker();
        if (!raised) {
            Color t = light;
            light = dark;
            dark = t;
        }
        double x1 = x;
        double x2 = (double)x + (double)width;
        double y1 = y;
        double y2 = (double)y + (double)height;
        this.stateSave();
        this.cairoNewPath();
        boolean bl = normalize = this.hints.containsValue(RenderingHints.VALUE_STROKE_NORMALIZE) || this.hints.containsValue(RenderingHints.VALUE_STROKE_DEFAULT);
        if (normalize) {
            x1 += 0.5;
            y1 += 0.5;
            x2 += 0.5;
            y2 += 0.5;
        }
        this.setColor(light);
        this.cairoMoveTo(x1, y1);
        this.cairoLineTo(x2, y1);
        this.cairoLineTo(x2, y2);
        this.cairoStroke();
        this.cairoNewPath();
        this.setColor(dark);
        this.cairoMoveTo(x1, y1);
        this.cairoLineTo(x1, y2);
        this.cairoLineTo(x2, y2);
        this.cairoStroke();
        this.stateRestore();
        if (this.isBufferedImageGraphics()) {
            this.updateBufferedImage();
        }
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        double step = 1.0;
        if (this.stroke != null && this.stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)this.stroke;
            step = bs.getLineWidth();
        }
        Color bright = this.fg.brighter();
        Color dark = this.fg.darker();
        this.draw3DRect(x, y, width, height, raised);
        this.stateSave();
        this.translate(step / 2.0, step / 2.0);
        this.cairoNewPath();
        this.cairoRectangle(x, y, (double)width - step, (double)height - step);
        this.cairoClosePath();
        this.cairoFill();
        this.stateRestore();
        if (this.isBufferedImageGraphics()) {
            this.updateBufferedImage();
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        this.draw(new Rectangle(x, y, width, height));
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fill(new Rectangle(x, y, width, height));
    }

    public void clearRect(int x, int y, int width, int height) {
        this.stateSave();
        this.cairoSetRGBColor((double)this.bg.getRed() / 255.0, (double)this.bg.getGreen() / 255.0, (double)this.bg.getBlue() / 255.0);
        this.cairoSetAlpha(1.0);
        this.cairoNewPath();
        this.cairoRectangle(x, y, width, height);
        this.cairoClosePath();
        this.cairoFill();
        this.stateRestore();
        if (this.isBufferedImageGraphics()) {
            this.updateBufferedImage();
        }
    }

    public void setBackground(Color c) {
        this.bg = c;
    }

    public Color getBackground() {
        return this.bg;
    }

    private void doPolygon(int[] xPoints, int[] yPoints, int nPoints, boolean close, boolean fill) {
        if (nPoints < 1) {
            return;
        }
        GeneralPath gp = new GeneralPath(0);
        gp.moveTo(xPoints[0], yPoints[0]);
        for (int i = 1; i < nPoints; ++i) {
            gp.lineTo(xPoints[i], yPoints[i]);
        }
        if (close) {
            gp.closePath();
        }
        Shape sh = gp;
        if (!fill && this.stroke != null && !(this.stroke instanceof BasicStroke)) {
            sh = this.stroke.createStrokedShape(gp);
            fill = true;
        }
        if (fill) {
            this.fill(sh);
        } else {
            this.draw(sh);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        int[] xp = new int[2];
        int[] yp = new int[2];
        xp[0] = x1;
        xp[1] = x2;
        yp[0] = y1;
        yp[1] = y2;
        this.doPolygon(xp, yp, 2, false, false);
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.doPolygon(xPoints, yPoints, nPoints, true, true);
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int nPoints) {
        this.doPolygon(xPoints, yPoints, nPoints, true, false);
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int nPoints) {
        this.doPolygon(xPoints, yPoints, nPoints, false, false);
    }

    private boolean drawRaster(ColorModel cm, Raster r, AffineTransform imageToUser, Color bgcolor) {
        if (r == null) {
            return false;
        }
        SampleModel sm = r.getSampleModel();
        DataBuffer db = r.getDataBuffer();
        if (db == null || sm == null) {
            return false;
        }
        if (cm == null) {
            cm = ColorModel.getRGBdefault();
        }
        double[] i2u = new double[6];
        if (imageToUser != null) {
            imageToUser.getMatrix(i2u);
        } else {
            i2u[0] = 1.0;
            i2u[1] = 0.0;
            i2u[2] = 0.0;
            i2u[3] = 1.0;
            i2u[4] = 0.0;
            i2u[5] = 0.0;
        }
        int[] pixels = null;
        if (sm.getDataType() == 3 && db instanceof DataBufferInt && db.getNumBanks() == 1) {
            DataBufferInt dbi = (DataBufferInt)db;
            pixels = dbi.getData();
        } else {
            pixels = r.getPixels(0, 0, r.getWidth(), r.getHeight(), pixels);
        }
        ColorSpace cs = cm.getColorSpace();
        if (cs != null && cs.getType() != 1000) {
            int[] pixels2 = new int[pixels.length];
            for (int i = 0; i < pixels2.length; ++i) {
                pixels2[i] = cm.getRGB(pixels[i]);
            }
            pixels = pixels2;
        }
        if (bgcolor != null) {
            for (int i = 0; i < pixels.length; ++i) {
                if (cm.getAlpha(pixels[i]) != 0) continue;
                pixels[i] = bgcolor.getRGB();
            }
        }
        this.stateSave();
        this.translate(this.x, this.y);
        this.drawPixels(pixels, r.getWidth(), r.getHeight(), r.getWidth(), i2u);
        this.stateRestore();
        if (this.isBufferedImageGraphics()) {
            this.updateBufferedImage();
        }
        return true;
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        this.drawRaster(image.getColorModel(), image.getData(), xform, this.bg);
    }

    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        this.drawRenderedImage(image.createRendering(new RenderContext(xform)), xform);
    }

    public boolean drawImage(Image img, AffineTransform xform, ImageObserver obs) {
        return this.drawImage(img, xform, this.bg, obs);
    }

    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        BufferedImage filtered = op.filter(image, null);
        this.drawImage((Image)filtered, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), this.bg, null);
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y), this.bg, observer);
    }

    public boolean hit(Rectangle rect, Shape text, boolean onStroke) {
        throw new UnsupportedOperationException();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        throw new UnsupportedOperationException();
    }

    public void setComposite(Composite comp) {
        if (!(comp instanceof AlphaComposite)) {
            throw new UnsupportedOperationException();
        }
        AlphaComposite a = (AlphaComposite)comp;
        this.cairoSetOperator(a.getRule());
        Color c = this.getColor();
        this.setColor(new Color(c.getRed(), c.getGreen(), c.getBlue(), (int)(a.getAlpha() * (float)c.getAlpha())));
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.hints.put(hintKey, hintValue);
        if (hintKey.equals(RenderingHints.KEY_INTERPOLATION) || hintKey.equals(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (hintValue.equals(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                this.cairoSurfaceSetFilter(0);
            } else if (hintValue.equals(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                this.cairoSurfaceSetFilter(1);
            } else if (hintValue.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
                this.cairoSurfaceSetFilter(2);
            } else if (hintValue.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
                this.cairoSurfaceSetFilter(3);
            } else if (hintValue.equals(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
                this.cairoSurfaceSetFilter(4);
            }
        }
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.hints.get(hintKey);
    }

    public void setRenderingHints(Map hints) {
        this.hints = new RenderingHints(this.getDefaultHints());
        this.hints.add(new RenderingHints(hints));
        if (hints.containsKey(RenderingHints.KEY_INTERPOLATION)) {
            if (hints.containsValue(RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR)) {
                this.cairoSurfaceSetFilter(0);
            } else if (hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
                this.cairoSurfaceSetFilter(1);
            }
        }
        if (hints.containsKey(RenderingHints.KEY_ALPHA_INTERPOLATION)) {
            if (hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED)) {
                this.cairoSurfaceSetFilter(2);
            } else if (hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY)) {
                this.cairoSurfaceSetFilter(3);
            } else if (hints.containsValue(RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT)) {
                this.cairoSurfaceSetFilter(4);
            }
        }
    }

    public void addRenderingHints(Map hints) {
        this.hints.add(new RenderingHints(hints));
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public Composite getComposite() {
        throw new UnsupportedOperationException();
    }

    public FontRenderContext getFontRenderContext() {
        return new FontRenderContext(this.transform, true, true);
    }

    public void drawGlyphVector(GlyphVector g, float x, float y) {
        this.stateSave();
        this.setFont(g.getFont());
        this.translate(x, y);
        this.cairoMoveTo(0.0, 0.0);
        int nglyphs = g.getNumGlyphs();
        int[] codes = g.getGlyphCodes(0, nglyphs, null);
        float[] posns = g.getGlyphPositions(0, nglyphs, null);
        this.cairoShowGlyphs(codes, posns);
        if (this.isBufferedImageGraphics()) {
            this.updateBufferedImage();
        }
        this.stateRestore();
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        throw new UnsupportedOperationException();
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    public boolean drawImage(Image img, int x, int y, Color bgcolor, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        double scaleX = (double)width / (double)img.getWidth(observer);
        double scaleY = (double)height / (double)img.getHeight(observer);
        return this.drawImage(img, new AffineTransform(scaleX, 0.0, 0.0, scaleY, (double)x, (double)y), bgcolor, observer);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(img, x, y, width, height, this.bg, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        Image subImage;
        int sourceWidth = sx2 - sx1;
        int sourceHeight = sy2 - sy1;
        int destWidth = dx2 - dx1;
        int destHeight = dy2 - dy1;
        double scaleX = (double)destWidth / (double)sourceWidth;
        double scaleY = (double)destHeight / (double)sourceHeight;
        if (img instanceof BufferedImage) {
            BufferedImage b = (BufferedImage)img;
            subImage = b.getSubimage(sx1, sy1, sx2, sy2);
        } else {
            CropImageFilter filter = new CropImageFilter(sx1, sx2, sx2, sy2);
            FilteredImageSource src = new FilteredImageSource(img.getSource(), filter);
            subImage = Toolkit.getDefaultToolkit().createImage(src);
        }
        return this.drawImage(subImage, new AffineTransform(scaleX, 0.0, 0.0, scaleY, (double)dx1, (double)dy1), bgcolor, observer);
    }

    public boolean drawImage(Image img, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(img, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this.bg, observer);
    }

    public void drawOval(int x, int y, int width, int height) {
        this.drawArc(x, y, width, height, 0, 360);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (arcWidth > width) {
            arcWidth = width;
        }
        if (arcHeight > height) {
            arcHeight = height;
        }
        int xx = x + width - arcWidth;
        int yy = y + height - arcHeight;
        this.drawArc(x, y, arcWidth, arcHeight, 90, 90);
        this.drawArc(xx, y, arcWidth, arcHeight, 0, 90);
        this.drawArc(xx, yy, arcWidth, arcHeight, 270, 90);
        this.drawArc(x, yy, arcWidth, arcHeight, 180, 90);
        int y1 = y + arcHeight / 2;
        int y2 = y + height - arcHeight / 2;
        this.drawLine(x, y1, x, y2);
        this.drawLine(x + width, y1, x + width, y2);
        int x1 = x + arcWidth / 2;
        int x2 = x + width - arcWidth / 2;
        this.drawLine(x1, y, x2, y);
        this.drawLine(x1, y + height, x2, y + height);
    }

    public void drawString(String str, int x, int y) {
        this.drawString(str, (float)x, (float)y);
    }

    public void drawString(String str, float x, float y) {
        GlyphVector gv = this.font.createGlyphVector(this.getFontRenderContext(), str);
        this.drawGlyphVector(gv, x, y);
    }

    public void drawString(AttributedCharacterIterator ci, int x, int y) {
        this.drawString(ci, (float)x, (float)y);
    }

    public void drawString(AttributedCharacterIterator ci, float x, float y) {
        GlyphVector gv = this.font.createGlyphVector(this.getFontRenderContext(), ci);
        this.drawGlyphVector(gv, x, y);
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, startAngle, arcAngle, 0));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fillArc(x, y, width, height, 0, 360);
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (arcWidth > width) {
            arcWidth = width;
        }
        if (arcHeight > height) {
            arcHeight = height;
        }
        int xx = x + width - arcWidth;
        int yy = y + height - arcHeight;
        this.fillArc(x, y, arcWidth, arcHeight, 90, 90);
        this.fillArc(xx, y, arcWidth, arcHeight, 0, 90);
        this.fillArc(xx, yy, arcWidth, arcHeight, 270, 90);
        this.fillArc(x, yy, arcWidth, arcHeight, 180, 90);
        this.fillRect(x, y + arcHeight / 2, width, height - arcHeight + 1);
        this.fillRect(x + arcWidth / 2, y, width - arcWidth + 1, height);
    }

    public Font getFont() {
        return this.font;
    }

    public FontMetrics getFontMetrics() {
        return Toolkit.getDefaultToolkit().getFontMetrics(this.font);
    }

    public FontMetrics getFontMetrics(Font f) {
        return Toolkit.getDefaultToolkit().getFontMetrics(f);
    }

    public void setFont(Font f) {
        this.font = f.getPeer() instanceof GdkClasspathFontPeer ? f : ((ClasspathToolkit)Toolkit.getDefaultToolkit()).getFont(f.getName(), f.getAttributes());
        if (f != null && f.getPeer() instanceof GdkClasspathFontPeer) {
            this.cairoSetFont((GdkClasspathFontPeer)f.getPeer());
        }
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.font.toString() + ",color=" + this.fg.toString() + "]";
    }

    static {
        if (Configuration.INIT_LOAD_LIBRARY) {
            System.loadLibrary("gtkpeer");
        }
        if (GtkToolkit.useGraphics2D()) {
            GdkGraphics2D.initStaticState();
        }
    }

    private class PainterThread
    implements Runnable,
    ImageConsumer {
        private /* synthetic */ GdkGraphics2D this$0;
        GdkGraphics2D gr;
        Image image;
        ColorModel defaultModel;
        AffineTransform xform;
        Color bgcolor;

        public PainterThread(GdkGraphics2D this$0, GdkGraphics2D g, Image im, AffineTransform xf, Color bg) {
            this.this$0 = this$0;
            this.image = im;
            this.xform = xf;
            this.bgcolor = bg;
            this.gr = (GdkGraphics2D)g.create();
            new Thread(this).start();
        }

        public void imageComplete(int status) {
        }

        public void setColorModel(ColorModel model) {
            this.defaultModel = model;
        }

        public void setDimensions(int width, int height) {
        }

        public void setHints(int hintflags) {
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int off, int scansize) {
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int off, int scansize) {
            int[] pixels2;
            this.gr.stateSave();
            this.gr.translate(x, y);
            if (model == null) {
                model = this.defaultModel;
            }
            if (model != null) {
                pixels2 = new int[pixels.length];
                for (int yy = 0; yy < h; ++yy) {
                    for (int xx = 0; xx < w; ++xx) {
                        int i = yy * scansize + xx;
                        pixels2[i] = model.getRGB(pixels[i]);
                    }
                }
            } else {
                pixels2 = pixels;
            }
            if (this.bgcolor != null) {
                for (int i = 0; i < pixels2.length; ++i) {
                    if (model.getAlpha(pixels2[i]) != 0) continue;
                    pixels2[i] = this.bgcolor.getRGB();
                }
            }
            double[] xf = new double[6];
            this.xform.getMatrix(xf);
            this.gr.drawPixels(pixels2, w, h, scansize, xf);
            this.gr.stateRestore();
        }

        public void setProperties(Hashtable props) {
        }

        public void run() {
            this.image.getSource().startProduction(this);
            this.gr.dispose();
        }
    }

    private class DrawState {
        private /* synthetic */ GdkGraphics2D this$0;
        private Paint paint;
        private Stroke stroke;
        private Color fg;
        private Color bg;
        private Shape clip;
        private AffineTransform transform;
        private Font font;

        DrawState(GdkGraphics2D this$0, GdkGraphics2D g) {
            this.this$0 = this$0;
            this.paint = g.paint;
            this.stroke = g.stroke;
            this.fg = g.fg;
            this.bg = g.bg;
            this.clip = g.clip;
            if (g.transform != null) {
                this.transform = (AffineTransform)g.transform.clone();
            }
            this.font = g.font;
        }

        public void restore(GdkGraphics2D g) {
            g.paint = this.paint;
            g.stroke = this.stroke;
            g.fg = this.fg;
            g.bg = this.bg;
            g.clip = this.clip;
            g.transform = this.transform;
            g.font = this.font;
        }
    }
}

