/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Configuration;
import gnu.java.awt.image.ImageDecoder;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

public class GdkPixbufDecoder
extends ImageDecoder {
    private final int native_state;
    Vector curr;
    static final ColorModel cm;

    private /* synthetic */ void finit$() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
    }

    static native void initStaticState();

    native void initState();

    native void pumpBytes(byte[] var1, int var2);

    native void finish();

    public GdkPixbufDecoder(String filename) {
        super(filename);
        this.finit$();
    }

    public GdkPixbufDecoder(URL url) {
        super(url);
        this.finit$();
    }

    public GdkPixbufDecoder(byte[] imagedata, int imageoffset, int imagelength) {
        super(imagedata, imageoffset, imagelength);
        this.finit$();
    }

    void areaPrepared(int width, int height) {
        if (this.curr == null) {
            return;
        }
        for (int i = 0; i < this.curr.size(); ++i) {
            ImageConsumer ic = (ImageConsumer)this.curr.elementAt(i);
            ic.setDimensions(width, height);
            ic.setColorModel(cm);
            ic.setHints(1);
        }
    }

    void areaUpdated(int x, int y, int width, int height, int[] pixels, int scansize) {
        if (this.curr == null) {
            return;
        }
        for (int i = 0; i < this.curr.size(); ++i) {
            ImageConsumer ic = (ImageConsumer)this.curr.elementAt(i);
            ic.setPixels(x, y, width, height, cm, pixels, 0, scansize);
        }
    }

    public void produce(Vector v, InputStream is) throws IOException {
        this.curr = v;
        byte[] bytes = new byte[4096];
        int len = 0;
        this.initState();
        while ((len = is.read(bytes)) != -1) {
            this.pumpBytes(bytes, len);
        }
        for (int i = 0; i < this.curr.size(); ++i) {
            ImageConsumer ic = (ImageConsumer)this.curr.elementAt(i);
            ic.imageComplete(3);
        }
        this.curr = null;
    }

    public static BufferedImage createBufferedImage(String filename) {
        BufferedImageBuilder bb = new BufferedImageBuilder();
        GdkPixbufDecoder dec = new GdkPixbufDecoder(filename);
        dec.startProduction(bb);
        return bb.getBufferedImage();
    }

    public static BufferedImage createBufferedImage(URL u) {
        BufferedImageBuilder bb = new BufferedImageBuilder();
        GdkPixbufDecoder dec = new GdkPixbufDecoder(u);
        dec.startProduction(bb);
        return bb.getBufferedImage();
    }

    public static BufferedImage createBufferedImage(byte[] imagedata, int imageoffset, int imagelength) {
        BufferedImageBuilder bb = new BufferedImageBuilder();
        GdkPixbufDecoder dec = new GdkPixbufDecoder(imagedata, imageoffset, imagelength);
        dec.startProduction(bb);
        return bb.getBufferedImage();
    }

    public static BufferedImage createBufferedImage(ImageProducer producer) {
        BufferedImageBuilder bb = new BufferedImageBuilder();
        producer.startProduction(bb);
        return bb.getBufferedImage();
    }

    static {
        if (Configuration.INIT_LOAD_LIBRARY) {
            System.loadLibrary("gtkpeer");
        }
        GdkPixbufDecoder.initStaticState();
        cm = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
    }

    private static class BufferedImageBuilder
    implements ImageConsumer {
        BufferedImage bufferedImage;
        ColorModel defaultModel;

        public BufferedImage getBufferedImage() {
            return this.bufferedImage;
        }

        public void setDimensions(int width, int height) {
            this.bufferedImage = new BufferedImage(width, height, 2);
        }

        public void setProperties(Hashtable props) {
        }

        public void setColorModel(ColorModel model) {
            this.defaultModel = model;
        }

        public void setHints(int flags) {
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
            if (this.bufferedImage != null) {
                int[] pixels2;
                if (model == null) {
                    model = this.defaultModel;
                }
                if (model != null) {
                    pixels2 = new int[pixels.length];
                    for (int yy = 0; yy < h; ++yy) {
                        for (int xx = 0; xx < w; ++xx) {
                            int i = yy * scansize + xx;
                            pixels2[i] = model.getRGB(pixels[i]);
                        }
                    }
                } else {
                    pixels2 = pixels;
                }
                this.bufferedImage.setRGB(x, y, w, h, pixels2, offset, scansize);
            }
        }

        public void imageComplete(int status) {
        }

        BufferedImageBuilder() {
        }
    }
}

