/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkContainerPeer;
import gnu.java.awt.peer.gtk.GtkDialogPeer;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Graphics;
import java.awt.Window;
import java.awt.peer.FileDialogPeer;
import java.io.File;
import java.io.FilenameFilter;

public class GtkFileDialogPeer
extends GtkDialogPeer
implements FileDialogPeer {
    static final String FS = System.getProperty("file.separator");
    private String currentFile;
    private String currentDirectory;
    private FilenameFilter filter;

    private /* synthetic */ void finit$() {
        this.currentFile = null;
        this.currentDirectory = null;
    }

    native void create(GtkContainerPeer var1);

    native void connectJObject();

    native void connectSignals();

    native void nativeSetFile(String var1);

    public native String nativeGetDirectory();

    public native void nativeSetDirectory(String var1);

    native void nativeSetFilenameFilter(FilenameFilter var1);

    public void create() {
        this.create((GtkContainerPeer)this.awtComponent.getParent().getPeer());
        FileDialog fd = (FileDialog)this.awtComponent;
        this.setDirectory(fd.getDirectory());
        this.setFile(fd.getFile());
        FilenameFilter filter = fd.getFilenameFilter();
        if (filter != null) {
            this.setFilenameFilter(filter);
        }
    }

    public GtkFileDialogPeer(FileDialog fd) {
        super(fd);
        this.finit$();
    }

    void setComponentBounds() {
        if (this.awtComponent.getHeight() == 0 && this.awtComponent.getWidth() == 0) {
            int[] dims = new int[2];
            this.gtkWidgetGetPreferredDimensions(dims);
            this.setBoundsCallback((Window)this.awtComponent, this.awtComponent.getX(), this.awtComponent.getY(), dims[0], dims[1]);
        }
    }

    public void setFile(String fileName) {
        if (fileName == null && this.currentFile == null || fileName != null && fileName.equals(this.currentFile)) {
            return;
        }
        if (fileName == null || fileName.equals("")) {
            this.currentFile = "";
            this.nativeSetFile("");
            return;
        }
        this.currentFile = fileName;
        if (fileName.indexOf(FS) == 0) {
            this.nativeSetFile(fileName);
        } else {
            this.nativeSetFile(this.nativeGetDirectory() + FS + fileName);
        }
    }

    public void setDirectory(String directory) {
        if (directory == null && this.currentDirectory == null || directory != null && directory.equals(this.currentDirectory)) {
            return;
        }
        if (directory == null || directory.equals("")) {
            this.currentDirectory = FS;
            this.nativeSetFile(FS);
            return;
        }
        this.currentDirectory = directory;
        this.nativeSetDirectory(directory);
    }

    public void setFilenameFilter(FilenameFilter filter) {
        this.filter = filter;
        this.nativeSetFilenameFilter(filter);
    }

    boolean filenameFilterCallback(String fullname) {
        String filename = fullname.substring(fullname.lastIndexOf(FS) + 1);
        String dirname = fullname.substring(0, fullname.lastIndexOf(FS));
        File dir = new File(dirname);
        return this.filter.accept(dir, filename);
    }

    public Graphics getGraphics() {
        return null;
    }

    void gtkHideFileDialog() {
        ((Dialog)this.awtComponent).hide();
    }

    void gtkDisposeFileDialog() {
        ((Dialog)this.awtComponent).dispose();
    }

    void gtkSetFilename(String fileName) {
        FileDialog fd = (FileDialog)this.awtWidget;
        if (fileName == null) {
            this.currentFile = null;
            fd.setFile(null);
            return;
        }
        int sepIndex = fileName.lastIndexOf(FS);
        if (sepIndex < 0) {
            this.currentFile = fileName;
        } else {
            String dn;
            String fn;
            this.currentFile = fileName.length() > sepIndex + 1 ? (fn = fileName.substring(sepIndex + 1)) : null;
            this.currentDirectory = dn = fileName.substring(0, sepIndex + 1);
            fd.setDirectory(dn);
        }
        fd.setFile(this.currentFile);
    }
}

