/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkGraphics;
import gnu.java.awt.peer.gtk.GdkGraphics2D;
import gnu.java.awt.peer.gtk.GdkPixbufDecoder;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkToolkit;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.PaintEvent;
import java.awt.image.ColorModel;
import java.awt.peer.FramePeer;
import java.awt.peer.MenuBarPeer;

public class GtkFramePeer
extends GtkWindowPeer
implements FramePeer {
    private int menuBarHeight;
    private MenuBarPeer menuBar;

    native int getMenuBarHeight(MenuBarPeer var1);

    native void setMenuBarPeer(MenuBarPeer var1);

    native void removeMenuBarPeer();

    native void moveLayout(int var1);

    native void gtkLayoutSetVisible(boolean var1);

    public void setMenuBar(MenuBar bar) {
        if (bar == null) {
            if (this.menuBar != null) {
                this.gtkLayoutSetVisible(false);
                this.removeMenuBarPeer();
                this.menuBar = null;
                this.moveLayout(this.menuBarHeight);
                this.insets.top -= this.menuBarHeight;
                this.menuBarHeight = 0;
                this.awtComponent.doLayout();
                this.gtkLayoutSetVisible(true);
            }
        } else {
            this.gtkLayoutSetVisible(false);
            int oldHeight = 0;
            if (this.menuBar != null) {
                this.removeMenuBarPeer();
                oldHeight = this.menuBarHeight;
                this.insets.top -= this.menuBarHeight;
            }
            this.menuBar = (MenuBarPeer)bar.getPeer();
            this.setMenuBarPeer(this.menuBar);
            this.menuBarHeight = this.getMenuBarHeight(this.menuBar);
            if (oldHeight != this.menuBarHeight) {
                this.moveLayout(oldHeight - this.menuBarHeight);
            }
            this.insets.top += this.menuBarHeight;
            this.awtComponent.doLayout();
            this.gtkLayoutSetVisible(true);
        }
    }

    public void setBounds(int x, int y, int width, int height) {
        this.nativeSetBounds(x, y, width - this.insets.left - this.insets.right, height - this.insets.top - this.insets.bottom + this.menuBarHeight);
    }

    public void setResizable(boolean resizable) {
        this.setSize(this.awtComponent.getWidth() - this.insets.left - this.insets.right, this.awtComponent.getHeight() - this.insets.top - this.insets.bottom + this.menuBarHeight);
        this.gtkWindowSetResizable(resizable);
    }

    protected void postInsetsChangedEvent(int top, int left, int bottom, int right) {
        this.insets.top = top + this.menuBarHeight;
        this.insets.left = left;
        this.insets.bottom = bottom;
        this.insets.right = right;
    }

    public GtkFramePeer(Frame frame) {
        super(frame);
    }

    void create() {
        this.create(0, true);
        Frame frame = (Frame)this.awtComponent;
        this.setMenuBar(frame.getMenuBar());
        this.setTitle(frame.getTitle());
        this.setResizable(frame.isResizable());
        this.setIconImage(frame.getIconImage());
    }

    native void nativeSetIconImageFromDecoder(GdkPixbufDecoder var1);

    native void nativeSetIconImageFromData(int[] var1, int var2, int var3);

    public void setIconImage(Image image) {
        GtkImage img;
        if (image != null && (img = (GtkImage)image).isLoaded()) {
            if (img.getSource() instanceof GdkPixbufDecoder) {
                this.nativeSetIconImageFromDecoder((GdkPixbufDecoder)img.getSource());
            } else {
                int[] pixels = img.getPixelCache();
                ColorModel model = img.getColorModel();
                int[] data = new int[pixels.length * 4];
                for (int i = 0; i < pixels.length; ++i) {
                    data[i * 4] = model.getRed(pixels[i]);
                    data[i * 4 + 1] = model.getGreen(pixels[i]);
                    data[i * 4 + 2] = model.getBlue(pixels[i]);
                    data[i * 4 + 3] = model.getAlpha(pixels[i]);
                }
                this.nativeSetIconImageFromData(data, img.getWidth(null), img.getHeight(null));
            }
        }
    }

    public Graphics getGraphics() {
        Graphics g = GtkToolkit.useGraphics2D() ? new GdkGraphics2D(this) : new GdkGraphics(this);
        g.translate(-this.insets.left, -this.insets.top);
        return g;
    }

    protected void postConfigureEvent(int x, int y, int width, int height) {
        int frame_x = x - this.insets.left;
        int frame_y = y - this.insets.top + this.menuBarHeight;
        int frame_width = width + this.insets.left + this.insets.right;
        int frame_height = height + this.insets.top + this.insets.bottom - this.menuBarHeight;
        if (frame_x != this.awtComponent.getX() || frame_y != this.awtComponent.getY() || frame_width != this.awtComponent.getWidth() || frame_height != this.awtComponent.getHeight()) {
            this.setBoundsCallback((Window)this.awtComponent, frame_x, frame_y, frame_width, frame_height);
        }
        this.awtComponent.validate();
    }

    protected void postMouseEvent(int id, long when, int mods, int x, int y, int clickCount, boolean popupTrigger) {
        super.postMouseEvent(id, when, mods, x + this.insets.left, y + this.insets.top, clickCount, popupTrigger);
    }

    protected void postExposeEvent(int x, int y, int width, int height) {
        GtkGenericPeer.q.postEvent(new PaintEvent(this.awtComponent, 800, new Rectangle(x + this.insets.left, y + this.insets.top, width, height)));
    }

    public int getState() {
        return 0;
    }

    public void setState(int state) {
    }

    public void setMaximizedBounds(Rectangle r) {
    }
}

