/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkClasspathFontPeerMetrics;
import gnu.java.awt.peer.gtk.GdkFontMetrics;
import gnu.java.awt.peer.gtk.GtkTextComponentPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.TextArea;
import java.awt.peer.TextAreaPeer;

public class GtkTextAreaPeer
extends GtkTextComponentPeer
implements TextAreaPeer {
    private static transient int DEFAULT_ROWS = 10;
    private static transient int DEFAULT_COLS = 80;

    native void create(int var1, int var2, int var3);

    native void gtkSetFont(String var1, int var2, int var3);

    native void gtkWidgetRequestFocus();

    void create() {
        Font f = this.awtComponent.getFont();
        if (f == null) {
            f = new Font("Dialog", 0, 12);
            this.awtComponent.setFont(f);
        }
        FontMetrics fm = GtkToolkit.useGraphics2D() ? new GdkClasspathFontPeerMetrics(f) : new GdkFontMetrics(f);
        TextArea ta = (TextArea)this.awtComponent;
        int sizeRows = ta.getRows();
        int sizeCols = ta.getColumns();
        sizeRows = sizeRows == 0 ? DEFAULT_ROWS : sizeRows;
        sizeCols = sizeCols == 0 ? DEFAULT_COLS : sizeCols;
        int width = sizeCols * fm.getMaxAdvance();
        int height = sizeRows * (fm.getMaxDescent() + fm.getMaxAscent());
        this.create(width, height, ta.getScrollbarVisibility());
        this.setEditable(ta.isEditable());
    }

    public GtkTextAreaPeer(TextArea ta) {
        super(ta);
    }

    public native void insert(String var1, int var2);

    public native void replaceRange(String var1, int var2, int var3);

    public Dimension getMinimumSize(int rows, int cols) {
        return this.minimumSize(rows == 0 ? DEFAULT_ROWS : rows, cols == 0 ? DEFAULT_COLS : cols);
    }

    public Dimension getPreferredSize(int rows, int cols) {
        return this.preferredSize(rows == 0 ? DEFAULT_ROWS : rows, cols == 0 ? DEFAULT_COLS : cols);
    }

    native int getHScrollbarHeight();

    native int getVScrollbarWidth();

    public Dimension minimumSize(int rows, int cols) {
        Font f;
        TextArea ta = (TextArea)this.awtComponent;
        int height = 0;
        int width = 0;
        if (ta.getScrollbarVisibility() == 0 || ta.getScrollbarVisibility() == 2) {
            height = this.getHScrollbarHeight();
        }
        if (ta.getScrollbarVisibility() == 0 || ta.getScrollbarVisibility() == 1) {
            width = this.getVScrollbarWidth();
        }
        if ((f = this.awtComponent.getFont()) == null) {
            return new Dimension(width, height);
        }
        FontMetrics fm = GtkToolkit.useGraphics2D() ? new GdkClasspathFontPeerMetrics(f) : new GdkFontMetrics(f);
        int sizeRows = rows == 0 ? DEFAULT_ROWS : rows;
        int sizeCols = cols == 0 ? DEFAULT_COLS : cols;
        return new Dimension(width += sizeCols * fm.getMaxAdvance(), height += sizeRows * (fm.getMaxDescent() + fm.getMaxAscent()));
    }

    public Dimension preferredSize(int rows, int cols) {
        Font f;
        TextArea ta = (TextArea)this.awtComponent;
        int height = 0;
        int width = 0;
        if (ta.getScrollbarVisibility() == 0 || ta.getScrollbarVisibility() == 2) {
            height = this.getHScrollbarHeight();
        }
        if (ta.getScrollbarVisibility() == 0 || ta.getScrollbarVisibility() == 1) {
            width = this.getVScrollbarWidth();
        }
        if ((f = this.awtComponent.getFont()) == null) {
            return new Dimension(width, height);
        }
        FontMetrics fm = GtkToolkit.useGraphics2D() ? new GdkClasspathFontPeerMetrics(f) : new GdkFontMetrics(f);
        int sizeRows = rows == 0 ? DEFAULT_ROWS : rows;
        int sizeCols = cols == 0 ? DEFAULT_COLS : cols;
        return new Dimension(width += sizeCols * fm.getMaxAdvance(), height += sizeRows * (fm.getMaxDescent() + fm.getMaxAscent()));
    }

    public void replaceText(String str, int start, int end) {
        this.replaceRange(str, start, end);
    }

    public void insertText(String str, int pos) {
        this.insert(str, pos);
    }
}

