/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GdkClasspathFontPeerMetrics;
import gnu.java.awt.peer.gtk.GdkFontMetrics;
import gnu.java.awt.peer.gtk.GtkTextComponentPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.peer.TextFieldPeer;

public class GtkTextFieldPeer
extends GtkTextComponentPeer
implements TextFieldPeer {
    native void create(int var1);

    native void gtkWidgetSetBackground(int var1, int var2, int var3);

    native void gtkWidgetSetForeground(int var1, int var2, int var3);

    void create() {
        Font f = this.awtComponent.getFont();
        if (f == null) {
            f = new Font("Dialog", 0, 12);
            this.awtComponent.setFont(f);
        }
        FontMetrics fm = GtkToolkit.useGraphics2D() ? new GdkClasspathFontPeerMetrics(f) : new GdkFontMetrics(f);
        TextField tf = (TextField)this.awtComponent;
        int cols = tf.getColumns();
        int text_width = cols * fm.getMaxAdvance();
        this.create(text_width);
        this.setEditable(tf.isEditable());
    }

    native int gtkEntryGetBorderWidth();

    native void gtkSetFont(String var1, int var2, int var3);

    public GtkTextFieldPeer(TextField tf) {
        super(tf);
        if (tf.echoCharIsSet()) {
            this.setEchoChar(tf.getEchoChar());
        }
    }

    public Dimension getMinimumSize(int cols) {
        return this.minimumSize(cols);
    }

    public Dimension getPreferredSize(int cols) {
        return this.preferredSize(cols);
    }

    public native void setEchoChar(char var1);

    public Dimension minimumSize(int cols) {
        int[] dim = new int[2];
        this.gtkWidgetGetPreferredDimensions(dim);
        Font f = this.awtComponent.getFont();
        if (f == null) {
            return new Dimension(2 * this.gtkEntryGetBorderWidth(), dim[1]);
        }
        FontMetrics fm = GtkToolkit.useGraphics2D() ? new GdkClasspathFontPeerMetrics(f) : new GdkFontMetrics(f);
        int text_width = cols * fm.getMaxAdvance();
        int width = text_width + 2 * this.gtkEntryGetBorderWidth();
        return new Dimension(width, dim[1]);
    }

    public Dimension preferredSize(int cols) {
        int[] dim = new int[2];
        this.gtkWidgetGetPreferredDimensions(dim);
        Font f = this.awtComponent.getFont();
        if (f == null) {
            return new Dimension(2 * this.gtkEntryGetBorderWidth(), dim[1]);
        }
        FontMetrics fm = GtkToolkit.useGraphics2D() ? new GdkClasspathFontPeerMetrics(f) : new GdkFontMetrics(f);
        int text_width = cols * fm.getMaxAdvance();
        int width = text_width + 2 * this.gtkEntryGetBorderWidth();
        return new Dimension(width, dim[1]);
    }

    public void setEchoCharacter(char c) {
        this.setEchoChar(c);
    }

    public void handleEvent(AWTEvent e) {
        KeyEvent ke;
        if (e.getID() == 401 && !(ke = (KeyEvent)e).isConsumed() && ke.getKeyCode() == 10) {
            this.postActionEvent(this.getText(), ke.getModifiersEx());
        }
        super.handleEvent(e);
    }
}

