/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Configuration;
import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.EmbeddedWindow;
import gnu.java.awt.EmbeddedWindowSupport;
import gnu.java.awt.peer.ClasspathFontPeer;
import gnu.java.awt.peer.EmbeddedWindowPeer;
import gnu.java.awt.peer.gtk.GdkClasspathFontPeer;
import gnu.java.awt.peer.gtk.GdkClasspathFontPeerMetrics;
import gnu.java.awt.peer.gtk.GdkFontMetrics;
import gnu.java.awt.peer.gtk.GdkGraphicsEnvironment;
import gnu.java.awt.peer.gtk.GdkPixbufDecoder;
import gnu.java.awt.peer.gtk.GtkButtonPeer;
import gnu.java.awt.peer.gtk.GtkCanvasPeer;
import gnu.java.awt.peer.gtk.GtkCheckboxMenuItemPeer;
import gnu.java.awt.peer.gtk.GtkCheckboxPeer;
import gnu.java.awt.peer.gtk.GtkChoicePeer;
import gnu.java.awt.peer.gtk.GtkClipboard;
import gnu.java.awt.peer.gtk.GtkComponentPeer;
import gnu.java.awt.peer.gtk.GtkDialogPeer;
import gnu.java.awt.peer.gtk.GtkEmbeddedWindowPeer;
import gnu.java.awt.peer.gtk.GtkFileDialogPeer;
import gnu.java.awt.peer.gtk.GtkFontPeer;
import gnu.java.awt.peer.gtk.GtkFramePeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import gnu.java.awt.peer.gtk.GtkImage;
import gnu.java.awt.peer.gtk.GtkLabelPeer;
import gnu.java.awt.peer.gtk.GtkListPeer;
import gnu.java.awt.peer.gtk.GtkMainThread;
import gnu.java.awt.peer.gtk.GtkMenuBarPeer;
import gnu.java.awt.peer.gtk.GtkMenuItemPeer;
import gnu.java.awt.peer.gtk.GtkMenuPeer;
import gnu.java.awt.peer.gtk.GtkPanelPeer;
import gnu.java.awt.peer.gtk.GtkPopupMenuPeer;
import gnu.java.awt.peer.gtk.GtkScrollPanePeer;
import gnu.java.awt.peer.gtk.GtkScrollbarPeer;
import gnu.java.awt.peer.gtk.GtkTextAreaPeer;
import gnu.java.awt.peer.gtk.GtkTextFieldPeer;
import gnu.java.awt.peer.gtk.GtkToolkit;
import gnu.java.awt.peer.gtk.GtkWindowPeer;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.io.InputStream;
import java.net.URL;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class GtkToolkit
extends ClasspathToolkit
implements EmbeddedWindowSupport {
    GtkMainThread main;
    Hashtable containers;
    static EventQueue q = new EventQueue();
    static Clipboard systemClipboard;
    static boolean useGraphics2dSet;
    static boolean useGraphics2d;

    private /* synthetic */ void finit$() {
        this.containers = new Hashtable();
    }

    public static boolean useGraphics2D() {
        if (useGraphics2dSet) {
            return useGraphics2d;
        }
        useGraphics2d = System.getProperty("gnu.java.awt.peer.gtk.Graphics", "Graphics").equals("Graphics2D");
        useGraphics2dSet = true;
        return useGraphics2d;
    }

    public GtkToolkit() {
        this.finit$();
        this.main = new GtkMainThread();
        systemClipboard = new GtkClipboard();
        GtkGenericPeer.enableQueue(q);
    }

    public native void beep();

    private native void getScreenSizeDimensions(int[] var1);

    public int checkImage(Image image, int width, int height, ImageObserver observer) {
        int status = ((GtkImage)image).checkImage();
        if (observer != null) {
            observer.imageUpdate(image, status, -1, -1, image.getWidth(observer), image.getHeight(observer));
        }
        return status;
    }

    private Image bufferedImageOrError(BufferedImage b) {
        if (b == null) {
            return new GtkErrorImage(this);
        }
        return b;
    }

    public Image createImage(String filename) {
        if (GtkToolkit.useGraphics2D()) {
            return this.bufferedImageOrError(GdkPixbufDecoder.createBufferedImage(filename));
        }
        GdkPixbufDecoder d = new GdkPixbufDecoder(filename);
        GtkImage image = new GtkImage(d, null);
        d.startProduction(image);
        return image;
    }

    public Image createImage(URL url) {
        if (GtkToolkit.useGraphics2D()) {
            return this.bufferedImageOrError(GdkPixbufDecoder.createBufferedImage(url));
        }
        GdkPixbufDecoder d = new GdkPixbufDecoder(url);
        GtkImage image = new GtkImage(d, null);
        d.startProduction(image);
        return image;
    }

    public Image createImage(ImageProducer producer) {
        if (GtkToolkit.useGraphics2D()) {
            return this.bufferedImageOrError(GdkPixbufDecoder.createBufferedImage(producer));
        }
        GtkImage image = new GtkImage(producer, null);
        producer.startProduction(image);
        return image;
    }

    public Image createImage(byte[] imagedata, int imageoffset, int imagelength) {
        if (GtkToolkit.useGraphics2D()) {
            return this.bufferedImageOrError(GdkPixbufDecoder.createBufferedImage(imagedata, imageoffset, imagelength));
        }
        GdkPixbufDecoder d = new GdkPixbufDecoder(imagedata, imageoffset, imagelength);
        GtkImage image = new GtkImage(d, null);
        d.startProduction(image);
        return image;
    }

    public ImageProducer createImageProducer(URL url) {
        return new GdkPixbufDecoder(url);
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public String[] getFontList() {
        return new String[]{"Dialog", "DialogInput", "Monospaced", "Serif", "SansSerif"};
    }

    public FontMetrics getFontMetrics(Font font) {
        if (GtkToolkit.useGraphics2D()) {
            return new GdkClasspathFontPeerMetrics(font);
        }
        return new GdkFontMetrics(font);
    }

    public Image getImage(String filename) {
        return this.createImage(filename);
    }

    public Image getImage(URL url) {
        return this.createImage(url);
    }

    public PrintJob getPrintJob(Frame frame, String jobtitle, Properties props) {
        return null;
    }

    public native int getScreenResolution();

    public Dimension getScreenSize() {
        int[] dim = new int[2];
        this.getScreenSizeDimensions(dim);
        return new Dimension(dim[0], dim[1]);
    }

    public Clipboard getSystemClipboard() {
        return systemClipboard;
    }

    public boolean prepareImage(Image image, int width, int height, ImageObserver observer) {
        GtkImage i = (GtkImage)image;
        if (i.isLoaded()) {
            return true;
        }
        new 2.PrepareImage(this, i, observer).start();
        return false;
    }

    public native void sync();

    protected void setComponentState(Component c, GtkComponentPeer cp) {
        if (c.getForeground() == null) {
            c.setForeground(cp.getForeground());
        }
        if (c.getBackground() == null) {
            c.setBackground(cp.getBackground());
        }
        if (!(c instanceof Window)) {
            cp.setCursor(c.getCursor());
            Rectangle bounds = c.getBounds();
            cp.setBounds(bounds.x, bounds.y, bounds.width, bounds.height);
            cp.setVisible(c.isVisible());
        }
    }

    protected ButtonPeer createButton(Button b) {
        return new GtkButtonPeer(b);
    }

    protected CanvasPeer createCanvas(Canvas c) {
        return new GtkCanvasPeer(c);
    }

    protected CheckboxPeer createCheckbox(Checkbox cb) {
        return new GtkCheckboxPeer(cb);
    }

    protected CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem cmi) {
        return new GtkCheckboxMenuItemPeer(cmi);
    }

    protected ChoicePeer createChoice(Choice c) {
        return new GtkChoicePeer(c);
    }

    protected DialogPeer createDialog(Dialog d) {
        return new GtkDialogPeer(d);
    }

    protected FileDialogPeer createFileDialog(FileDialog fd) {
        return new GtkFileDialogPeer(fd);
    }

    protected FramePeer createFrame(Frame f) {
        return new GtkFramePeer(f);
    }

    protected LabelPeer createLabel(Label label) {
        return new GtkLabelPeer(label);
    }

    protected ListPeer createList(List list) {
        return new GtkListPeer(list);
    }

    protected MenuPeer createMenu(Menu m) {
        return new GtkMenuPeer(m);
    }

    protected MenuBarPeer createMenuBar(MenuBar mb) {
        return new GtkMenuBarPeer(mb);
    }

    protected MenuItemPeer createMenuItem(MenuItem mi) {
        return new GtkMenuItemPeer(mi);
    }

    protected PanelPeer createPanel(Panel p) {
        return new GtkPanelPeer(p);
    }

    protected PopupMenuPeer createPopupMenu(PopupMenu target) {
        return new GtkPopupMenuPeer(target);
    }

    protected ScrollPanePeer createScrollPane(ScrollPane sp) {
        return new GtkScrollPanePeer(sp);
    }

    protected ScrollbarPeer createScrollbar(Scrollbar sb) {
        return new GtkScrollbarPeer(sb);
    }

    protected TextAreaPeer createTextArea(TextArea ta) {
        return new GtkTextAreaPeer(ta);
    }

    protected TextFieldPeer createTextField(TextField tf) {
        return new GtkTextFieldPeer(tf);
    }

    protected WindowPeer createWindow(Window w) {
        return new GtkWindowPeer(w);
    }

    public EmbeddedWindowPeer createEmbeddedWindow(EmbeddedWindow w) {
        return new GtkEmbeddedWindowPeer(w);
    }

    protected FontPeer getFontPeer(String name, int style) {
        return this.getFontPeer(name, style, 12);
    }

    private FontPeer getFontPeer(String name, int style, int size) {
        GtkFontPeer fp = new GtkFontPeer(name, style, size);
        return fp;
    }

    public ClasspathFontPeer getClasspathFontPeer(String name, Map attrs) {
        Float posture;
        Float weight;
        if (GtkToolkit.useGraphics2D()) {
            return new GdkClasspathFontPeer(name, attrs);
        }
        int size = 12;
        int style = 0;
        if (name == null) {
            name = "Default";
        }
        if (attrs.containsKey(TextAttribute.WEIGHT) && (weight = (Float)attrs.get(TextAttribute.WEIGHT)).floatValue() >= TextAttribute.WEIGHT_BOLD.floatValue()) {
            ++style;
        }
        if (attrs.containsKey(TextAttribute.POSTURE) && (posture = (Float)attrs.get(TextAttribute.POSTURE)).floatValue() >= TextAttribute.POSTURE_OBLIQUE.floatValue()) {
            style += 2;
        }
        if (attrs.containsKey(TextAttribute.SIZE)) {
            Float fsize = (Float)attrs.get(TextAttribute.SIZE);
            size = fsize.intValue();
        }
        return (ClasspathFontPeer)this.getFontPeer(name, style, size);
    }

    protected EventQueue getSystemEventQueueImpl() {
        return q;
    }

    protected native void loadSystemColors(int[] var1);

    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent e) {
        throw new Error("not implemented");
    }

    public Map mapInputMethodHighlight(InputMethodHighlight highlight) {
        throw new Error("not implemented");
    }

    public GraphicsEnvironment getLocalGraphicsEnvironment() {
        GdkGraphicsEnvironment ge = new GdkGraphicsEnvironment();
        return ge;
    }

    public Font createFont(int format, InputStream stream) {
        throw new UnsupportedOperationException();
    }

    static {
        if (Configuration.INIT_LOAD_LIBRARY) {
            System.loadLibrary("gtkpeer");
        }
    }

    private class GtkErrorImage
    extends Image {
        private /* synthetic */ GtkToolkit this$0;

        public GtkErrorImage(GtkToolkit this$0) {
            this.this$0 = this$0;
        }

        public int getWidth(ImageObserver observer) {
            return -1;
        }

        public int getHeight(ImageObserver observer) {
            return -1;
        }

        public ImageProducer getSource() {
            return new ImageProducer(this){
                private /* synthetic */ GtkErrorImage this$1;
                HashSet consumers;
                {
                    this.this$1 = this$1;
                    this.finit$();
                }

                private /* synthetic */ void finit$() {
                    this.consumers = new HashSet();
                }

                public void addConsumer(ImageConsumer ic) {
                    this.consumers.add(ic);
                }

                public boolean isConsumer(ImageConsumer ic) {
                    return this.consumers.contains(ic);
                }

                public void removeConsumer(ImageConsumer ic) {
                    this.consumers.remove(ic);
                }

                public void startProduction(ImageConsumer ic) {
                    this.consumers.add(ic);
                    Iterator i = this.consumers.iterator();
                    while (i.hasNext()) {
                        ImageConsumer c = (ImageConsumer)i.next();
                        c.imageComplete(1);
                    }
                }

                public void requestTopDownLeftRightResend(ImageConsumer ic) {
                    this.startProduction(ic);
                }
            };
        }

        public Graphics getGraphics() {
            return null;
        }

        public Object getProperty(String name, ImageObserver observer) {
            return null;
        }

        public Image getScaledInstance(int width, int height, int flags) {
            return new GtkErrorImage(this.this$0);
        }

        public void flush() {
        }
    }
}

