/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.peer.gtk.GtkContainerPeer;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;

public class GtkWindowPeer
extends GtkContainerPeer
implements WindowPeer {
    protected static final int GDK_WINDOW_TYPE_HINT_NORMAL = 0;
    protected static final int GDK_WINDOW_TYPE_HINT_DIALOG = 1;
    protected static final int GDK_WINDOW_TYPE_HINT_MENU = 2;
    protected static final int GDK_WINDOW_TYPE_HINT_TOOLBAR = 3;
    protected static final int GDK_WINDOW_TYPE_HINT_SPLASHSCREEN = 4;
    protected static final int GDK_WINDOW_TYPE_HINT_UTILITY = 5;
    protected static final int GDK_WINDOW_TYPE_HINT_DOCK = 6;
    protected static final int GDK_WINDOW_TYPE_HINT_DESKTOP = 7;
    private boolean hasBeenShown;
    private int oldState;

    private /* synthetic */ void finit$() {
        this.hasBeenShown = false;
        this.oldState = 0;
    }

    native void gtkWindowSetTitle(String var1);

    native void gtkWindowSetResizable(boolean var1);

    native void gtkWindowSetModal(boolean var1);

    native void create(int var1, boolean var2, int var3, int var4, GtkWindowPeer var5, int[] var6);

    void create(int type, boolean decorated) {
        GtkWindowPeer parent_peer = null;
        Container parent = this.awtComponent.getParent();
        int[] insets = new int[]{0, 0, 0, 0};
        if (parent != null) {
            parent_peer = (GtkWindowPeer)this.awtComponent.getParent().getPeer();
        }
        this.create(type, decorated, this.awtComponent.getWidth(), this.awtComponent.getHeight(), parent_peer, insets);
        this.insets.top = insets[0];
        this.insets.left = insets[1];
        this.insets.bottom = insets[2];
        this.insets.right = insets[3];
    }

    void create() {
        this.create(0, false);
    }

    void setParent() {
        this.setVisible(this.awtComponent.isVisible());
        this.setEnabled(this.awtComponent.isEnabled());
    }

    void setVisibleAndEnabled() {
    }

    native void connectJObject();

    native void connectSignals();

    public GtkWindowPeer(Window window) {
        super(window);
        this.finit$();
    }

    public native void toBack();

    public native void toFront();

    native void nativeSetBounds(int var1, int var2, int var3, int var4);

    public void setBounds(int x, int y, int width, int height) {
        this.nativeSetBounds(x, y, width - this.insets.left - this.insets.right, height - this.insets.top - this.insets.bottom);
    }

    public void setTitle(String title) {
        this.gtkWindowSetTitle(title);
    }

    native void setSize(int var1, int var2);

    public void setResizable(boolean resizable) {
        this.setSize(this.awtComponent.getWidth() - this.insets.left - this.insets.right, this.awtComponent.getHeight() - this.insets.top - this.insets.bottom);
        this.gtkWindowSetResizable(resizable);
    }

    native void setBoundsCallback(Window var1, int var2, int var3, int var4, int var5);

    protected void postInsetsChangedEvent(int top, int left, int bottom, int right) {
        this.insets.top = top;
        this.insets.left = left;
        this.insets.bottom = bottom;
        this.insets.right = right;
    }

    protected void postConfigureEvent(int x, int y, int width, int height) {
        int frame_x = x - this.insets.left;
        int frame_y = y - this.insets.top;
        int frame_width = width + this.insets.left + this.insets.right;
        int frame_height = height + this.insets.top + this.insets.bottom;
        if (frame_x != this.awtComponent.getX() || frame_y != this.awtComponent.getY() || frame_width != this.awtComponent.getWidth() || frame_height != this.awtComponent.getHeight()) {
            this.setBoundsCallback((Window)this.awtComponent, frame_x, frame_y, frame_width, frame_height);
        }
        this.awtComponent.validate();
    }

    native void nativeSetVisible(boolean var1);

    public void setVisible(boolean b) {
        if (b) {
            this.setBounds(this.awtComponent.getX(), this.awtComponent.getY(), this.awtComponent.getWidth(), this.awtComponent.getHeight());
        }
        this.nativeSetVisible(b);
    }

    void postWindowEvent(int id, Window opposite, int newState) {
        if (id == 200) {
            if (!this.hasBeenShown) {
                GtkGenericPeer.q.postEvent(new WindowEvent((Window)this.awtComponent, id, opposite));
                this.hasBeenShown = true;
            }
        } else if (id == 209) {
            if (this.oldState != newState) {
                GtkGenericPeer.q.postEvent(new WindowEvent((Window)this.awtComponent, id, opposite, this.oldState, newState));
                this.oldState = newState;
            }
        } else {
            GtkGenericPeer.q.postEvent(new WindowEvent((Window)this.awtComponent, id, opposite));
        }
    }
}

