/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.ItemSelectable;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.peer.ChoicePeer;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;

public class Choice
extends Component
implements ItemSelectable,
Serializable {
    private static final long serialVersionUID = -4075310674757313071L;
    private Vector pItems;
    private int selectedIndex;
    private ItemListener item_listeners;

    private /* synthetic */ void finit$() {
        this.pItems = new Vector();
        this.selectedIndex = -1;
    }

    public Choice() {
        this.finit$();
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getItemCount() {
        return this.countItems();
    }

    public int countItems() {
        return this.pItems.size();
    }

    public String getItem(int index) {
        return (String)this.pItems.elementAt(index);
    }

    public synchronized void add(String item) {
        if (item == null) {
            throw new NullPointerException("item must be non-null");
        }
        this.pItems.addElement(item);
        int i = this.pItems.size() - 1;
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.add(item, i);
        }
    }

    public synchronized void addItem(String item) {
        this.add(item);
    }

    public synchronized void insert(String item, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index may not be less then 0");
        }
        if (index > this.getItemCount()) {
            index = this.getItemCount();
        }
        this.pItems.insertElementAt(item, index);
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.add(item, index);
        }
    }

    public synchronized void remove(String item) {
        int index = this.pItems.indexOf(item);
        if (index == -1) {
            throw new IllegalArgumentException("item \"" + item + "\" not found in Choice");
        }
        this.remove(index);
    }

    public synchronized void remove(int index) {
        if (index < 0 || index > this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + index);
        }
        this.pItems.removeElementAt(index);
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.remove(index);
        }
        if (this.selectedIndex > index) {
            --this.selectedIndex;
        }
    }

    public synchronized void removeAll() {
        if (this.getItemCount() <= 0) {
            return;
        }
        this.pItems.removeAllElements();
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.removeAll();
        }
        this.selectedIndex = -1;
    }

    public synchronized String getSelectedItem() {
        if (this.selectedIndex == -1) {
            return null;
        }
        return (String)this.pItems.elementAt(this.selectedIndex);
    }

    public synchronized Object[] getSelectedObjects() {
        if (this.selectedIndex == -1) {
            return null;
        }
        Object[] objs = new Object[]{this.pItems.elementAt(this.selectedIndex)};
        return objs;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public synchronized void select(int index) {
        if (index < 0 || index > this.getItemCount()) {
            throw new IllegalArgumentException("Bad index: " + index);
        }
        this.selectedIndex = index;
        if (this.peer != null) {
            ChoicePeer cp = (ChoicePeer)this.peer;
            cp.select(index);
        }
    }

    public synchronized void select(String item) {
        int index = this.pItems.indexOf(item);
        if (index >= 0) {
            this.select(index);
        }
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createChoice(this);
        }
        super.addNotify();
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.add(this.item_listeners, listener);
    }

    public synchronized void removeItemListener(ItemListener listener) {
        this.item_listeners = AWTEventMulticaster.remove(this.item_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ItemEvent) {
            this.processItemEvent((ItemEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processItemEvent(ItemEvent event) {
        if (this.item_listeners != null) {
            this.item_listeners.itemStateChanged(event);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 701 && e.id >= 701 && (this.item_listeners != null || (this.eventMask & (long)512) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected String paramString() {
        return "selectedIndex=" + this.selectedIndex + "," + super.paramString();
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == Choice.class$("java.awt.event.ItemListener")) {
            return AWTEventMulticaster.getListeners(this.item_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(Choice.class$("java.awt.event.ItemListener"));
    }
}

