/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.LightweightDispatcher;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.peer.ContainerPeer;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.accessibility.Accessible;

public class Container
extends Component {
    private static final long serialVersionUID = 4613797578919906343L;
    int ncomponents;
    Component[] component;
    LayoutManager layoutMgr;
    LightweightDispatcher dispatcher;
    Dimension maxSize;
    boolean focusCycleRoot;
    int containerSerializedDataVersion;
    transient ContainerListener containerListener;
    transient PropertyChangeSupport changeSupport;
    private FocusTraversalPolicy focusTraversalPolicy;
    transient Set[] focusTraversalKeys;

    public int getComponentCount() {
        return this.countComponents();
    }

    public int countComponents() {
        return this.ncomponents;
    }

    public Component getComponent(int n) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (n < 0 || n >= this.ncomponents) {
                    throw new ArrayIndexOutOfBoundsException("no such component");
                }
                Component component = this.component[n];
                Object var4_4 = null;
                return component;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public Component[] getComponents() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                Component[] result = new Component[this.ncomponents];
                if (this.ncomponents > 0) {
                    System.arraycopy(this.component, 0, result, 0, this.ncomponents);
                }
                Component[] componentArray = result;
                Object var4_4 = null;
                return componentArray;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    protected void swapComponents(int i, int j) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (i < 0 || i >= this.component.length || j < 0 || j >= this.component.length) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                Component tmp = this.component[i];
                this.component[i] = this.component[j];
                this.component[j] = tmp;
            }
            finally {
                Object var4_4 = null;
            }
            return;
        }
    }

    public Insets getInsets() {
        return this.insets();
    }

    public Insets insets() {
        if (this.peer == null) {
            return new Insets(0, 0, 0, 0);
        }
        return ((ContainerPeer)this.peer).getInsets();
    }

    public Component add(Component comp) {
        this.addImpl(comp, null, -1);
        return comp;
    }

    public Component add(String name, Component comp) {
        this.addImpl(comp, name, -1);
        return comp;
    }

    public Component add(Component comp, int index) {
        this.addImpl(comp, null, index);
        return comp;
    }

    public void add(Component comp, Object constraints) {
        this.addImpl(comp, constraints, -1);
    }

    public void add(Component comp, Object constraints, int index) {
        this.addImpl(comp, constraints, index);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (index > this.ncomponents || index < 0 && index != -1 || comp instanceof Window || comp instanceof Container && ((Container)comp).isAncestorOf(this)) {
                    throw new IllegalArgumentException();
                }
                if (comp.parent != null) {
                    comp.parent.remove(comp);
                }
                comp.parent = this;
                if (this.peer != null) {
                    comp.addNotify();
                    if (comp.isLightweight()) {
                        this.enableEvents(comp.eventMask);
                        if (!this.isLightweight()) {
                            this.enableEvents(8192);
                        }
                    }
                }
                this.invalidate();
                if (this.component == null) {
                    this.component = new Component[4];
                }
                if (this.ncomponents >= this.component.length) {
                    int nl = this.component.length * 2;
                    Component[] c = new Component[nl];
                    System.arraycopy(this.component, 0, c, 0, this.ncomponents);
                    this.component = c;
                }
                if (index == -1) {
                    this.component[this.ncomponents++] = comp;
                } else {
                    System.arraycopy(this.component, index, this.component, index + 1, this.ncomponents - index);
                    this.component[index] = comp;
                    ++this.ncomponents;
                }
                if (this.layoutMgr != null) {
                    if (this.layoutMgr instanceof LayoutManager2) {
                        LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
                        lm2.addLayoutComponent(comp, constraints);
                    } else if (constraints instanceof String) {
                        this.layoutMgr.addLayoutComponent((String)constraints, comp);
                    } else {
                        this.layoutMgr.addLayoutComponent(null, comp);
                    }
                }
                ContainerEvent ce = new ContainerEvent(this, 300, comp);
                this.getToolkit().getSystemEventQueue().postEvent(ce);
            }
            finally {
                Object var5_7 = null;
            }
            return;
        }
    }

    public void remove(int index) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                Component r = this.component[index];
                r.removeNotify();
                System.arraycopy(this.component, index + 1, this.component, index, this.ncomponents - index - 1);
                this.component[--this.ncomponents] = null;
                this.invalidate();
                if (this.layoutMgr != null) {
                    this.layoutMgr.removeLayoutComponent(r);
                }
                r.parent = null;
                ContainerEvent ce = new ContainerEvent(this, 301, r);
                this.getToolkit().getSystemEventQueue().postEvent(ce);
            }
            finally {
                Object var3_3 = null;
            }
            return;
        }
    }

    public void remove(Component comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = 0; i < this.ncomponents; ++i) {
                    if (this.component[i] != comp) continue;
                    this.remove(i);
                    break;
                }
                Object var3_4 = null;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                throw throwable;
            }
        }
    }

    public void removeAll() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                while (this.ncomponents > 0) {
                    this.remove(0);
                }
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager mgr) {
        this.layoutMgr = mgr;
        this.invalidate();
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        if (this.layoutMgr != null) {
            this.layoutMgr.layoutContainer(this);
        }
    }

    public void invalidate() {
        super.invalidate();
    }

    public void validate() {
        Object object = this.getTreeLock();
        synchronized (object) {
            block3: {
                try {
                    if (this.isValid() || this.peer == null) break block3;
                    this.validateTree();
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
            Object var2_2 = null;
        }
    }

    private void invalidateTree() {
        for (int i = 0; i < this.ncomponents; ++i) {
            Component comp = this.component[i];
            comp.invalidate();
            if (!(comp instanceof Container)) continue;
            ((Container)comp).invalidateTree();
        }
    }

    protected void validateTree() {
        if (this.valid) {
            return;
        }
        ContainerPeer cPeer = null;
        if (this.peer != null && !(this.peer instanceof LightweightPeer)) {
            cPeer = (ContainerPeer)this.peer;
            cPeer.beginValidate();
        }
        this.doLayout();
        for (int i = 0; i < this.ncomponents; ++i) {
            Component comp = this.component[i];
            if (comp.isValid()) continue;
            if (comp instanceof Container) {
                ((Container)comp).validateTree();
                continue;
            }
            this.component[i].validate();
        }
        this.valid = true;
        if (cPeer != null) {
            cPeer.endValidate();
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.invalidateTree();
    }

    public Dimension getPreferredSize() {
        return this.preferredSize();
    }

    public Dimension preferredSize() {
        if (this.layoutMgr != null) {
            return this.layoutMgr.preferredLayoutSize(this);
        }
        return super.preferredSize();
    }

    public Dimension getMinimumSize() {
        return this.minimumSize();
    }

    public Dimension minimumSize() {
        if (this.layoutMgr != null) {
            return this.layoutMgr.minimumLayoutSize(this);
        }
        return super.minimumSize();
    }

    public Dimension getMaximumSize() {
        if (this.layoutMgr != null && this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
            return lm2.maximumLayoutSize(this);
        }
        return super.getMaximumSize();
    }

    public float getAlignmentX() {
        if (this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
            return lm2.getLayoutAlignmentX(this);
        }
        return super.getAlignmentX();
    }

    public float getAlignmentY() {
        if (this.layoutMgr instanceof LayoutManager2) {
            LayoutManager2 lm2 = (LayoutManager2)this.layoutMgr;
            return lm2.getLayoutAlignmentY(this);
        }
        return super.getAlignmentY();
    }

    public void paint(Graphics g) {
        if (!this.isShowing()) {
            return;
        }
        this.visitChildren(g, GfxPaintVisitor.INSTANCE, false);
    }

    public void update(Graphics g) {
        super.update(g);
    }

    public void print(Graphics g) {
        super.print(g);
        this.visitChildren(g, GfxPrintVisitor.INSTANCE, true);
    }

    public void paintComponents(Graphics g) {
        super.paint(g);
        this.visitChildren(g, GfxPaintAllVisitor.INSTANCE, true);
    }

    public void printComponents(Graphics g) {
        super.paint(g);
        this.visitChildren(g, GfxPrintAllVisitor.INSTANCE, true);
    }

    public synchronized void addContainerListener(ContainerListener l) {
        this.containerListener = AWTEventMulticaster.add(this.containerListener, l);
    }

    public synchronized void removeContainerListener(ContainerListener l) {
        this.containerListener = AWTEventMulticaster.remove(this.containerListener, l);
    }

    public synchronized ContainerListener[] getContainerListeners() {
        return (ContainerListener[])AWTEventMulticaster.getListeners(this.containerListener, Container.class$("java.awt.event.ContainerListener"));
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == Container.class$("java.awt.event.ContainerListener")) {
            return this.getContainerListeners();
        }
        return super.getListeners(listenerType);
    }

    protected void processEvent(AWTEvent e) {
        if (e instanceof ContainerEvent) {
            this.processContainerEvent((ContainerEvent)e);
        } else {
            super.processEvent(e);
        }
    }

    protected void processContainerEvent(ContainerEvent e) {
        if (this.containerListener == null) {
            return;
        }
        switch (e.id) {
            case 300: {
                this.containerListener.componentAdded(e);
                break;
            }
            case 301: {
                this.containerListener.componentRemoved(e);
            }
        }
    }

    public void deliverEvent(Event e) {
        if (!this.handleEvent(e)) {
            Object object = this.getTreeLock();
            synchronized (object) {
                block4: {
                    try {
                        Container parent = this.getParent();
                        if (parent == null) break block4;
                        ((Component)parent).deliverEvent(e);
                    }
                    catch (Throwable throwable) {
                        Object var3_4 = null;
                        throw throwable;
                    }
                }
                Object var3_3 = null;
            }
        }
    }

    public Component getComponentAt(int x, int y) {
        return this.locate(x, y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component locate(int x, int y) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (!this.contains(x, y)) {
                    return null;
                }
                int i = 0;
                while (i < this.ncomponents) {
                    int y2;
                    int x2;
                    if (this.component[i].isVisible() && this.component[i].contains(x2 = x - this.component[i].x, y2 = y - this.component[i].y)) {
                        return this.component[i];
                    }
                    ++i;
                }
                return this;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                throw throwable;
            }
        }
    }

    public Component getComponentAt(Point p) {
        return this.getComponentAt(p.x, p.y);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component findComponentAt(int x, int y) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (!this.contains(x, y)) {
                    return null;
                }
                int i = 0;
                while (i < this.ncomponents) {
                    if (this.component[i].isVisible()) {
                        int x2 = x - this.component[i].x;
                        int y2 = y - this.component[i].y;
                        if (this.component[i] instanceof Container) {
                            Container k = (Container)this.component[i];
                            Component r = k.findComponentAt(x2, y2);
                            if (r != null) {
                                return r;
                            }
                        } else if (this.component[i].contains(x2, y2)) {
                            return this.component[i];
                        }
                    }
                    ++i;
                }
                return this;
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                throw throwable;
            }
        }
    }

    public Component findComponentAt(Point p) {
        return this.findComponentAt(p.x, p.y);
    }

    public void addNotify() {
        super.addNotify();
        this.addNotifyContainerChildren();
    }

    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].removeNotify();
                }
                super.removeNotify();
            }
            finally {
                Object var2_3 = null;
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAncestorOf(Component comp) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                while (true) {
                    if (comp == null) {
                        return false;
                    }
                    if (comp == this) {
                        return true;
                    }
                    comp = comp.getParent();
                }
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                throw throwable;
            }
        }
    }

    protected String paramString() {
        String param = super.paramString();
        if (this.layoutMgr != null) {
            param = param + ",layout=" + this.layoutMgr.getClass().getName();
        }
        return param;
    }

    public void list(PrintStream out, int indent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                super.list(out, indent);
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].list(out, indent + 2);
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
        }
    }

    public void list(PrintWriter out, int indent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                super.list(out, indent);
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].list(out, indent + 2);
                }
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                throw throwable;
            }
        }
    }

    public void setFocusTraversalKeys(int id, Set keystrokes) {
        String name;
        Set sc;
        Set sb;
        Set sa;
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        if (keystrokes == null) {
            for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
                if (!parent.areFocusTraversalKeysSet(id)) continue;
                keystrokes = parent.getFocusTraversalKeys(id);
                break;
            }
            if (keystrokes == null) {
                keystrokes = KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
            }
        }
        switch (id) {
            case 0: {
                sa = this.getFocusTraversalKeys(1);
                sb = this.getFocusTraversalKeys(2);
                sc = this.getFocusTraversalKeys(3);
                name = "forwardFocusTraversalKeys";
                break;
            }
            case 1: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(2);
                sc = this.getFocusTraversalKeys(3);
                name = "backwardFocusTraversalKeys";
                break;
            }
            case 2: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(1);
                sc = this.getFocusTraversalKeys(3);
                name = "upCycleFocusTraversalKeys";
                break;
            }
            case 3: {
                sa = this.getFocusTraversalKeys(0);
                sb = this.getFocusTraversalKeys(1);
                sc = this.getFocusTraversalKeys(2);
                name = "downCycleFocusTraversalKeys";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        int i = keystrokes.size();
        Iterator iter = keystrokes.iterator();
        while (--i >= 0) {
            Object o = iter.next();
            if (o instanceof AWTKeyStroke && !sa.contains(o) && !sb.contains(o) && !sc.contains(o) && ((AWTKeyStroke)o).keyCode != 0) continue;
            throw new IllegalArgumentException();
        }
        if (this.focusTraversalKeys == null) {
            this.focusTraversalKeys = new Set[3];
        }
        keystrokes = Collections.unmodifiableSet(new HashSet(keystrokes));
        this.firePropertyChange(name, this.focusTraversalKeys[id], keystrokes);
        this.focusTraversalKeys[id] = keystrokes;
    }

    public Set getFocusTraversalKeys(int id) {
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        Set s = null;
        if (this.focusTraversalKeys != null) {
            s = this.focusTraversalKeys[id];
        }
        if (s == null && this.parent != null) {
            s = this.parent.getFocusTraversalKeys(id);
        }
        if (s == null) {
            return KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(id);
        }
        return s;
    }

    public boolean areFocusTraversalKeysSet(int id) {
        if (id != 0 && id != 1 && id != 2 && id != 3) {
            throw new IllegalArgumentException();
        }
        return this.focusTraversalKeys != null && this.focusTraversalKeys[id] != null;
    }

    public boolean isFocusCycleRoot(Container c) {
        if (this == c && this.isFocusCycleRoot()) {
            return true;
        }
        Container ancestor = this.getFocusCycleRootAncestor();
        return c == ancestor;
    }

    public void setFocusTraversalPolicy(FocusTraversalPolicy policy) {
        this.focusTraversalPolicy = policy;
    }

    public FocusTraversalPolicy getFocusTraversalPolicy() {
        if (!this.isFocusCycleRoot()) {
            return null;
        }
        if (this.focusTraversalPolicy == null) {
            Container ancestor = this.getFocusCycleRootAncestor();
            if (ancestor != this) {
                return ancestor.getFocusTraversalPolicy();
            }
            KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            return manager.getDefaultFocusTraversalPolicy();
        }
        return this.focusTraversalPolicy;
    }

    public boolean isFocusTraversalPolicySet() {
        return this.focusTraversalPolicy == null;
    }

    public void setFocusCycleRoot(boolean focusCycleRoot) {
        this.focusCycleRoot = focusCycleRoot;
    }

    public boolean isFocusCycleRoot() {
        return this.focusCycleRoot;
    }

    public void transferFocusDownCycle() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.downFocusCycle(this);
    }

    public void applyComponentOrientation(ComponentOrientation orientation) {
        if (orientation == null) {
            throw new NullPointerException();
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(name, listener);
    }

    private void visitChildren(Graphics gfx, GfxVisitor visitor, boolean lightweightOnly) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                for (int i = this.ncomponents - 1; i >= 0; --i) {
                    boolean applicable;
                    Component comp = this.component[i];
                    boolean bl = applicable = comp.isVisible() && (comp.isLightweight() || !lightweightOnly && !(comp instanceof Container));
                    if (!applicable) continue;
                    this.visitChild(gfx, visitor, comp);
                }
                Object var5_6 = null;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                throw throwable;
            }
        }
    }

    private void visitChild(Graphics gfx, GfxVisitor visitor, Component comp) {
        Rectangle clip;
        Rectangle bounds = comp.getBounds();
        Rectangle oldClip = gfx.getClipBounds();
        if (oldClip == null) {
            oldClip = bounds;
        }
        if ((clip = oldClip.intersection(bounds)).isEmpty()) {
            return;
        }
        boolean clipped = false;
        boolean translated = false;
        try {
            gfx.setClip(clip.x, clip.y, clip.width, clip.height);
            clipped = true;
            gfx.translate(bounds.x, bounds.y);
            translated = true;
            visitor.visit(comp, gfx);
        }
        finally {
            Object var9_9 = null;
            if (translated) {
                gfx.translate(-bounds.x, -bounds.y);
            }
            if (clipped) {
                gfx.setClip(oldClip.x, oldClip.y, oldClip.width, oldClip.height);
            }
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (this.eventTypeEnabled(e.id) && this.dispatcher != null && this.dispatcher.handleEvent(e)) {
            return;
        }
        if (e.id <= 301 && e.id >= 300 && (this.containerListener != null || (this.eventMask & (long)2) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Component findNextFocusComponent(Component child) {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                int end;
                int start;
                if (child != null) {
                    for (start = 0; start < this.ncomponents && this.component[start] != child; ++start) {
                    }
                    end = start;
                    if (end == 0) {
                        end = this.ncomponents;
                    }
                    ++start;
                } else {
                    start = 0;
                    end = this.ncomponents;
                }
                int j = start;
                while (j != end) {
                    if (j >= this.ncomponents) {
                        if (this.parent != null) {
                            return this.parent.findNextFocusComponent(this);
                        }
                        j -= this.ncomponents;
                    }
                    if (this.component[j] instanceof Container) {
                        Component c = this.component[j];
                        if ((c = c.findNextFocusComponent(null)) != null) {
                            return c;
                        }
                    } else if (this.component[j].isFocusTraversable()) {
                        return this.component[j];
                    }
                    ++j;
                }
                return null;
            }
            catch (Throwable throwable) {
                Object var8_15 = null;
                throw throwable;
            }
        }
    }

    private void addNotifyContainerChildren() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                int i = this.ncomponents;
                while (--i >= 0) {
                    this.component[i].addNotify();
                    if (!this.component[i].isLightweight()) continue;
                    if (!this.isLightweight() && this.dispatcher == null) {
                        this.dispatcher = new LightweightDispatcher(this);
                    }
                    this.enableEvents(this.component[i].eventMask);
                    if (this.peer == null || this.isLightweight()) continue;
                    this.enableEvents(8192);
                }
                Object var2_3 = null;
            }
            catch (Throwable throwable) {
                Object var2_4 = null;
                throw throwable;
            }
        }
    }

    private void readObject(ObjectInputStream s) throws ClassNotFoundException, IOException {
        s.defaultReadObject();
        String key = (String)s.readObject();
        while (key != null) {
            Object object = s.readObject();
            if ("containerL".equals(key)) {
                this.addContainerListener((ContainerListener)object);
            } else if ("focusTraversalPolicy".equals(key)) {
                this.setFocusTraversalPolicy((FocusTraversalPolicy)object);
            }
            key = (String)s.readObject();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        AWTEventMulticaster.save(s, "containerL", this.containerListener);
        if (this.focusTraversalPolicy instanceof Serializable) {
            s.writeObject(this.focusTraversalPolicy);
        } else {
            s.writeObject(null);
        }
    }

    protected class AccessibleAWTContainer
    extends Component.AccessibleAWTComponent {
        private /* synthetic */ Container this$0;
        private static final long serialVersionUID = 5081320404842566097L;
        protected ContainerListener accessibleContainerHandler;

        private /* synthetic */ void finit$() {
            this.accessibleContainerHandler = new AccessibleContainerHandler(this);
        }

        protected AccessibleAWTContainer(Container this$0) {
            this.this$0 = this$0;
            super(this$0);
            this.finit$();
            this$0.addContainerListener(this.accessibleContainerHandler);
        }

        public int getAccessibleChildrenCount() {
            Object object = this.this$0.getTreeLock();
            synchronized (object) {
                try {
                    int i;
                    int count = 0;
                    int n = i = this.this$0.component == null ? 0 : this.this$0.component.length;
                    while (--i >= 0) {
                        if (!(this.this$0.component[i] instanceof Accessible)) continue;
                        ++count;
                    }
                    int n2 = count;
                    Object var5_5 = null;
                    return n2;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Accessible getAccessibleChild(int i) {
            Object object = this.this$0.getTreeLock();
            synchronized (object) {
                try {
                    if (this.this$0.component == null) {
                        return null;
                    }
                    int index = -1;
                    while (i >= 0 && ++index < this.this$0.component.length) {
                        if (!(this.this$0.component[index] instanceof Accessible)) continue;
                        --i;
                    }
                    if (i >= 0) return null;
                    return (Accessible)((Object)this.this$0.component[index]);
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    throw throwable;
                }
            }
        }

        public Accessible getAccessibleAt(Point p) {
            Component c = this.this$0.getComponentAt(p.x, p.y);
            if (c != this.this$0 && c instanceof Accessible) {
                return (Accessible)((Object)c);
            }
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            private /* synthetic */ AccessibleAWTContainer this$1;

            protected AccessibleContainerHandler(AccessibleAWTContainer this$1) {
                this.this$1 = this$1;
            }

            public void componentAdded(ContainerEvent e) {
                this.this$1.firePropertyChange("AccessibleChild", null, e.getChild());
            }

            public void componentRemoved(ContainerEvent e) {
                this.this$1.firePropertyChange("AccessibleChild", e.getChild(), null);
            }
        }
    }

    static class GfxPrintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintAllVisitor();

        public void visit(Component c, Graphics gfx) {
            c.printAll(gfx);
        }

        GfxPrintAllVisitor() {
        }
    }

    static class GfxPaintAllVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintAllVisitor();

        public void visit(Component c, Graphics gfx) {
            c.paintAll(gfx);
        }

        GfxPaintAllVisitor() {
        }
    }

    static class GfxPrintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPrintVisitor();

        public void visit(Component c, Graphics gfx) {
            c.print(gfx);
        }

        GfxPrintVisitor() {
        }
    }

    static class GfxPaintVisitor
    extends GfxVisitor {
        public static final GfxVisitor INSTANCE = new GfxPaintVisitor();

        public void visit(Component c, Graphics gfx) {
            c.paint(gfx);
        }

        GfxPaintVisitor() {
        }
    }

    static abstract class GfxVisitor {
        public abstract void visit(Component var1, Graphics var2);

        GfxVisitor() {
        }
    }
}

