/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Window;
import java.io.Serializable;

public class ContainerOrderFocusTraversalPolicy
extends FocusTraversalPolicy
implements Serializable {
    static final long serialVersionUID = 486933713763926351L;
    private boolean implicitDownCycleTraversal;

    private /* synthetic */ void finit$() {
        this.implicitDownCycleTraversal = true;
    }

    public ContainerOrderFocusTraversalPolicy() {
        this.finit$();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getComponentAfter(Container root, Component current) {
        Container ancestor;
        if (root == null) {
            throw new IllegalArgumentException("focus cycle root is null");
        }
        if (current == null) {
            throw new IllegalArgumentException("current component is null");
        }
        if (!root.isFocusCycleRoot()) {
            throw new IllegalArgumentException("root is not a focus cycle root");
        }
        Container prevAncestor = ancestor = current.getFocusCycleRootAncestor();
        while (ancestor != root) {
            ancestor = current.getFocusCycleRootAncestor();
            if (ancestor == prevAncestor) {
                if (ancestor == root) break;
                throw new IllegalArgumentException("the given container is not a focus cycle root of the current component");
            }
            prevAncestor = ancestor;
        }
        if (root == current) {
            root = current.getFocusCycleRootAncestor();
        }
        if (current instanceof Window) {
            return this.getFirstComponent((Container)current);
        }
        Container parent = current.getParent();
        Object object = parent.getTreeLock();
        synchronized (object) {
            try {
                int i;
                Component[] components = parent.getComponents();
                int componentIndex = 0;
                int numComponents = parent.getComponentCount();
                for (i = 0; i < numComponents; ++i) {
                    if (components[i] != current) continue;
                    componentIndex = i;
                }
                i = componentIndex + 1;
                while (i < numComponents) {
                    Component result;
                    if (this.accept(components[i])) {
                        return components[i];
                    }
                    if (components[i] instanceof Container && (result = this.getFirstComponent((Container)components[i])) != null && this.implicitDownCycleTraversal) {
                        return result;
                    }
                    ++i;
                }
                Component result = this.getComponentAfter(root, parent);
                return result;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Component getComponentBefore(Container root, Component current) {
        Container ancestor;
        if (root == null) {
            throw new IllegalArgumentException("focus cycle root is null");
        }
        if (current == null) {
            throw new IllegalArgumentException("current component is null");
        }
        if (!root.isFocusCycleRoot()) {
            throw new IllegalArgumentException("root is not a focus cycle root");
        }
        Container prevAncestor = ancestor = current.getFocusCycleRootAncestor();
        while (ancestor != root) {
            ancestor = current.getFocusCycleRootAncestor();
            if (ancestor == prevAncestor) {
                if (ancestor == root) break;
                throw new IllegalArgumentException("the given container is not a focus cycle root of the current component");
            }
            prevAncestor = ancestor;
        }
        if (root == current) {
            root = current.getFocusCycleRootAncestor();
        }
        if (current instanceof Window) {
            return this.getLastComponent((Container)current);
        }
        Container parent = current.getParent();
        Object object = parent.getTreeLock();
        synchronized (object) {
            try {
                int i;
                Component[] components = parent.getComponents();
                int componentIndex = 0;
                int numComponents = parent.getComponentCount();
                for (i = 0; i < numComponents; ++i) {
                    if (components[i] != current) continue;
                    componentIndex = i;
                }
                i = componentIndex - 1;
                while (i >= 0) {
                    Component result;
                    if (this.accept(components[i])) {
                        return components[i];
                    }
                    if (components[i] instanceof Container && (result = this.getLastComponent((Container)components[i])) != null) {
                        return result;
                    }
                    --i;
                }
                Component result = this.getComponentBefore(root, parent);
                return result;
            }
            catch (Throwable throwable) {
                Object var14_18 = null;
                throw throwable;
            }
        }
    }

    public Component getFirstComponent(Container root) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        if (!root.isVisible() || !root.isDisplayable()) {
            return null;
        }
        if (this.accept(root)) {
            return root;
        }
        Component[] componentArray = root.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            Component result;
            Component component = componentArray[i];
            if (this.accept(component)) {
                return component;
            }
            if (!(component instanceof Container) || (result = this.getFirstComponent((Container)component)) == null) continue;
            return result;
        }
        return null;
    }

    public Component getLastComponent(Container root) {
        if (root == null) {
            throw new IllegalArgumentException();
        }
        if (!root.isVisible() || !root.isDisplayable()) {
            return null;
        }
        if (this.accept(root)) {
            return root;
        }
        Component[] componentArray = root.getComponents();
        for (int i = componentArray.length - 1; i >= 0; --i) {
            Component result;
            Component component = componentArray[i];
            if (this.accept(component)) {
                return component;
            }
            if (!(component instanceof Container) || (result = this.getLastComponent((Container)component)) == null) continue;
            return result;
        }
        return null;
    }

    public Component getDefaultComponent(Container root) {
        return this.getFirstComponent(root);
    }

    public void setImplicitDownCycleTraversal(boolean value) {
        this.implicitDownCycleTraversal = value;
    }

    public boolean getImplicitDownCycleTraversal() {
        return this.implicitDownCycleTraversal;
    }

    protected boolean accept(Component current) {
        return current.visible && current.isDisplayable() && current.enabled && current.focusable;
    }
}

