/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.KeyEventDispatcher;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class DefaultKeyboardFocusManager
extends KeyboardFocusManager {
    private SortedSet delayRequests;

    private /* synthetic */ void finit$() {
        this.delayRequests = new TreeSet();
    }

    public DefaultKeyboardFocusManager() {
        this.finit$();
    }

    public boolean dispatchEvent(AWTEvent e) {
        if (e instanceof WindowEvent) {
            Window target = (Window)e.getSource();
            if (e.id == 205) {
                this.setGlobalActiveWindow(target);
            } else if (e.id == 207) {
                this.setGlobalFocusedWindow(target);
            } else if (e.id != 208 && e.id != 206) {
                return false;
            }
            this.redispatchEvent(target, e);
            return true;
        }
        if (e instanceof FocusEvent) {
            Component target = (Component)e.getSource();
            if (e.id == 1004) {
                if (((FocusEvent)e).isTemporary()) {
                    this.setGlobalFocusOwner(target);
                } else {
                    this.setGlobalPermanentFocusOwner(target);
                }
            } else if (e.id == 1005) {
                Container parent;
                for (parent = target.getParent(); parent != null && !(parent instanceof Window); parent = parent.getParent()) {
                }
                Window toplevel = parent == null ? (Window)target : (Window)parent;
                Component focusOwner = this.getFocusOwner();
                if (focusOwner != null) {
                    toplevel.setFocusOwner(focusOwner);
                }
                if (((FocusEvent)e).isTemporary()) {
                    this.setGlobalFocusOwner(null);
                } else {
                    this.setGlobalPermanentFocusOwner(null);
                }
            }
            this.redispatchEvent(target, e);
            return true;
        }
        if (e instanceof KeyEvent) {
            Iterator i = this.getKeyEventDispatchers().iterator();
            while (i.hasNext()) {
                KeyEventDispatcher dispatcher = (KeyEventDispatcher)i.next();
                if (!dispatcher.dispatchKeyEvent((KeyEvent)e)) continue;
                return true;
            }
            Component focusOwner = this.getGlobalPermanentFocusOwner();
            if (focusOwner != null) {
                this.processKeyEvent(focusOwner, (KeyEvent)e);
            }
            if (e.isConsumed()) {
                return true;
            }
            if (this.enqueueKeyEvent((KeyEvent)e)) {
                return true;
            }
            return this.dispatchKeyEvent((KeyEvent)e);
        }
        return false;
    }

    private boolean enqueueKeyEvent(KeyEvent e) {
        Iterator i = this.delayRequests.iterator();
        boolean oneEnqueued = false;
        while (i.hasNext()) {
            EventDelayRequest request = (EventDelayRequest)i.next();
            if (e.getWhen() <= request.timestamp) continue;
            request.enqueueEvent(e);
            oneEnqueued = true;
        }
        return oneEnqueued;
    }

    public boolean dispatchKeyEvent(KeyEvent e) {
        Component focusOwner = this.getGlobalPermanentFocusOwner();
        if (focusOwner != null) {
            this.redispatchEvent(focusOwner, e);
        }
        Iterator i = this.getKeyEventPostProcessors().iterator();
        while (i.hasNext()) {
            KeyEventPostProcessor processor = (KeyEventPostProcessor)i.next();
            if (!processor.postProcessKeyEvent(e)) continue;
            return true;
        }
        if (this.postProcessKeyEvent(e)) {
            return true;
        }
        return true;
    }

    public boolean postProcessKeyEvent(KeyEvent e) {
        MenuBar menubar;
        Window focusedWindow;
        int modifiers = e.getModifiersEx();
        if (e.getID() == 401 && (modifiers & 0x80) != 0 && (focusedWindow = this.getGlobalFocusedWindow()) instanceof Frame && (menubar = ((Frame)focusedWindow).getMenuBar()) != null) {
            int numMenus = menubar.getMenuCount();
            for (int i = 0; i < numMenus; ++i) {
                Menu menu = menubar.getMenu(i);
                int numItems = menu.getItemCount();
                for (int j = 0; j < numItems; ++j) {
                    MenuItem item = menu.getItem(j);
                    MenuShortcut shortcut = item.getShortcut();
                    if (!item.isEnabled() || shortcut == null || shortcut.getKey() != e.getKeyCode() || (!shortcut.usesShiftModifier() || (modifiers & 0x40) == 0) && (shortcut.usesShiftModifier() || (modifiers & 0x40) != 0)) continue;
                    item.dispatchEvent(new ActionEvent(item, 1001, item.getActionCommand(), modifiers));
                    return true;
                }
            }
        }
        return false;
    }

    public void processKeyEvent(Component comp, KeyEvent e) {
        AWTKeyStroke eventKeystroke = AWTKeyStroke.getAWTKeyStrokeForEvent(e);
        AWTKeyStroke oppositeKeystroke = AWTKeyStroke.getAWTKeyStroke(e.getKeyCode(), e.getModifiersEx(), e.id != 402);
        Set forwardKeystrokes = comp.getFocusTraversalKeys(0);
        Set backwardKeystrokes = comp.getFocusTraversalKeys(1);
        Set upKeystrokes = comp.getFocusTraversalKeys(2);
        Set downKeystrokes = null;
        if (comp instanceof Container) {
            downKeystrokes = comp.getFocusTraversalKeys(3);
        }
        if (forwardKeystrokes.contains(eventKeystroke)) {
            this.focusNextComponent(comp);
            e.consume();
        } else if (backwardKeystrokes.contains(eventKeystroke)) {
            this.focusPreviousComponent(comp);
            e.consume();
        } else if (upKeystrokes.contains(eventKeystroke)) {
            this.upFocusCycle(comp);
            e.consume();
        } else if (comp instanceof Container && downKeystrokes.contains(eventKeystroke)) {
            this.downFocusCycle((Container)comp);
            e.consume();
        } else if (forwardKeystrokes.contains(oppositeKeystroke) || backwardKeystrokes.contains(oppositeKeystroke) || upKeystrokes.contains(oppositeKeystroke) || comp instanceof Container && downKeystrokes.contains(oppositeKeystroke)) {
            e.consume();
        }
    }

    protected void enqueueKeyEvents(long after, Component untilFocused) {
        this.delayRequests.add(new EventDelayRequest(this, after, untilFocused));
    }

    protected void dequeueKeyEvents(long after, Component untilFocused) {
        if (after < 0L) {
            int size = this.delayRequests.size();
            if (size > 0) {
                this.delayRequests.remove(this.delayRequests.first());
            }
        } else {
            EventDelayRequest template = new EventDelayRequest(this, after, untilFocused);
            if (this.delayRequests.contains(template)) {
                EventDelayRequest actual = (EventDelayRequest)this.delayRequests.tailSet(template).first();
                this.delayRequests.remove(actual);
                actual.dispatchEvents();
            }
        }
    }

    protected void discardKeyEvents(Component comp) {
        Iterator i = this.delayRequests.iterator();
        while (i.hasNext()) {
            EventDelayRequest request = (EventDelayRequest)i.next();
            if (request.focusedComp != comp && (!(comp instanceof Container) || !((Container)comp).isAncestorOf(request.focusedComp))) continue;
            request.discardEvents();
        }
    }

    public void focusPreviousComponent(Component comp) {
        Component focusComp = comp == null ? this.getGlobalFocusOwner() : comp;
        Container focusCycleRoot = focusComp.getFocusCycleRootAncestor();
        FocusTraversalPolicy policy = focusCycleRoot.getFocusTraversalPolicy();
        Component previous = policy.getComponentBefore(focusCycleRoot, focusComp);
        if (previous != null) {
            previous.requestFocusInWindow();
        }
    }

    public void focusNextComponent(Component comp) {
        Component focusComp = comp == null ? this.getGlobalFocusOwner() : comp;
        Container focusCycleRoot = focusComp.getFocusCycleRootAncestor();
        FocusTraversalPolicy policy = focusCycleRoot.getFocusTraversalPolicy();
        Component next = policy.getComponentAfter(focusCycleRoot, focusComp);
        if (next != null) {
            next.requestFocusInWindow();
        }
    }

    public void upFocusCycle(Component comp) {
        Component focusComp = comp == null ? this.getGlobalFocusOwner() : comp;
        Container focusCycleRoot = focusComp.getFocusCycleRootAncestor();
        if (focusCycleRoot instanceof Window) {
            FocusTraversalPolicy policy = focusCycleRoot.getFocusTraversalPolicy();
            Component defaultComponent = policy.getDefaultComponent(focusCycleRoot);
            if (defaultComponent != null) {
                defaultComponent.requestFocusInWindow();
            }
        } else {
            Container parentFocusCycleRoot = focusCycleRoot.getFocusCycleRootAncestor();
            focusCycleRoot.requestFocusInWindow();
            this.setGlobalCurrentFocusCycleRoot(parentFocusCycleRoot);
        }
    }

    public void downFocusCycle(Container cont) {
        if (cont == null) {
            return;
        }
        if (cont.isFocusCycleRoot(cont)) {
            FocusTraversalPolicy policy = cont.getFocusTraversalPolicy();
            Component defaultComponent = policy.getDefaultComponent(cont);
            if (defaultComponent != null) {
                defaultComponent.requestFocusInWindow();
            }
            this.setGlobalCurrentFocusCycleRoot(cont);
        }
    }

    private class EventDelayRequest
    implements Comparable {
        private /* synthetic */ DefaultKeyboardFocusManager this$0;
        private LinkedList enqueuedKeyEvents;
        public long timestamp;
        public Component focusedComp;

        private /* synthetic */ void finit$() {
            this.enqueuedKeyEvents = new LinkedList();
        }

        public EventDelayRequest(DefaultKeyboardFocusManager this$0, long timestamp, Component focusedComp) {
            this.this$0 = this$0;
            this.finit$();
            this.timestamp = timestamp;
            this.focusedComp = focusedComp;
        }

        public int compareTo(Object o) {
            if (!(o instanceof EventDelayRequest)) {
                throw new ClassCastException();
            }
            EventDelayRequest request = (EventDelayRequest)o;
            if (request.timestamp < this.timestamp) {
                return -1;
            }
            if (request.timestamp == this.timestamp) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (!(o instanceof EventDelayRequest) || o == null) {
                return false;
            }
            EventDelayRequest request = (EventDelayRequest)o;
            return request.timestamp == this.timestamp && request.focusedComp == this.focusedComp;
        }

        public void enqueueEvent(KeyEvent e) {
            KeyEvent last = (KeyEvent)this.enqueuedKeyEvents.getLast();
            if (last != null && e.getWhen() < last.getWhen()) {
                throw new RuntimeException("KeyEvents enqueued out-of-order");
            }
            if (e.getWhen() <= this.timestamp) {
                throw new RuntimeException("KeyEvents enqueued before starting timestamp");
            }
            this.enqueuedKeyEvents.add(e);
        }

        public void dispatchEvents() {
            int size = this.enqueuedKeyEvents.size();
            for (int i = 0; i < size; ++i) {
                KeyEvent e = (KeyEvent)this.enqueuedKeyEvents.remove(0);
                this.this$0.dispatchKeyEvent(e);
            }
        }

        public void discardEvents() {
            this.enqueuedKeyEvents.clear();
        }
    }
}

