/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Cursor;
import java.awt.GraphicsConfiguration;
import java.awt.IllegalComponentStateException;
import java.awt.Image;
import java.awt.MenuBar;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.peer.FramePeer;
import java.util.Vector;

public class Frame
extends Window
implements MenuContainer {
    public static final int DEFAULT_CURSOR = 0;
    public static final int CROSSHAIR_CURSOR = 1;
    public static final int TEXT_CURSOR = 2;
    public static final int WAIT_CURSOR = 3;
    public static final int SW_RESIZE_CURSOR = 4;
    public static final int SE_RESIZE_CURSOR = 5;
    public static final int NW_RESIZE_CURSOR = 6;
    public static final int NE_RESIZE_CURSOR = 7;
    public static final int N_RESIZE_CURSOR = 8;
    public static final int S_RESIZE_CURSOR = 9;
    public static final int E_RESIZE_CURSOR = 11;
    public static final int W_RESIZE_CURSOR = 10;
    public static final int HAND_CURSOR = 12;
    public static final int MOVE_CURSOR = 13;
    public static final int ICONIFIED = 1;
    public static final int MAXIMIZED_BOTH = 6;
    public static final int MAXIMIZED_HORIZ = 2;
    public static final int MAXIMIZED_VERT = 4;
    public static final int NORMAL = 0;
    private static final long serialVersionUID = 2673458971256075116L;
    private int frameSerializedDataVersion;
    private Image icon;
    private boolean mbManagement;
    private MenuBar menuBar;
    Vector ownedWindows;
    private boolean resizable;
    private int state;
    private String title;
    private Rectangle maximizedBounds;
    private boolean undecorated;
    private static transient long next_frame_number = 0L;

    private /* synthetic */ void finit$() {
        this.ownedWindows = new Vector();
        this.resizable = true;
        this.title = "";
        this.undecorated = false;
    }

    public Frame() {
        this("");
    }

    public Frame(String title) {
        this.finit$();
        this.title = title;
        this.visible = false;
    }

    public Frame(GraphicsConfiguration gc) {
        super(gc);
        this.finit$();
        this.visible = false;
    }

    public Frame(String title, GraphicsConfiguration gc) {
        super(gc);
        this.finit$();
        this.setTitle(title);
        this.visible = false;
    }

    public String getTitle() {
        return this.title;
    }

    public synchronized void setTitle(String title) {
        this.title = title;
        if (this.peer != null) {
            ((FramePeer)this.peer).setTitle(title);
        }
    }

    public Image getIconImage() {
        return this.icon;
    }

    public synchronized void setIconImage(Image icon) {
        this.icon = icon;
        if (this.peer != null) {
            ((FramePeer)this.peer).setIconImage(icon);
        }
    }

    public MenuBar getMenuBar() {
        return this.menuBar;
    }

    public synchronized void setMenuBar(MenuBar menuBar) {
        if (this.peer != null) {
            if (this.menuBar != null) {
                this.menuBar.removeNotify();
            }
            if (menuBar != null) {
                menuBar.addNotify();
            }
            ((FramePeer)this.peer).setMenuBar(menuBar);
        }
        this.menuBar = menuBar;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    public synchronized void setResizable(boolean resizable) {
        this.resizable = resizable;
        if (this.peer != null) {
            ((FramePeer)this.peer).setResizable(resizable);
        }
    }

    public int getCursorType() {
        return this.getCursor().getType();
    }

    public void setCursor(int type) {
        this.setCursor(new Cursor(type));
    }

    public void remove(MenuComponent menu) {
        this.menuBar.remove(menu);
    }

    public void addNotify() {
        if (this.menuBar != null) {
            this.menuBar.addNotify();
        }
        if (this.peer == null) {
            this.peer = this.getToolkit().createFrame(this);
        }
        super.addNotify();
    }

    public void removeNotify() {
        if (this.menuBar != null) {
            this.menuBar.removeNotify();
        }
        super.removeNotify();
    }

    protected String paramString() {
        String title = this.getTitle();
        String resizable = "";
        if (this.isResizable()) {
            resizable = ",resizable";
        }
        String state = "";
        switch (this.getState()) {
            case 0: {
                state = ",normal";
                break;
            }
            case 1: {
                state = ",iconified";
                break;
            }
            case 6: {
                state = ",maximized-both";
                break;
            }
            case 2: {
                state = ",maximized-horiz";
                break;
            }
            case 4: {
                state = ",maximized-vert";
            }
        }
        return super.paramString() + ",title=" + title + resizable + state;
    }

    public static Frame[] getFrames() {
        String msg = "FIXME: can't be implemented without weak references";
        throw new UnsupportedOperationException(msg);
    }

    public void setState(int state) {
        int current_state = this.getExtendedState();
        if (state == 0 && (current_state & 1) != 0) {
            this.setExtendedState(current_state | 1);
        }
        if (state == 1 && (current_state & 0xFFFFFFFE) == 0) {
            this.setExtendedState(current_state & 0xFFFFFFFE);
        }
    }

    public int getState() {
        if ((this.state & 1) != 0) {
            return 1;
        }
        return 0;
    }

    public void setExtendedState(int state) {
        this.state = state;
    }

    public int getExtendedState() {
        return this.state;
    }

    public void setMaximizedBounds(Rectangle maximizedBounds) {
        this.maximizedBounds = maximizedBounds;
    }

    public Rectangle getMaximizedBounds() {
        return this.maximizedBounds;
    }

    public boolean isUndecorated() {
        return this.undecorated;
    }

    public void setUndecorated(boolean undecorated) {
        if (!this.isDisplayable()) {
            throw new IllegalComponentStateException();
        }
        this.undecorated = undecorated;
    }

    String generateName() {
        return "frame" + Frame.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_frame_number++;
    }
}

