/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;

public abstract class Graphics {
    protected Graphics() {
    }

    public abstract Graphics create();

    public Graphics create(int x, int y, int width, int height) {
        Graphics g = this.create();
        g.translate(x, y);
        g.clipRect(0, 0, width, height);
        return g;
    }

    public abstract void translate(int var1, int var2);

    public abstract Color getColor();

    public abstract void setColor(Color var1);

    public abstract void setPaintMode();

    public abstract void setXORMode(Color var1);

    public abstract Font getFont();

    public abstract void setFont(Font var1);

    public FontMetrics getFontMetrics() {
        return this.getFontMetrics(this.getFont());
    }

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract Rectangle getClipBounds();

    public Rectangle getClipRect() {
        return this.getClipBounds();
    }

    public abstract void clipRect(int var1, int var2, int var3, int var4);

    public abstract void setClip(int var1, int var2, int var3, int var4);

    public abstract Shape getClip();

    public abstract void setClip(Shape var1);

    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawLine(int var1, int var2, int var3, int var4);

    public abstract void fillRect(int var1, int var2, int var3, int var4);

    public void drawRect(int x, int y, int width, int height) {
        int x1 = x;
        int y1 = y;
        int x2 = x + width;
        int y2 = y + height;
        this.drawLine(x1, y1, x2, y1);
        this.drawLine(x2, y1, x2, y2);
        this.drawLine(x2, y2, x1, y2);
        this.drawLine(x1, y2, x1, y1);
    }

    public abstract void clearRect(int var1, int var2, int var3, int var4);

    public abstract void drawRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillRoundRect(int var1, int var2, int var3, int var4, int var5, int var6);

    public void draw3DRect(int x, int y, int width, int height, boolean raised) {
        Color color = this.getColor();
        Color tl = color.brighter();
        Color br = color.darker();
        if (!raised) {
            Color tmp = tl;
            tl = br;
            br = tmp;
        }
        int x1 = x;
        int y1 = y;
        int x2 = x + width;
        int y2 = y + height;
        this.setColor(tl);
        this.drawLine(x1, y1, x2, y1);
        this.drawLine(x1, y2, x1, y1);
        this.setColor(br);
        this.drawLine(x2, y1, x2, y2);
        this.drawLine(x2, y2, x1, y2);
        this.setColor(color);
    }

    public void fill3DRect(int x, int y, int width, int height, boolean raised) {
        this.fillRect(x, y, width, height);
        this.draw3DRect(x, y, width - 1, height - 1, raised);
    }

    public abstract void drawOval(int var1, int var2, int var3, int var4);

    public abstract void fillOval(int var1, int var2, int var3, int var4);

    public abstract void drawArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void fillArc(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void drawPolyline(int[] var1, int[] var2, int var3);

    public abstract void drawPolygon(int[] var1, int[] var2, int var3);

    public void drawPolygon(Polygon polygon) {
        this.drawPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public abstract void fillPolygon(int[] var1, int[] var2, int var3);

    public void fillPolygon(Polygon polygon) {
        this.fillPolygon(polygon.xpoints, polygon.ypoints, polygon.npoints);
    }

    public abstract void drawString(String var1, int var2, int var3);

    public abstract void drawString(AttributedCharacterIterator var1, int var2, int var3);

    public void drawChars(char[] data, int offset, int length, int x, int y) {
        this.drawString(new String(data, offset, length), x, y);
    }

    public void drawBytes(byte[] data, int offset, int length, int x, int y) {
        String str = new String(data, offset, length);
        this.drawString(str, x, y);
    }

    public abstract boolean drawImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, ImageObserver var6);

    public abstract boolean drawImage(Image var1, int var2, int var3, Color var4, ImageObserver var5);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, Color var6, ImageObserver var7);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, ImageObserver var10);

    public abstract boolean drawImage(Image var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, int var9, Color var10, ImageObserver var11);

    public abstract void dispose();

    public void finalize() {
        this.dispose();
    }

    public String toString() {
        return this.getClass().getName() + "[font=" + this.getFont() + ",color=" + this.getColor() + "]";
    }

    public boolean hitClip(int x, int y, int width, int height) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Rectangle getClipBounds(Rectangle r) {
        Rectangle clipBounds = this.getClipBounds();
        if (r == null) {
            return clipBounds;
        }
        r.x = clipBounds.x;
        r.y = clipBounds.y;
        r.width = clipBounds.width;
        r.height = clipBounds.height;
        return r;
    }
}

