/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.ClasspathToolkit;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.util.Locale;

public abstract class GraphicsEnvironment {
    protected GraphicsEnvironment() {
    }

    public static GraphicsEnvironment getLocalGraphicsEnvironment() {
        ClasspathToolkit tk = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        return tk.getLocalGraphicsEnvironment();
    }

    public static boolean isHeadless() {
        return false;
    }

    public boolean isHeadlessInstance() {
        return false;
    }

    public abstract GraphicsDevice[] getScreenDevices();

    public abstract GraphicsDevice getDefaultScreenDevice();

    public abstract Graphics2D createGraphics(BufferedImage var1);

    public abstract Font[] getAllFonts();

    public abstract String[] getAvailableFontFamilyNames();

    public abstract String[] getAvailableFontFamilyNames(Locale var1);

    public Point getCenterPoint() {
        Rectangle r = this.getMaximumWindowBounds();
        return new Point(r.x + r.width / 2, r.y + r.height / 2);
    }

    public Rectangle getMaximumWindowBounds() {
        return this.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
    }
}

