/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.SwingUtilities;

class LightweightDispatcher
implements Serializable {
    private static final long serialVersionUID = 5184291520170872969L;
    private Container nativeContainer;
    private Cursor nativeCursor;
    private long eventMask;
    private transient Component mouseEventTarget;
    private transient Component pressedComponent;
    private transient Component lastComponentEntered;
    private transient int pressCount;

    LightweightDispatcher(Container c) {
        this.nativeContainer = c;
    }

    void acquireComponentForMouseEvent(MouseEvent me) {
        int x = me.getX();
        int y = me.getY();
        Container parent = this.nativeContainer;
        Component candidate = null;
        Point p = me.getPoint();
        while (candidate == null && parent != null) {
            candidate = SwingUtilities.getDeepestComponentAt(parent, p.x, p.y);
            if (candidate != null && (candidate.eventMask & (long)me.getID()) != 0L) continue;
            candidate = null;
            p = SwingUtilities.convertPoint(parent, p.x, p.y, parent.parent);
            parent = parent.parent;
        }
        if (candidate == this.nativeContainer) {
            candidate = null;
        }
        if (this.lastComponentEntered != null && this.lastComponentEntered.isShowing() && this.lastComponentEntered != candidate) {
            if (SwingUtilities.isDescendingFrom(this.lastComponentEntered, this.nativeContainer)) {
                Point tp = SwingUtilities.convertPoint(this.nativeContainer, x, y, this.lastComponentEntered);
                MouseEvent exited = new MouseEvent(this.lastComponentEntered, 505, me.getWhen(), me.getModifiersEx(), tp.x, tp.y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                this.lastComponentEntered.dispatchEvent(exited);
            }
            this.lastComponentEntered = null;
        }
        if (candidate != null) {
            this.mouseEventTarget = candidate;
            if (candidate.isLightweight() && candidate.isShowing() && candidate != this.nativeContainer && candidate != this.lastComponentEntered) {
                this.lastComponentEntered = this.mouseEventTarget;
                Point cp = SwingUtilities.convertPoint(this.nativeContainer, x, y, this.lastComponentEntered);
                MouseEvent entered = new MouseEvent(this.lastComponentEntered, 504, me.getWhen(), me.getModifiersEx(), cp.x, cp.y, me.getClickCount(), me.isPopupTrigger(), me.getButton());
                this.lastComponentEntered.dispatchEvent(entered);
            }
        }
        if (me.getID() == 502 || me.getID() == 501 && this.pressCount > 0 || me.getID() == 506) {
            if (SwingUtilities.isDescendingFrom(this.pressedComponent, this.nativeContainer)) {
                this.mouseEventTarget = this.pressedComponent;
            } else if (me.getID() == 500) {
                if (candidate != this.pressedComponent) {
                    this.mouseEventTarget = null;
                } else if (this.pressCount == 0) {
                    this.pressedComponent = null;
                }
            }
        }
    }

    boolean handleEvent(AWTEvent e) {
        if (e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            this.acquireComponentForMouseEvent(me);
            if (this.mouseEventTarget != null && this.mouseEventTarget.isShowing() && e.getID() != 504 && e.getID() != 505) {
                MouseEvent newEvt = SwingUtilities.convertMouseEvent(this.nativeContainer, me, this.mouseEventTarget);
                this.mouseEventTarget.dispatchEvent(newEvt);
                switch (e.getID()) {
                    case 501: {
                        if (this.pressCount++ != 0) break;
                        this.pressedComponent = this.mouseEventTarget;
                        break;
                    }
                    case 502: {
                        if (--this.pressCount != 0 || this.mouseEventTarget == this.pressedComponent) break;
                        this.pressedComponent = null;
                    }
                }
                if (newEvt.isConsumed()) {
                    e.consume();
                }
            }
        }
        return e.isConsumed();
    }
}

