/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.util.ArrayList;

public class MediaTracker
implements Serializable {
    public static final int LOADING = 1;
    public static final int ABORTED = 2;
    public static final int ERRORED = 4;
    public static final int COMPLETE = 8;
    Component target;
    MediaEntry head;
    static final long serialVersionUID = -483174189758638095L;

    public MediaTracker(Component c) {
        this.target = c;
    }

    public void addImage(Image image, int id) {
        MediaEntry e = new MediaEntry(this);
        e.id = id;
        e.image = image;
        e.next = this.head;
        this.head = e;
        int flags = this.target.checkImage(image, e);
        e.imageUpdate(image, flags, -1, -1, -1, -1);
    }

    public void addImage(Image image, int id, int width, int height) {
        MediaEntry e = new MediaEntry(this);
        e.id = id;
        e.image = image;
        e.next = this.head;
        e.width = width;
        e.height = height;
        this.head = e;
        int flags = this.target.checkImage(image, width, height, e);
        e.imageUpdate(image, flags, -1, -1, width, height);
    }

    public boolean checkAll() {
        return this.checkAll(false);
    }

    public boolean checkAll(boolean load) {
        MediaEntry e = this.head;
        boolean result = true;
        while (e != null) {
            if ((e.status & 8) == 0) {
                if (load) {
                    result = false;
                    if (e.status == 0) {
                        this.target.prepareImage(e.image, e);
                        e.status = 1;
                    }
                } else {
                    return false;
                }
            }
            e = e.next;
        }
        return result;
    }

    public boolean isErrorAny() {
        MediaEntry e = this.head;
        while (e != null) {
            if ((e.status & 4) != 0) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object[] getErrorsAny() {
        MediaEntry e = this.head;
        ArrayList result = null;
        while (e != null) {
            if ((e.status & 4) != 0) {
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(e.image);
            }
            e = e.next;
        }
        if (result == null) {
            return null;
        }
        return result.toArray();
    }

    public void waitForAll() throws InterruptedException {
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            try {
                while (!this.checkAll(true)) {
                    this.wait();
                }
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
    }

    public boolean waitForAll(long ms) throws InterruptedException {
        long start = System.currentTimeMillis();
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            try {
                while (!this.checkAll(true)) {
                    this.wait(ms);
                }
                Object var6_4 = null;
            }
            catch (Throwable throwable) {
                Object var6_5 = null;
                throw throwable;
            }
        }
        if (System.currentTimeMillis() - start < ms) {
            boolean bl = true;
            return bl;
        }
        boolean bl = false;
        return bl;
    }

    public int statusAll(boolean load) {
        int result = 0;
        MediaEntry e = this.head;
        while (e != null) {
            if (load && e.status == 0) {
                this.target.prepareImage(e.image, e);
                e.status = 1;
            }
            result |= e.status;
            e = e.next;
        }
        return result;
    }

    public boolean checkID(int id) {
        return this.checkID(id, false);
    }

    public boolean checkID(int id, boolean load) {
        MediaEntry e = this.head;
        boolean result = true;
        while (e != null) {
            if (e.id == id && (e.status & 8) == 0) {
                if (load) {
                    result = false;
                    if (e.status == 0) {
                        this.target.prepareImage(e.image, e);
                        e.status = 1;
                    }
                } else {
                    return false;
                }
            }
            e = e.next;
        }
        return result;
    }

    public boolean isErrorID(int id) {
        MediaEntry e = this.head;
        while (e != null) {
            if (e.id == id && (e.status & 4) != 0) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public Object[] getErrorsID(int id) {
        MediaEntry e = this.head;
        ArrayList result = null;
        while (e != null) {
            if (e.id == id && (e.status & 4) != 0) {
                if (result == null) {
                    result = new ArrayList();
                }
                result.add(e.image);
            }
            e = e.next;
        }
        if (result == null) {
            return null;
        }
        return result.toArray();
    }

    public void waitForID(int id) throws InterruptedException {
        MediaEntry e = this.head;
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            try {
                while (!this.checkID(id, true)) {
                    this.wait();
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public boolean waitForID(int id, long ms) throws InterruptedException {
        MediaEntry e = this.head;
        long start = System.currentTimeMillis();
        MediaTracker mediaTracker = this;
        synchronized (mediaTracker) {
            try {
                while (!this.checkID(id, true)) {
                    this.wait(ms);
                }
                Object var8_6 = null;
            }
            catch (Throwable throwable) {
                Object var8_7 = null;
                throw throwable;
            }
        }
        if (System.currentTimeMillis() - start < ms) {
            boolean bl = true;
            return bl;
        }
        boolean bl = false;
        return bl;
    }

    public int statusID(int id, boolean load) {
        int result = 0;
        MediaEntry e = this.head;
        while (e != null) {
            if (e.id == id) {
                if (load && e.status == 0) {
                    this.target.prepareImage(e.image, e);
                    e.status = 1;
                }
                result |= e.status;
            }
            e = e.next;
        }
        return result;
    }

    public void removeImage(Image image) {
        MediaEntry e = this.head;
        MediaEntry prev = null;
        while (e != null) {
            if (e.image == image) {
                if (prev == null) {
                    this.head = e.next;
                } else {
                    prev.next = e.next;
                }
            }
            prev = e;
            e = e.next;
        }
    }

    public void removeImage(Image image, int id) {
        MediaEntry e = this.head;
        MediaEntry prev = null;
        while (e != null) {
            if (e.id == id && e.image == image) {
                if (prev == null) {
                    this.head = e.next;
                } else {
                    prev.next = e.next;
                }
            } else {
                prev = e;
            }
            e = e.next;
        }
    }

    public void removeImage(Image image, int id, int width, int height) {
        MediaEntry e = this.head;
        MediaEntry prev = null;
        while (e != null) {
            if (e.id == id && e.image == image && e.width == width && e.height == height) {
                if (prev == null) {
                    this.head = e.next;
                } else {
                    prev.next = e.next;
                }
            } else {
                prev = e;
            }
            e = e.next;
        }
    }

    class MediaEntry
    implements ImageObserver {
        private /* synthetic */ MediaTracker this$0;
        int id;
        Image image;
        MediaEntry next;
        int status;
        int width;
        int height;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
            this.status = (flags & 0x80) != 0 ? 10 : ((flags & 0x40) != 0 ? 12 : ((flags & 0x20) != 0 ? 8 : ((flags & 8) != 0 ? 1 : 0)));
            if ((this.status & 8) != 8) return ((this.status >> 3 ^ 1) & 1) != 0;
            MediaTracker mediaTracker = this.this$0;
            synchronized (mediaTracker) {
                try {
                    this.this$0.notifyAll();
                    return ((this.status >> 3 ^ 1) & 1) != 0;
                }
                finally {
                    Object var8_8 = null;
                }
            }
        }

        MediaEntry(MediaTracker this$0) {
            this.this$0 = this$0;
        }
    }
}

