/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;

public class Polygon
implements Shape,
Serializable {
    private static final long serialVersionUID = -6460061437900069969L;
    public int npoints;
    public int[] xpoints;
    public int[] ypoints;
    protected Rectangle bounds;
    private transient int[] condensed;

    public Polygon() {
        this.xpoints = new int[4];
        this.ypoints = new int[4];
    }

    public Polygon(int[] xpoints, int[] ypoints, int npoints) {
        this.xpoints = new int[npoints];
        this.ypoints = new int[npoints];
        System.arraycopy(xpoints, 0, this.xpoints, 0, npoints);
        System.arraycopy(ypoints, 0, this.ypoints, 0, npoints);
        this.npoints = npoints;
    }

    public void reset() {
        this.npoints = 0;
        this.invalidate();
    }

    public void invalidate() {
        this.bounds = null;
        this.condensed = null;
    }

    public void translate(int dx, int dy) {
        int i = this.npoints;
        while (--i >= 0) {
            int n = i;
            this.xpoints[n] = this.xpoints[n] + dx;
            int n2 = i;
            this.ypoints[n2] = this.ypoints[n2] + dy;
        }
        if (this.bounds != null) {
            this.bounds.x += dx;
            this.bounds.y += dy;
        }
        this.condensed = null;
    }

    public void addPoint(int x, int y) {
        if (this.npoints + 1 > this.xpoints.length) {
            int[] newx = new int[this.npoints + 1];
            System.arraycopy(this.xpoints, 0, newx, 0, this.npoints);
            this.xpoints = newx;
        }
        if (this.npoints + 1 > this.ypoints.length) {
            int[] newy = new int[this.npoints + 1];
            System.arraycopy(this.ypoints, 0, newy, 0, this.npoints);
            this.ypoints = newy;
        }
        this.xpoints[this.npoints] = x;
        this.ypoints[this.npoints] = y;
        ++this.npoints;
        if (this.bounds != null) {
            if (this.npoints == 1) {
                this.bounds.x = x;
                this.bounds.y = y;
            } else {
                if (x < this.bounds.x) {
                    this.bounds.width += this.bounds.x - x;
                    this.bounds.x = x;
                } else if (x > this.bounds.x + this.bounds.width) {
                    this.bounds.width = x - this.bounds.x;
                }
                if (y < this.bounds.y) {
                    this.bounds.height += this.bounds.y - y;
                    this.bounds.y = y;
                } else if (y > this.bounds.y + this.bounds.height) {
                    this.bounds.height = y - this.bounds.y;
                }
            }
        }
        this.condensed = null;
    }

    public Rectangle getBounds() {
        return this.getBoundingBox();
    }

    public Rectangle getBoundingBox() {
        if (this.bounds == null) {
            int miny;
            int minx;
            if (this.npoints == 0) {
                this.bounds = new Rectangle();
                return this.bounds;
            }
            int i = this.npoints - 1;
            int maxx = minx = this.xpoints[i];
            int maxy = miny = this.ypoints[i];
            while (--i >= 0) {
                int x = this.xpoints[i];
                int y = this.ypoints[i];
                if (x < minx) {
                    minx = x;
                } else if (x > maxx) {
                    maxx = x;
                }
                if (y < miny) {
                    miny = y;
                    continue;
                }
                if (y <= maxy) continue;
                maxy = y;
            }
            this.bounds = new Rectangle(minx, miny, maxx - minx, maxy - miny);
        }
        return this.bounds;
    }

    public boolean contains(Point p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public boolean inside(int x, int y) {
        return this.contains((double)x, (double)y);
    }

    public Rectangle2D getBounds2D() {
        return this.getBounds();
    }

    public boolean contains(double x, double y) {
        if (!this.condense() || !this.getBounds().contains(x, y)) {
            return false;
        }
        boolean inside = false;
        int limit = this.condensed[0];
        int curx = this.condensed[(limit << 1) - 1];
        int cury = this.condensed[limit << 1];
        for (int i = 1; i <= limit; ++i) {
            int priorx = curx;
            int priory = cury;
            curx = this.condensed[(i << 1) - 1];
            cury = this.condensed[i << 1];
            if ((double)priorx > x && (double)curx > x || (double)priory > y && (double)cury > y || (double)priory < y && (double)cury < y) continue;
            if (priory == cury) {
                boolean above;
                if ((double)priorx < x && (double)curx < x) {
                    inside ^= true;
                    continue;
                }
                priory = this.condensed[(limit + i - 2) % limit << 1];
                boolean bl = above = priory > cury;
                if (((double)curx != x || curx <= priorx && !above) && ((double)priorx != x || curx >= priorx && above) && (curx <= priorx || above) && !above) continue;
                inside ^= true;
                continue;
            }
            if ((double)priorx == x && (double)priory == y) continue;
            if (priorx == curx || (double)priorx < x && (double)curx < x) {
                inside ^= true;
                continue;
            }
            double leftx = curx > priorx ? (double)priorx : (double)curx;
            double lefty = curx > priorx ? (double)priory : (double)cury;
            double slopeseg = (double)(cury - priory) / (double)(curx - priorx);
            double slopepoint = (y - lefty) / (x - leftx);
            if (!(slopeseg > 0.0 && slopeseg > slopepoint) && !(slopeseg < slopepoint)) continue;
            inside ^= true;
        }
        return inside;
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean intersects(double x, double y, double w, double h) {
        int i;
        if (w <= 0.0 || h <= 0.0 || this.npoints == 0 || !this.getBounds().intersects(x, y, w, h)) {
            return false;
        }
        if (x <= (double)this.bounds.x && x + w >= (double)(this.bounds.x + this.bounds.width) && y <= (double)this.bounds.y && y + h >= (double)(this.bounds.y + this.bounds.height) || this.contains(x, y)) {
            return true;
        }
        int curx = 0;
        int cury = 0;
        for (i = 0; i < this.npoints; ++i) {
            curx = this.xpoints[i];
            cury = this.ypoints[i];
            if (!((double)curx >= x) || !((double)curx < x + w) || !((double)cury >= y) || !((double)cury < y + h) || !this.contains(curx, cury)) continue;
            return true;
        }
        for (i = 0; i < this.npoints; ++i) {
            int priorx = curx;
            int priory = cury;
            curx = this.xpoints[i];
            cury = this.ypoints[i];
            if (priorx == curx) {
                if ((double)curx < x || (double)curx >= x + w || !((double)cury >= y + h && (double)priory <= y) && (!((double)cury <= y) || !((double)priory >= y + h))) continue;
                return true;
            }
            if (priory == cury) {
                if ((double)cury < y || (double)cury >= y + h || !((double)curx >= x + w && (double)priorx <= x) && (!((double)curx <= x) || !((double)priorx >= x + w))) continue;
                return true;
            }
            double slope = (double)(cury - priory) / (double)(curx - priorx);
            double intersect = slope * (x - (double)curx) + (double)cury;
            if (intersect > y && intersect < y + h) {
                return true;
            }
            intersect = slope * (x + w - (double)curx) + (double)cury;
            if (intersect > y && intersect < y + h) {
                return true;
            }
            intersect = (y - (double)cury) / slope + (double)curx;
            if (intersect > x && intersect < x + w) {
                return true;
            }
            intersect = (y + h - (double)cury) / slope + (double)cury;
            if (!(intersect > x) || !(intersect < x + w)) continue;
            return true;
        }
        return false;
    }

    public boolean intersects(Rectangle2D r) {
        return this.intersects(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public boolean contains(double x, double y, double w, double h) {
        if (w <= 0.0 || h <= 0.0 || !this.contains(x, y) || !this.bounds.contains(x, y, w, h)) {
            return false;
        }
        int limit = this.condensed[0];
        int curx = this.condensed[(limit << 1) - 1];
        int cury = this.condensed[limit << 1];
        for (int i = 1; i <= limit; ++i) {
            int priorx = curx;
            int priory = cury;
            curx = this.condensed[(i << 1) - 1];
            cury = this.condensed[i << 1];
            if ((double)curx > x && (double)curx < x + w && (double)cury > y && (double)cury < y + h) {
                return false;
            }
            if (priorx == curx) {
                if ((double)curx < x || (double)curx > x + w || !((double)cury >= y + h && (double)priory <= y) && (!((double)cury <= y) || !((double)priory >= y + h))) continue;
                return false;
            }
            if (priory == cury) {
                if ((double)cury < y || (double)cury > y + h || !((double)curx >= x + w && (double)priorx <= x) && (!((double)curx <= x) || !((double)priorx >= x + w))) continue;
                return false;
            }
            double slope = (double)(cury - priory) / (double)(curx - priorx);
            double intersect = slope * (x - (double)curx) + (double)cury;
            if (intersect > y && intersect < y + h) {
                return false;
            }
            intersect = slope * (x + w - (double)curx) + (double)cury;
            if (intersect > y && intersect < y + h) {
                return false;
            }
            intersect = (y - (double)cury) / slope + (double)curx;
            if (intersect > x && intersect < x + w) {
                return false;
            }
            intersect = (y + h - (double)cury) / slope + (double)cury;
            if (!(intersect > x) || !(intersect < x + w)) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Rectangle2D r) {
        return this.contains(r.getX(), r.getY(), r.getWidth(), r.getHeight());
    }

    public PathIterator getPathIterator(AffineTransform transform) {
        return new PathIterator(this, transform){
            private /* synthetic */ Polygon this$0;
            private /* synthetic */ AffineTransform val$transform;
            private int vertex;
            {
                this.this$0 = this$0;
                this.finit$(parm$transform);
            }

            private /* synthetic */ void finit$(AffineTransform parm$transform) {
                this.val$transform = parm$transform;
            }

            public int getWindingRule() {
                return 0;
            }

            public boolean isDone() {
                return this.vertex > this.this$0.npoints;
            }

            public void next() {
                ++this.vertex;
            }

            public int currentSegment(float[] coords) {
                if (this.vertex >= this.this$0.npoints) {
                    return 4;
                }
                coords[0] = this.this$0.xpoints[this.vertex];
                coords[1] = this.this$0.ypoints[this.vertex];
                if (this.val$transform != null) {
                    this.val$transform.transform(coords, 0, coords, 0, 1);
                }
                if (this.vertex == 0) {
                    return 0;
                }
                return 1;
            }

            public int currentSegment(double[] coords) {
                if (this.vertex >= this.this$0.npoints) {
                    return 4;
                }
                coords[0] = this.this$0.xpoints[this.vertex];
                coords[1] = this.this$0.ypoints[this.vertex];
                if (this.val$transform != null) {
                    this.val$transform.transform(coords, 0, coords, 0, 1);
                }
                if (this.vertex == 0) {
                    return 0;
                }
                return 1;
            }
        };
    }

    public PathIterator getPathIterator(AffineTransform transform, double flatness) {
        return this.getPathIterator(transform);
    }

    private boolean condense() {
        if (this.npoints <= 2) {
            return false;
        }
        if (this.condensed != null) {
            return this.condensed[0] > 2;
        }
        this.condensed = new int[this.npoints * 2 + 1];
        int curx = this.xpoints[this.npoints - 1];
        int cury = this.ypoints[this.npoints - 1];
        double curslope = Double.NaN;
        int count = 0;
        block0: for (int i = 0; i < this.npoints; ++i) {
            int priorx = curx;
            int priory = cury;
            double priorslope = curslope;
            curx = this.xpoints[i];
            cury = this.ypoints[i];
            while (curx == priorx && cury == priory) {
                if (++i == this.npoints) break block0;
                curx = this.xpoints[i];
                cury = this.ypoints[i];
            }
            double d = curslope = curx == priorx ? Double.POSITIVE_INFINITY : (double)(cury - priory) / (double)(curx - priorx);
            if (priorslope == curslope) {
                if (count > 1 && this.condensed[(count << 1) - 3] == curx && this.condensed[(count << 1) - 2] == cury) {
                    --count;
                    continue;
                }
            } else {
                ++count;
            }
            this.condensed[(count << 1) - 1] = curx;
            this.condensed[count << 1] = cury;
        }
        this.condensed[0] = count;
        return count > 2;
    }
}

