/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.TextComponent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.peer.TextFieldPeer;
import java.util.EventListener;

public class TextField
extends TextComponent {
    private static final long serialVersionUID = -2966288784432217853L;
    private int columns;
    private char echoChar;
    private ActionListener action_listeners;

    public TextField() {
        this("", 1);
    }

    public TextField(String text) {
        this(text, text.length());
    }

    public TextField(int columns) {
        this("", columns);
    }

    public TextField(String text, int columns) {
        super(text);
        this.columns = columns;
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
    }

    public int getColumns() {
        return this.columns;
    }

    public synchronized void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException("Value is less than zero: " + columns);
        }
        this.columns = columns;
    }

    public char getEchoChar() {
        return this.echoChar;
    }

    public void setEchoChar(char echoChar) {
        this.setEchoCharacter(echoChar);
    }

    public void setEchoCharacter(char echoChar) {
        this.echoChar = echoChar;
        TextFieldPeer peer = (TextFieldPeer)this.getPeer();
        if (peer != null) {
            peer.setEchoChar(echoChar);
        }
    }

    public boolean echoCharIsSet() {
        return this.echoChar != '\u0000';
    }

    public Dimension getMinimumSize() {
        return this.getMinimumSize(this.getColumns());
    }

    public Dimension getMinimumSize(int columns) {
        return this.minimumSize(columns);
    }

    public Dimension minimumSize() {
        return this.minimumSize(this.getColumns());
    }

    public Dimension minimumSize(int columns) {
        TextFieldPeer peer = (TextFieldPeer)this.getPeer();
        if (peer == null) {
            return null;
        }
        return peer.getMinimumSize(columns);
    }

    public Dimension getPreferredSize() {
        return this.getPreferredSize(this.getColumns());
    }

    public Dimension getPreferredSize(int columns) {
        return this.preferredSize(columns);
    }

    public Dimension preferredSize() {
        return this.preferredSize(this.getColumns());
    }

    public Dimension preferredSize(int columns) {
        TextFieldPeer peer = (TextFieldPeer)this.getPeer();
        if (peer == null) {
            return new Dimension(0, 0);
        }
        return peer.getPreferredSize(columns);
    }

    public void addNotify() {
        if (this.getPeer() != null) {
            return;
        }
        this.setPeer(this.getToolkit().createTextField(this));
    }

    public synchronized void addActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.add(this.action_listeners, listener);
        this.enableEvents(128);
    }

    public synchronized void removeActionListener(ActionListener listener) {
        this.action_listeners = AWTEventMulticaster.remove(this.action_listeners, listener);
    }

    protected void processEvent(AWTEvent event) {
        if (event instanceof ActionEvent) {
            this.processActionEvent((ActionEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processActionEvent(ActionEvent event) {
        if (this.action_listeners != null) {
            this.action_listeners.actionPerformed(event);
        }
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 1001 && e.id >= 1001 && (this.action_listeners != null || (this.eventMask & (long)128) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected String paramString() {
        return this.getClass().getName() + "(columns=" + this.getColumns() + ",echoChar=" + this.getEchoChar();
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == TextField.class$("java.awt.event.ActionListener")) {
            return AWTEventMulticaster.getListeners(this.action_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(TextField.class$("java.awt.event.ActionListener"));
    }
}

