/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import gnu.java.awt.peer.GLightweightPeer;
import java.awt.AWTError;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.event.AWTEventListener;
import java.awt.im.InputMethodHighlight;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.LightweightPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URL;
import java.util.Map;
import java.util.Properties;

public abstract class Toolkit {
    private static String default_toolkit_name = "gnu.java.awt.peer.gtk.GtkToolkit";
    private static Toolkit toolkit;
    private static Properties props;
    protected final Map desktopProperties;
    protected final PropertyChangeSupport desktopPropsSupport;

    private /* synthetic */ void finit$() {
        this.desktopProperties = new Properties();
        this.desktopPropsSupport = new PropertyChangeSupport(this);
    }

    public Toolkit() {
        this.finit$();
    }

    protected abstract ButtonPeer createButton(Button var1);

    protected abstract TextFieldPeer createTextField(TextField var1);

    protected abstract LabelPeer createLabel(Label var1);

    protected abstract ListPeer createList(List var1);

    protected abstract CheckboxPeer createCheckbox(Checkbox var1);

    protected abstract ScrollbarPeer createScrollbar(Scrollbar var1);

    protected abstract ScrollPanePeer createScrollPane(ScrollPane var1);

    protected abstract TextAreaPeer createTextArea(TextArea var1);

    protected abstract ChoicePeer createChoice(Choice var1);

    protected abstract FramePeer createFrame(Frame var1);

    protected abstract CanvasPeer createCanvas(Canvas var1);

    protected abstract PanelPeer createPanel(Panel var1);

    protected abstract WindowPeer createWindow(Window var1);

    protected abstract DialogPeer createDialog(Dialog var1);

    protected abstract MenuBarPeer createMenuBar(MenuBar var1);

    protected abstract MenuPeer createMenu(Menu var1);

    protected abstract PopupMenuPeer createPopupMenu(PopupMenu var1);

    protected abstract MenuItemPeer createMenuItem(MenuItem var1);

    protected abstract FileDialogPeer createFileDialog(FileDialog var1);

    protected abstract CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem var1);

    protected LightweightPeer createComponent(Component target) {
        return new GLightweightPeer(target);
    }

    protected abstract FontPeer getFontPeer(String var1, int var2);

    protected void loadSystemColors(int[] systemColors) {
        systemColors[0] = -16753572;
        systemColors[1] = -16777088;
        systemColors[2] = -1;
        systemColors[3] = -4144960;
        systemColors[4] = -8355712;
        systemColors[5] = -4144960;
        systemColors[6] = -4144960;
        systemColors[7] = -1;
        systemColors[8] = -16777216;
        systemColors[9] = -16777216;
        systemColors[10] = -4144960;
        systemColors[11] = -16777216;
        systemColors[12] = -4144960;
        systemColors[13] = -16777216;
        systemColors[14] = -16777072;
        systemColors[15] = -1;
        systemColors[16] = -8355712;
        systemColors[17] = -4144960;
        systemColors[18] = -16777216;
        systemColors[19] = -1;
        systemColors[20] = -2039584;
        systemColors[21] = -8355712;
        systemColors[22] = -16777216;
        systemColors[23] = -2039584;
        systemColors[24] = -2039808;
        systemColors[25] = -16777216;
    }

    public void setDynamicLayout(boolean dynamic) {
    }

    protected boolean isDynamicLayoutSet() {
        return false;
    }

    public boolean isDynamicLayoutActive() {
        return false;
    }

    public abstract Dimension getScreenSize();

    public abstract int getScreenResolution();

    public Insets getScreenInsets(GraphicsConfiguration gc) {
        return null;
    }

    public abstract ColorModel getColorModel();

    public abstract String[] getFontList();

    public abstract FontMetrics getFontMetrics(Font var1);

    public abstract void sync();

    public static Toolkit getDefaultToolkit() {
        if (toolkit != null) {
            return toolkit;
        }
        String toolkit_name = System.getProperty("awt.toolkit", default_toolkit_name);
        try {
            Class cls = Class.forName(toolkit_name);
            Object obj = cls.newInstance();
            if (!(obj instanceof Toolkit)) {
                throw new AWTError(toolkit_name + " is not a subclass of " + "java.awt.Toolkit");
            }
            toolkit = (Toolkit)obj;
            return toolkit;
        }
        catch (Throwable t) {
            AWTError e = new AWTError("Cannot load AWT toolkit: " + toolkit_name);
            throw (AWTError)e.initCause(t);
        }
    }

    public abstract Image getImage(String var1);

    public abstract Image getImage(URL var1);

    public abstract Image createImage(String var1);

    public abstract Image createImage(URL var1);

    public abstract boolean prepareImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract int checkImage(Image var1, int var2, int var3, ImageObserver var4);

    public abstract Image createImage(ImageProducer var1);

    public Image createImage(byte[] data) {
        return this.createImage(data, 0, data.length);
    }

    public abstract Image createImage(byte[] var1, int var2, int var3);

    public abstract PrintJob getPrintJob(Frame var1, String var2, Properties var3);

    public PrintJob getPrintJob(Frame frame, String title, JobAttributes jobAttr, PageAttributes pageAttr) {
        return null;
    }

    public abstract void beep();

    public abstract Clipboard getSystemClipboard();

    public Clipboard getSystemSelection() {
        return null;
    }

    public int getMenuShortcutKeyMask() {
        return 2;
    }

    public boolean getLockingKeyState(int keyCode) {
        if (keyCode != 20 && keyCode != 144 && keyCode != 145) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException();
    }

    public void setLockingKeyState(int keyCode, boolean on) {
        if (keyCode != 20 && keyCode != 144 && keyCode != 145) {
            throw new IllegalArgumentException();
        }
        throw new UnsupportedOperationException();
    }

    protected static Container getNativeContainer(Component component) {
        component = component.getParent();
        while (true) {
            if (component == null) {
                return null;
            }
            if (!(component instanceof Container)) {
                component = component.getParent();
                continue;
            }
            if (!(component.getPeer() instanceof LightweightPeer)) break;
            component = component.getParent();
        }
        return (Container)component;
    }

    public Cursor createCustomCursor(Image cursor, Point hotSpot, String name) {
        return null;
    }

    public Dimension getBestCursorSize(int preferredWidth, int preferredHeight) {
        return new Dimension(0, 0);
    }

    public int getMaximumCursorColors() {
        return 0;
    }

    public boolean isFrameStateSupported(int state) {
        return false;
    }

    public static String getProperty(String key, String def) {
        return props.getProperty(key, def);
    }

    public final EventQueue getSystemEventQueue() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkAwtEventQueueAccess();
        }
        return this.getSystemEventQueueImpl();
    }

    protected abstract EventQueue getSystemEventQueueImpl();

    public abstract DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent var1);

    public DragGestureRecognizer createDragGestureRecognizer(Class recognizer, DragSource ds, Component comp, int actions, DragGestureListener l) {
        return null;
    }

    public final Object getDesktopProperty(String propertyName) {
        return this.desktopProperties.get(propertyName);
    }

    protected final void setDesktopProperty(String name, Object newValue) {
        Object oldValue = this.getDesktopProperty(name);
        this.desktopProperties.put(name, newValue);
        this.desktopPropsSupport.firePropertyChange(name, oldValue, newValue);
    }

    protected Object lazilyLoadDesktopProperty(String name) {
        return null;
    }

    protected void initializeDesktopProperties() {
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.desktopPropsSupport.addPropertyChangeListener(name, pcl);
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.desktopPropsSupport.removePropertyChangeListener(name, pcl);
    }

    public PropertyChangeListener[] getPropertyChangeListeners() {
        return this.desktopPropsSupport.getPropertyChangeListeners();
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String name) {
        return this.desktopPropsSupport.getPropertyChangeListeners(name);
    }

    public void addAWTEventListener(AWTEventListener listener, long eventMask) {
    }

    public void removeAWTEventListener(AWTEventListener listener) {
    }

    public AWTEventListener[] getAWTEventListeners() {
        return null;
    }

    public AWTEventListener[] getAWTEventListeners(long mask) {
        return null;
    }

    public abstract Map mapInputMethodHighlight(InputMethodHighlight var1);

    static {
        props = new Properties();
    }
}

