/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Event;
import java.awt.EventQueue;
import java.awt.FocusTraversalPolicy;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import java.awt.peer.WindowPeer;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.EventListener;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;

public class Window
extends Container
implements Accessible {
    private static final long serialVersionUID = 4497834738069338734L;
    private String warningString;
    private int windowSerializedDataVersion;
    private int state;
    private boolean focusableWindowState;
    private transient Vector ownedWindows;
    private transient WindowListener windowListener;
    private transient WindowFocusListener windowFocusListener;
    private transient WindowStateListener windowStateListener;
    private transient GraphicsConfiguration graphicsConfiguration;
    private transient AccessibleContext accessibleContext;
    private transient boolean shown;
    private transient Component windowFocusOwner;

    private /* synthetic */ void finit$() {
        this.warningString = null;
        this.windowSerializedDataVersion = 0;
        this.state = 0;
        this.focusableWindowState = true;
        this.ownedWindows = new Vector();
    }

    static /* synthetic */ Component access$1(Window inst$, Component write_parm_value$) {
        inst$.windowFocusOwner = write_parm_value$;
        return inst$.windowFocusOwner;
    }

    Window() {
        this.finit$();
        this.visible = false;
        this.focusCycleRoot = true;
        this.setLayout(new BorderLayout());
        this.addWindowFocusListener(new WindowAdapter(this){
            private /* synthetic */ Window this$0;
            {
                this.this$0 = this$0;
            }

            public void windowGainedFocus(WindowEvent event) {
                if (this.this$0.windowFocusOwner != null) {
                    EventQueue eq;
                    EventQueue eventQueue = eq = Toolkit.getDefaultToolkit().getSystemEventQueue();
                    synchronized (eventQueue) {
                        block5: {
                            try {
                                KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                                Component currentFocusOwner = manager.getGlobalPermanentFocusOwner();
                                if (currentFocusOwner != null) {
                                    eq.postEvent(new FocusEvent(currentFocusOwner, 1005, false, this.this$0.windowFocusOwner));
                                    eq.postEvent(new FocusEvent(this.this$0.windowFocusOwner, 1004, false, currentFocusOwner));
                                    break block5;
                                }
                                eq.postEvent(new FocusEvent(this.this$0.windowFocusOwner, 1004, false));
                            }
                            catch (Throwable throwable) {
                                Object var4_5 = null;
                                throw throwable;
                            }
                        }
                        Object var4_4 = null;
                    }
                }
            }
        });
    }

    Window(GraphicsConfiguration gc) {
        this();
        this.graphicsConfiguration = gc;
    }

    public Window(Frame owner) {
        this(owner, owner.getGraphicsConfiguration());
    }

    public Window(Window owner) {
        this(owner, owner.getGraphicsConfiguration());
    }

    public Window(Window owner, GraphicsConfiguration gc) {
        this();
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                if (owner == null) {
                    throw new IllegalArgumentException("owner must not be null");
                }
                this.parent = owner;
                owner.ownedWindows.add(new WeakReference(this));
            }
            finally {
                Object var4_4 = null;
            }
            SecurityManager s = System.getSecurityManager();
            if (s != null && !s.checkTopLevelWindow(this)) {
                this.warningString = System.getProperty("awt.appletWarning");
            }
            if (gc != null && gc.getDevice().getType() != 0) {
                throw new IllegalArgumentException("gc must be from a screen device");
            }
            this.graphicsConfiguration = gc;
            return;
        }
    }

    GraphicsConfiguration getGraphicsConfigurationImpl() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        return super.getGraphicsConfigurationImpl();
    }

    public void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createWindow(this);
        }
        super.addNotify();
    }

    public void pack() {
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        this.setSize(this.getPreferredSize());
        this.validate();
    }

    public void show() {
        if (this.parent != null && !this.parent.isDisplayable()) {
            this.parent.addNotify();
        }
        if (this.peer == null) {
            this.addNotify();
        }
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                Iterator e = this.ownedWindows.iterator();
                while (e.hasNext()) {
                    Window w = (Window)((Reference)e.next()).get();
                    if (w != null) {
                        if (!w.isVisible()) continue;
                        w.getPeer().setVisible(true);
                        continue;
                    }
                    e.remove();
                }
                e = null;
            }
            catch (Throwable w) {
                Object e = null;
                throw w;
            }
        }
        this.validate();
        super.show();
        this.toFront();
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        manager.setGlobalFocusedWindow(this);
        if (!this.shown) {
            FocusTraversalPolicy policy = this.getFocusTraversalPolicy();
            Component initialFocusOwner = null;
            if (policy != null) {
                initialFocusOwner = policy.getInitialComponent(this);
            }
            if (initialFocusOwner != null) {
                initialFocusOwner.requestFocusInWindow(false);
            }
            this.shown = true;
        }
    }

    public void hide() {
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                Iterator e = this.ownedWindows.iterator();
                while (e.hasNext()) {
                    Window w = (Window)((Reference)e.next()).get();
                    if (w != null) {
                        if (!w.isVisible() || w.getPeer() == null) continue;
                        w.getPeer().setVisible(false);
                        continue;
                    }
                    e.remove();
                }
                Object var2_2 = null;
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                throw throwable;
            }
        }
        super.hide();
    }

    public boolean isDisplayable() {
        if (super.isDisplayable()) {
            return true;
        }
        return this.peer != null;
    }

    public void dispose() {
        this.hide();
        Object object = this.getTreeLock();
        synchronized (object) {
            try {
                Iterator e = this.ownedWindows.iterator();
                while (e.hasNext()) {
                    Window w = (Window)((Reference)e.next()).get();
                    if (w != null) {
                        w.dispose();
                        continue;
                    }
                    e.remove();
                }
                for (int i = 0; i < this.ncomponents; ++i) {
                    this.component[i].removeNotify();
                }
                this.removeNotify();
                WindowEvent we = new WindowEvent(this, 202);
                this.getToolkit().getSystemEventQueue().postEvent(we);
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    public void toBack() {
        if (this.peer != null) {
            WindowPeer wp = (WindowPeer)this.peer;
            wp.toBack();
        }
    }

    public void toFront() {
        if (this.peer != null) {
            WindowPeer wp = (WindowPeer)this.peer;
            wp.toFront();
        }
    }

    public Toolkit getToolkit() {
        return Toolkit.getDefaultToolkit();
    }

    public final String getWarningString() {
        return this.warningString;
    }

    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    public void setCursor(Cursor cursor) {
        super.setCursor(cursor);
    }

    public Window getOwner() {
        return (Window)this.parent;
    }

    public Window[] getOwnedWindows() {
        Window[] windowArray;
        Window[] trimmedList;
        Object object = this.getTreeLock();
        synchronized (object) {
            block6: {
                try {
                    Window[] validList = new Window[this.ownedWindows.size()];
                    Iterator e = this.ownedWindows.iterator();
                    int numValid = 0;
                    while (e.hasNext()) {
                        Window w = (Window)((Reference)e.next()).get();
                        if (w != null) {
                            validList[numValid++] = w;
                            continue;
                        }
                        e.remove();
                    }
                    if (numValid != validList.length) {
                        trimmedList = new Window[numValid];
                        System.arraycopy(validList, 0, trimmedList, 0, numValid);
                        break block6;
                    }
                    trimmedList = validList;
                }
                catch (Throwable throwable) {
                    Object var3_3 = null;
                    throw throwable;
                }
            }
            windowArray = null;
        }
        windowArray = trimmedList;
        return windowArray;
    }

    public synchronized void addWindowListener(WindowListener listener) {
        this.windowListener = AWTEventMulticaster.add(this.windowListener, listener);
    }

    public synchronized void removeWindowListener(WindowListener listener) {
        this.windowListener = AWTEventMulticaster.remove(this.windowListener, listener);
    }

    public synchronized WindowListener[] getWindowListeners() {
        return (WindowListener[])AWTEventMulticaster.getListeners(this.windowListener, Window.class$("java.awt.event.WindowListener"));
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public synchronized WindowFocusListener[] getWindowFocusListeners() {
        return (WindowFocusListener[])AWTEventMulticaster.getListeners(this.windowFocusListener, Window.class$("java.awt.event.WindowFocusListener"));
    }

    public synchronized WindowStateListener[] getWindowStateListeners() {
        return (WindowStateListener[])AWTEventMulticaster.getListeners(this.windowStateListener, Window.class$("java.awt.event.WindowStateListener"));
    }

    public void addWindowFocusListener(WindowFocusListener wfl) {
        this.windowFocusListener = AWTEventMulticaster.add(this.windowFocusListener, wfl);
    }

    public void addWindowStateListener(WindowStateListener wsl) {
        this.windowStateListener = AWTEventMulticaster.add(this.windowStateListener, wsl);
    }

    public void removeWindowFocusListener(WindowFocusListener wfl) {
        this.windowFocusListener = AWTEventMulticaster.remove(this.windowFocusListener, wfl);
    }

    public void removeWindowStateListener(WindowStateListener wsl) {
        this.windowStateListener = AWTEventMulticaster.remove(this.windowStateListener, wsl);
    }

    public EventListener[] getListeners(Class listenerType) {
        if (listenerType == Window.class$("java.awt.event.WindowListener")) {
            return this.getWindowListeners();
        }
        return super.getListeners(listenerType);
    }

    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 209 && e.id >= 200 && (this.windowListener != null || this.windowFocusListener != null || this.windowStateListener != null || (this.eventMask & (long)64) != 0L)) {
            this.processEvent(e);
        } else {
            super.dispatchEventImpl(e);
        }
    }

    protected void processEvent(AWTEvent evt) {
        if (evt instanceof WindowEvent) {
            this.processWindowEvent((WindowEvent)evt);
        } else {
            super.processEvent(evt);
        }
    }

    protected void processWindowEvent(WindowEvent evt) {
        int id = evt.getID();
        if (id == 207 || id == 208) {
            this.processWindowFocusEvent(evt);
        } else if (id == 209) {
            this.processWindowStateEvent(evt);
        } else if (this.windowListener != null) {
            switch (evt.getID()) {
                case 205: {
                    this.windowListener.windowActivated(evt);
                    break;
                }
                case 202: {
                    this.windowListener.windowClosed(evt);
                    break;
                }
                case 201: {
                    this.windowListener.windowClosing(evt);
                    break;
                }
                case 206: {
                    this.windowListener.windowDeactivated(evt);
                    break;
                }
                case 204: {
                    this.windowListener.windowDeiconified(evt);
                    break;
                }
                case 203: {
                    this.windowListener.windowIconified(evt);
                    break;
                }
                case 200: {
                    this.windowListener.windowOpened(evt);
                    break;
                }
            }
        }
    }

    public Component getFocusOwner() {
        KeyboardFocusManager manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Window activeWindow = manager.getActiveWindow();
        if (activeWindow == this) {
            return manager.getFocusOwner();
        }
        return this.windowFocusOwner;
    }

    void setFocusOwner(Component windowFocusOwner) {
        this.windowFocusOwner = windowFocusOwner;
    }

    public boolean postEvent(Event e) {
        return this.handleEvent(e);
    }

    public boolean isShowing() {
        return super.isShowing();
    }

    public void applyResourceBundle(ResourceBundle rb) {
        throw new Error("Not implemented");
    }

    public void applyResourceBundle(String rbName) {
        ResourceBundle rb = ResourceBundle.getBundle(rbName, Locale.getDefault(), ClassLoader.getSystemClassLoader());
        if (rb != null) {
            this.applyResourceBundle(rb);
        }
    }

    public AccessibleContext getAccessibleContext() {
        throw new Error("Not implemented");
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        if (this.graphicsConfiguration != null) {
            return this.graphicsConfiguration;
        }
        if (this.peer != null) {
            return this.peer.getGraphicsConfiguration();
        }
        return null;
    }

    protected void processWindowFocusEvent(WindowEvent event) {
        if (this.windowFocusListener != null) {
            switch (event.getID()) {
                case 207: {
                    this.windowFocusListener.windowGainedFocus(event);
                    break;
                }
                case 208: {
                    this.windowFocusListener.windowLostFocus(event);
                    break;
                }
            }
        }
    }

    protected void processWindowStateEvent(WindowEvent event) {
        if (this.windowStateListener != null && event.getID() == 209) {
            this.windowStateListener.windowStateChanged(event);
        }
    }

    public final boolean isFocusableWindow() {
        if (!this.getFocusableWindowState()) {
            return false;
        }
        return this instanceof Dialog || this instanceof Frame;
    }

    public boolean getFocusableWindowState() {
        return this.focusableWindowState;
    }

    public void setFocusableWindowState(boolean focusableWindowState) {
        this.focusableWindowState = focusableWindowState;
    }

    void setBoundsCallback(int x, int y, int w, int h) {
        ComponentEvent ce;
        if (this.x == x && this.y == y && this.width == w && this.height == h) {
            return;
        }
        this.invalidate();
        boolean resized = this.width != w || this.height != h;
        boolean moved = this.x != x || this.y != y;
        this.x = x;
        this.y = y;
        this.width = w;
        this.height = h;
        if (resized) {
            ce = new ComponentEvent(this, 101);
            this.getToolkit().getSystemEventQueue().postEvent(ce);
        }
        if (moved) {
            ce = new ComponentEvent(this, 100);
            this.getToolkit().getSystemEventQueue().postEvent(ce);
        }
    }
}

