/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.RasterOp;
import java.awt.image.WritableRaster;

public class AffineTransformOp
implements BufferedImageOp,
RasterOp {
    public static final int TYPE_BILINEAR = 0;
    public static final int TYPE_NEAREST_NEIGHBOR = 1;
    private AffineTransform transform;
    private RenderingHints hints;

    public AffineTransformOp(AffineTransform xform, int interpolationType) {
        this.transform = xform;
        this.hints = interpolationType == 0 ? new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR) : new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    public AffineTransformOp(AffineTransform xform, RenderingHints hints) {
        this.transform = xform;
        this.hints = hints;
    }

    public BufferedImage createCompatibleDestImage(BufferedImage src, ColorModel destCM) {
        if (destCM == null) {
            destCM = src.getColorModel();
        }
        return new BufferedImage(destCM, this.createCompatibleDestRaster(src.getRaster()), src.isAlphaPremultiplied(), null);
    }

    public WritableRaster createCompatibleDestRaster(Raster src) {
        Rectangle rect = (Rectangle)this.getBounds2D(src);
        if (rect.getWidth() == 0.0 || rect.getHeight() == 0.0) {
            throw new RasterFormatException("width or height is 0");
        }
        return src.createCompatibleWritableRaster((int)rect.getWidth(), (int)rect.getHeight());
    }

    public BufferedImage filter(BufferedImage src, BufferedImage dst) {
        if (dst == src) {
            throw new IllegalArgumentException("src image cannot be the same as the dst image");
        }
        if (dst == null) {
            dst = this.createCompatibleDestImage(src, src.getColorModel());
        }
        Graphics2D gr = dst.createGraphics();
        gr.setRenderingHints(this.hints);
        gr.drawImage(src, this.transform, null);
        return dst;
    }

    public WritableRaster filter(Raster src, WritableRaster dst) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    public Rectangle2D getBounds2D(BufferedImage src) {
        return this.getBounds2D(src.getRaster());
    }

    public Rectangle2D getBounds2D(Raster src) {
        double x2 = (double)src.getWidth() + (double)src.getMinX();
        double y2 = (double)src.getHeight() + (double)src.getMinY();
        Point2D p2 = this.getPoint2D(new Point2D.Double(x2, y2), null);
        Rectangle rect = new Rectangle(0, 0, (int)p2.getX(), (int)p2.getY());
        return ((RectangularShape)rect).getBounds();
    }

    public int getInterpolationType() {
        if (this.hints.containsValue(RenderingHints.VALUE_INTERPOLATION_BILINEAR)) {
            return 0;
        }
        return 1;
    }

    public Point2D getPoint2D(Point2D srcPt, Point2D dstPt) {
        return this.transform.transform(srcPt, dstPt);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public AffineTransform getTransform() {
        return this.transform;
    }
}

