/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ByteLookupTable
extends LookupTable {
    private byte[][] data;

    public ByteLookupTable(int offset, byte[][] data) throws IllegalArgumentException {
        super(offset, data.length);
        this.data = data;
    }

    public ByteLookupTable(int offset, byte[] data) throws IllegalArgumentException {
        super(offset, 1);
        this.data = new byte[][]{data};
    }

    public final byte[][] getTable() {
        return this.data;
    }

    public int[] lookupPixel(int[] src, int[] dst) throws ArrayIndexOutOfBoundsException {
        if (dst == null) {
            dst = new int[this.numComponents];
        }
        if (this.data.length == 1) {
            for (int i = 0; i < src.length; ++i) {
                dst[i] = this.data[0][src[i] - this.offset];
            }
        } else {
            for (int i = 0; i < src.length; ++i) {
                dst[i] = this.data[i][src[i] - this.offset];
            }
        }
        return dst;
    }

    public byte[] lookupPixel(byte[] src, byte[] dst) throws ArrayIndexOutOfBoundsException {
        if (dst == null) {
            dst = new byte[this.numComponents];
        }
        if (this.data.length == 1) {
            for (int i = 0; i < src.length; ++i) {
                dst[i] = this.data[0][src[i] - this.offset];
            }
        } else {
            for (int i = 0; i < src.length; ++i) {
                dst[i] = this.data[i][src[i] - this.offset];
            }
        }
        return dst;
    }
}

