/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public final class DataBufferDouble
extends DataBuffer {
    private double[] data;
    private double[][] bankData;

    public DataBufferDouble(int size) {
        super(5, size);
        this.data = new double[size];
    }

    public DataBufferDouble(int size, int numBanks) {
        super(5, size, numBanks);
        this.bankData = new double[numBanks][size];
        this.data = this.bankData[0];
    }

    public DataBufferDouble(double[] dataArray, int size) {
        super(5, size);
        this.data = dataArray;
    }

    public DataBufferDouble(double[] dataArray, int size, int offset) {
        super(5, size, 1, offset);
        this.data = dataArray;
    }

    public DataBufferDouble(double[][] dataArray, int size) {
        super(5, size, dataArray.length);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public DataBufferDouble(double[][] dataArray, int size, int[] offsets) {
        super(5, size, dataArray.length, offsets);
        this.bankData = dataArray;
        this.data = this.bankData[0];
    }

    public double[] getData() {
        return this.data;
    }

    public double[] getData(int bank) {
        return this.bankData[bank];
    }

    public double[][] getBankData() {
        return this.bankData;
    }

    public int getElem(int i) {
        return (int)this.data[i + this.offset];
    }

    public int getElem(int bank, int i) {
        return (int)this.bankData[bank][i + this.offsets[bank]];
    }

    public void setElem(int i, int val) {
        this.data[i + this.offset] = val;
    }

    public void setElem(int bank, int i, int val) {
        this.bankData[bank][i + this.offsets[bank]] = val;
    }

    public float getElemFloat(int i) {
        return (float)this.data[i + this.offset];
    }

    public float getElemFloat(int bank, int i) {
        return (float)this.bankData[bank][i + this.offsets[bank]];
    }

    public void setElemFloat(int i, float val) {
        this.data[i + this.offset] = val;
    }

    public void setElemFloat(int bank, int i, float val) {
        this.bankData[bank][i + this.offsets[bank]] = val;
    }

    public double getElemDouble(int i) {
        return this.data[i + this.offset];
    }

    public double getElemDouble(int bank, int i) {
        return this.bankData[bank][i + this.offsets[bank]];
    }

    public void setElemDouble(int i, double val) {
        this.data[i + this.offset] = val;
    }

    public void setElemDouble(int bank, int i, double val) {
        this.bankData[bank][i + this.offsets[bank]] = val;
    }
}

