/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;
import java.awt.image.IndexColorModel;

public abstract class RGBImageFilter
extends ImageFilter {
    protected ColorModel origmodel;
    protected ColorModel newmodel;
    protected boolean canFilterIndexColorModel;

    private /* synthetic */ void finit$() {
        this.canFilterIndexColorModel = false;
    }

    public RGBImageFilter() {
        this.finit$();
    }

    public void setColorModel(ColorModel model) {
        this.origmodel = model;
        this.newmodel = model;
        if (model instanceof IndexColorModel && this.canFilterIndexColorModel) {
            this.newmodel = this.filterIndexColorModel((IndexColorModel)model);
            this.consumer.setColorModel(this.newmodel);
        } else {
            this.consumer.setColorModel(ColorModel.getRGBdefault());
        }
    }

    public void substituteColorModel(ColorModel oldcm, ColorModel newcm) {
        this.origmodel = oldcm;
        this.newmodel = newcm;
    }

    public IndexColorModel filterIndexColorModel(IndexColorModel icm) {
        int len = icm.getMapSize();
        byte[] reds = new byte[len];
        byte[] greens = new byte[len];
        byte[] blues = new byte[len];
        byte[] alphas = new byte[len];
        icm.getAlphas(alphas);
        icm.getReds(reds);
        icm.getGreens(greens);
        icm.getBlues(blues);
        for (int i = 0; i < len; ++i) {
            int rgb = this.filterRGB(-1, -1, this.makeColor(alphas[i], reds[i], greens[i], blues[i]));
            alphas[i] = (byte)((0xFF000000 & rgb) >> 24);
            reds[i] = (byte)((0xFF0000 & rgb) >> 16);
            greens[i] = (byte)((0xFF00 & rgb) >> 8);
            blues[i] = (byte)rgb & 0xFFFFFFFF;
        }
        return new IndexColorModel(icm.getPixelSize(), len, reds, greens, blues, alphas);
    }

    private int makeColor(byte a, byte r, byte g, byte b) {
        return 0xFF000000 & a << 24 | 0xFF0000 & r << 16 | 0xFF00 & g << 8 | 0xFF & b;
    }

    public void filterRGBPixels(int x, int y, int w, int h, int[] pixels, int off, int scansize) {
        int i = 0;
        for (int xp = x; xp < x + w; ++xp) {
            for (int yp = y; yp < y + h; ++yp) {
                pixels[i] = this.filterRGB(xp, yp, pixels[i]);
                ++i;
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        if (model == this.origmodel && model instanceof IndexColorModel && this.canFilterIndexColorModel) {
            this.consumer.setPixels(x, y, w, h, this.newmodel, pixels, offset, scansize);
        } else {
            int[] intPixels = this.convertColorModelToDefault(x, y, w, h, model, pixels, offset, scansize);
            this.filterRGBPixels(x, y, w, h, intPixels, offset, scansize);
            this.consumer.setPixels(x, y, w, h, ColorModel.getRGBdefault(), intPixels, offset, scansize);
        }
    }

    public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        if (model == this.origmodel && model instanceof IndexColorModel && this.canFilterIndexColorModel) {
            this.consumer.setPixels(x, y, w, h, this.newmodel, pixels, offset, scansize);
        } else {
            this.convertColorModelToDefault(x, y, w, h, model, pixels, offset, scansize);
            this.filterRGBPixels(x, y, w, h, pixels, offset, scansize);
            this.consumer.setPixels(x, y, w, h, ColorModel.getRGBdefault(), pixels, offset, scansize);
        }
    }

    private int[] convertColorModelToDefault(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        int[] intPixels = new int[pixels.length];
        for (int i = 0; i < pixels.length; ++i) {
            intPixels[i] = this.makeColorbyDefaultCM(model, pixels[i]);
        }
        return intPixels;
    }

    private void convertColorModelToDefault(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
        for (int i = 0; i < pixels.length; ++i) {
            pixels[i] = this.makeColorbyDefaultCM(model, pixels[i]);
        }
    }

    private int makeColorbyDefaultCM(ColorModel model, byte rgb) {
        return this.makeColor(model.getAlpha(rgb) * 4, model.getRed(rgb) * 4, model.getGreen(rgb) * 4, model.getBlue(rgb) * 4);
    }

    private int makeColorbyDefaultCM(ColorModel model, int rgb) {
        return this.makeColor(model.getAlpha(rgb), model.getRed(rgb), model.getGreen(rgb), model.getBlue(rgb));
    }

    private int makeColor(int a, int r, int g, int b) {
        return 0xFF000000 & a << 24 | 0xFF0000 & r << 16 | 0xFF00 & g << 8 | 0xFF & b;
    }

    public abstract int filterRGB(int var1, int var2, int var3);
}

