/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;

public abstract class SampleModel {
    protected int width;
    protected int height;
    protected int numBands;
    protected int dataType;

    public SampleModel(int dataType, int w, int h, int numBands) {
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException((w <= 0 ? " width<=0" : " width is ok") + (h <= 0 ? " height<=0" : " height is ok"));
        }
        this.dataType = dataType;
        this.width = w;
        this.height = h;
        this.numBands = numBands;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getNumBands() {
        return this.numBands;
    }

    public abstract int getNumDataElements();

    public final int getDataType() {
        return this.dataType;
    }

    public int getTransferType() {
        return this.dataType;
    }

    public int[] getPixel(int x, int y, int[] iArray, DataBuffer data) {
        if (iArray == null) {
            iArray = new int[this.numBands];
        }
        for (int b = 0; b < this.numBands; ++b) {
            iArray[b] = this.getSample(x, y, b, data);
        }
        return iArray;
    }

    public abstract Object getDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public Object getDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        int size = w * h;
        int numDataElements = this.getNumDataElements();
        int dataSize = numDataElements * size;
        if (obj == null) {
            switch (this.getTransferType()) {
                case 0: {
                    obj = new byte[dataSize];
                    break;
                }
                case 1: {
                    obj = new short[dataSize];
                    break;
                }
                case 3: {
                    obj = new int[dataSize];
                    break;
                }
                default: {
                    throw new ClassCastException();
                }
            }
        }
        Object pixelData = null;
        int outOffset = 0;
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                pixelData = this.getDataElements(xx, yy, pixelData, data);
                System.arraycopy(pixelData, 0, obj, outOffset, numDataElements);
                outOffset += numDataElements;
            }
        }
        return obj;
    }

    public abstract void setDataElements(int var1, int var2, Object var3, DataBuffer var4);

    public void setDataElements(int x, int y, int w, int h, Object obj, DataBuffer data) {
        Object[] pixelData;
        int size = w * h;
        int numDataElements = this.getNumDataElements();
        int dataSize = numDataElements * size;
        switch (this.getTransferType()) {
            case 0: {
                pixelData = new byte[numDataElements];
                break;
            }
            case 1: {
                pixelData = new short[numDataElements];
                break;
            }
            case 3: {
                pixelData = new int[numDataElements];
                break;
            }
            default: {
                throw new ClassCastException();
            }
        }
        int inOffset = 0;
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                System.arraycopy(obj, inOffset, pixelData, 0, numDataElements);
                this.setDataElements(xx, yy, pixelData, data);
                inOffset += numDataElements;
            }
        }
    }

    public float[] getPixel(int x, int y, float[] fArray, DataBuffer data) {
        if (fArray == null) {
            fArray = new float[this.numBands];
        }
        for (int b = 0; b < this.numBands; ++b) {
            fArray[b] = this.getSampleFloat(x, y, b, data);
        }
        return fArray;
    }

    public double[] getPixel(int x, int y, double[] dArray, DataBuffer data) {
        if (dArray == null) {
            dArray = new double[this.numBands];
        }
        for (int b = 0; b < this.numBands; ++b) {
            dArray[b] = this.getSampleDouble(x, y, b, data);
        }
        return dArray;
    }

    public int[] getPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int size = w * h;
        int outOffset = 0;
        int[] pixel = null;
        if (iArray == null) {
            iArray = new int[w * h * this.numBands];
        }
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                this.getPixel(xx, yy, pixel, data);
                System.arraycopy(pixel, 0, iArray, outOffset, this.numBands);
                outOffset += this.numBands;
            }
        }
        return iArray;
    }

    public float[] getPixels(int x, int y, int w, int h, float[] fArray, DataBuffer data) {
        int size = w * h;
        int outOffset = 0;
        float[] pixel = null;
        if (fArray == null) {
            fArray = new float[w * h * this.numBands];
        }
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                this.getPixel(xx, yy, pixel, data);
                System.arraycopy(pixel, 0, fArray, outOffset, this.numBands);
                outOffset += this.numBands;
            }
        }
        return fArray;
    }

    public double[] getPixels(int x, int y, int w, int h, double[] dArray, DataBuffer data) {
        int size = w * h;
        int outOffset = 0;
        double[] pixel = null;
        if (dArray == null) {
            dArray = new double[w * h * this.numBands];
        }
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                this.getPixel(xx, yy, pixel, data);
                System.arraycopy(pixel, 0, dArray, outOffset, this.numBands);
                outOffset += this.numBands;
            }
        }
        return dArray;
    }

    public abstract int getSample(int var1, int var2, int var3, DataBuffer var4);

    public float getSampleFloat(int x, int y, int b, DataBuffer data) {
        return this.getSample(x, y, b, data);
    }

    public double getSampleDouble(int x, int y, int b, DataBuffer data) {
        return this.getSampleFloat(x, y, b, data);
    }

    public int[] getSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        int size = w * h;
        int outOffset = 0;
        if (iArray == null) {
            iArray = new int[size];
        }
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                iArray[outOffset++] = this.getSample(xx, yy, b, data);
            }
        }
        return iArray;
    }

    public float[] getSamples(int x, int y, int w, int h, int b, float[] fArray, DataBuffer data) {
        int size = w * h;
        int outOffset = 0;
        if (fArray == null) {
            fArray = new float[size];
        }
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                fArray[outOffset++] = this.getSampleFloat(xx, yy, b, data);
            }
        }
        return fArray;
    }

    public double[] getSamples(int x, int y, int w, int h, int b, double[] dArray, DataBuffer data) {
        int size = w * h;
        int outOffset = 0;
        if (dArray == null) {
            dArray = new double[size];
        }
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                dArray[outOffset++] = this.getSampleDouble(xx, yy, b, data);
            }
        }
        return dArray;
    }

    public void setPixel(int x, int y, int[] iArray, DataBuffer data) {
        for (int b = 0; b < this.numBands; ++b) {
            this.setSample(x, y, b, iArray[b], data);
        }
    }

    public void setPixel(int x, int y, float[] fArray, DataBuffer data) {
        for (int b = 0; b < this.numBands; ++b) {
            this.setSample(x, y, b, fArray[b], data);
        }
    }

    public void setPixel(int x, int y, double[] dArray, DataBuffer data) {
        for (int b = 0; b < this.numBands; ++b) {
            this.setSample(x, y, b, dArray[b], data);
        }
    }

    public void setPixels(int x, int y, int w, int h, int[] iArray, DataBuffer data) {
        int inOffset = 0;
        int[] pixel = new int[this.numBands];
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                System.arraycopy(iArray, inOffset, pixel, 0, this.numBands);
                this.setPixel(xx, yy, pixel, data);
                inOffset += this.numBands;
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, float[] fArray, DataBuffer data) {
        int inOffset = 0;
        float[] pixel = new float[this.numBands];
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                System.arraycopy(fArray, inOffset, pixel, 0, this.numBands);
                this.setPixel(xx, yy, pixel, data);
                inOffset += this.numBands;
            }
        }
    }

    public void setPixels(int x, int y, int w, int h, double[] dArray, DataBuffer data) {
        int inOffset = 0;
        double[] pixel = new double[this.numBands];
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                System.arraycopy(dArray, inOffset, pixel, 0, this.numBands);
                this.setPixel(xx, yy, pixel, data);
                inOffset += this.numBands;
            }
        }
    }

    public abstract void setSample(int var1, int var2, int var3, int var4, DataBuffer var5);

    public void setSample(int x, int y, int b, float s, DataBuffer data) {
        this.setSample(x, y, b, (int)s, data);
    }

    public void setSample(int x, int y, int b, double s, DataBuffer data) {
        this.setSample(x, y, b, (float)s, data);
    }

    public void setSamples(int x, int y, int w, int h, int b, int[] iArray, DataBuffer data) {
        int size = w * h;
        int inOffset = 0;
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                this.setSample(xx, yy, b, iArray[inOffset++], data);
            }
        }
    }

    public void setSamples(int x, int y, int w, int h, int b, float[] fArray, DataBuffer data) {
        int size = w * h;
        int inOffset = 0;
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                this.setSample(xx, yy, b, fArray[inOffset++], data);
            }
        }
    }

    public void setSamples(int x, int y, int w, int h, int b, double[] dArray, DataBuffer data) {
        int size = w * h;
        int inOffset = 0;
        for (int yy = y; yy < y + h; ++yy) {
            for (int xx = x; xx < x + w; ++xx) {
                this.setSample(xx, yy, b, dArray[inOffset++], data);
            }
        }
    }

    public abstract SampleModel createCompatibleSampleModel(int var1, int var2);

    public abstract SampleModel createSubsetSampleModel(int[] var1);

    public abstract DataBuffer createDataBuffer();

    public abstract int[] getSampleSize();

    public abstract int getSampleSize(int var1);
}

