/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image.renderable;

import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.AffineTransform;

public class RenderContext
implements Cloneable {
    private AffineTransform xform;
    private Shape aoi;
    private RenderingHints hints;

    public RenderContext(AffineTransform xform, Shape aoi, RenderingHints hints) {
        this.xform = xform;
        this.aoi = aoi;
        this.hints = hints;
    }

    public RenderContext(AffineTransform xform) {
        this(xform, null, null);
    }

    public RenderContext(AffineTransform xform, RenderingHints hints) {
        this(xform, null, hints);
    }

    public RenderContext(AffineTransform xform, Shape aoi) {
        this(xform, aoi, null);
    }

    public RenderingHints getRenderingHints() {
        return this.hints;
    }

    public void setRenderingHints(RenderingHints hints) {
        this.hints = hints;
    }

    public void setTransform(AffineTransform xform) {
        this.xform = xform;
    }

    public void preConcatenateTransform(AffineTransform pre) {
        this.preConcetenateTransform(pre);
    }

    public void preConcetenateTransform(AffineTransform pre) {
        this.xform.preConcatenate(pre);
    }

    public void concatenateTransform(AffineTransform post) {
        this.concetenateTransform(post);
    }

    public void concetenateTransform(AffineTransform post) {
        this.xform.concatenate(post);
    }

    public AffineTransform getTransform() {
        return this.xform;
    }

    public void setAreaOfInterest(Shape aoi) {
        this.aoi = aoi;
    }

    public Shape getAreaOfInterest() {
        return this.aoi;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            RenderContext copy = (RenderContext)super.clone();
            if (this.xform != null) {
                copy.xform = (AffineTransform)this.xform.clone();
            }
            if (this.hints != null) {
                copy.hints = (RenderingHints)this.hints.clone();
            }
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }
}

