/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.ItemSelectable;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.DefaultButtonModel;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import javax.swing.text.AttributeSet;

public abstract class AbstractButton
extends JComponent
implements ItemSelectable,
SwingConstants {
    private static final long serialVersionUID = -937921345538462020L;
    Icon default_icon;
    Icon pressed_icon;
    Icon disabeldIcon;
    Icon selectedIcon;
    Icon disabledSelectedIcon;
    Icon rolloverIcon;
    Icon rolloverSelectedIcon;
    Icon current_icon;
    String text;
    int iconTextGap;
    int verticalAlignment;
    int horizontalAlignment;
    int horizontalTextPosition;
    int verticalTextPosition;
    boolean borderPainted;
    boolean focusPainted;
    boolean contentAreaFilled;
    boolean rollOverEnabled;
    Action action;
    protected ButtonModel model;
    Insets margin;
    int mnemonicIndex;
    protected ActionListener actionListener;
    protected ItemListener itemListener;
    protected ChangeListener changeListener;
    long multiClickThreshhold;
    PropertyChangeListener actionPropertyChangeListener;
    private ChangeEvent changeEvent;
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String CONTENT_AREA_FILLED_CHANGED_PROPERTY = "contentAreaFilled";
    public static final String DISABLED_ICON_CHANGED_PROPERTY = "disabledIcon";
    public static final String DISABLED_SELECTED_ICON_CHANGED_PROPERTY = "disabledSelectedIcon";
    public static final String FOCUS_PAINTED_CHANGED_PROPERTY = "focusPainted";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String MARGIN_CHANGED_PROPERTY = "margin";
    public static final String MNEMONIC_CHANGED_PROPERTY = "mnemonic";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String PRESSED_ICON_CHANGED_PROPERTY = "pressedIcon";
    public static final String ROLLOVER_ENABLED_CHANGED_PROPERTY = "rolloverEnabled";
    public static final String ROLLOVER_ICON_CHANGED_PROPERTY = "rolloverIcon";
    public static final String ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY = "rolloverSelectedIcon";
    public static final String SELECTED_ICON_CHANGED_PROPERTY = "selectedIcon";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";

    private /* synthetic */ void finit$() {
        this.changeEvent = new ChangeEvent(this);
    }

    public AbstractButton() {
        this("", null);
    }

    AbstractButton(String txt, Icon icon) {
        this.finit$();
        this.init(txt, icon);
        this.updateUI();
    }

    public ButtonModel getModel() {
        return this.model;
    }

    public void setModel(ButtonModel newModel) {
        if (newModel == this.model) {
            return;
        }
        if (this.model != null) {
            this.model.removeActionListener(this.actionListener);
            this.model.removeChangeListener(this.changeListener);
            this.model.removeItemListener(this.itemListener);
        }
        ButtonModel old = this.model;
        this.model = newModel;
        if (this.model != null) {
            this.model.addActionListener(this.actionListener);
            this.model.addChangeListener(this.changeListener);
            this.model.addItemListener(this.itemListener);
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, old, this.model);
        this.revalidate();
        this.repaint();
    }

    protected void init(String text, Icon icon) {
        this.text = text;
        this.default_icon = icon;
        this.model = new DefaultButtonModel();
        this.actionListener = this.createActionListener();
        this.changeListener = this.createChangeListener();
        this.itemListener = this.createItemListener();
        this.model.addActionListener(this.actionListener);
        this.model.addChangeListener(this.changeListener);
        this.model.addItemListener(this.itemListener);
        this.horizontalAlignment = 0;
        this.horizontalTextPosition = 11;
        this.verticalAlignment = 0;
        this.verticalTextPosition = 0;
        this.borderPainted = true;
        this.contentAreaFilled = true;
        this.focusPainted = true;
        this.setFocusable(true);
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.5f);
        this.setDisplayedMnemonicIndex(-1);
    }

    public String getActionCommand() {
        return this.getModel().getActionCommand();
    }

    public void setActionCommand(String aCommand) {
        this.getModel().setActionCommand(aCommand);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(AbstractButton.class$("java.awt.event.ActionListener"), l);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(AbstractButton.class$("java.awt.event.ActionListener"), l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(AbstractButton.class$("java.awt.event.ActionListener"));
    }

    public void addItemListener(ItemListener l) {
        this.listenerList.add(AbstractButton.class$("java.awt.event.ItemListener"), l);
    }

    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(AbstractButton.class$("java.awt.event.ItemListener"), l);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(AbstractButton.class$("java.awt.event.ItemListener"));
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(AbstractButton.class$("javax.swing.event.ChangeListener"), l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(AbstractButton.class$("javax.swing.event.ChangeListener"), l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(AbstractButton.class$("javax.swing.event.ChangeListener"));
    }

    public void fireItemStateChanged(ItemEvent e) {
        e.setSource(this);
        ItemListener[] listeners = this.getItemListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].itemStateChanged(e);
        }
    }

    public void fireActionPerformed(ActionEvent e) {
        e.setSource(this);
        ActionListener[] listeners = this.getActionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].actionPerformed(e);
        }
    }

    public void fireStateChanged(ChangeEvent e) {
        ChangeListener[] listeners = this.getChangeListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].stateChanged(this.changeEvent);
        }
    }

    public int getMnemonic() {
        return this.getModel().getMnemonic();
    }

    public void setMnemonic(char mne) {
        this.setMnemonic((int)mne);
    }

    public void setMnemonic(int mne) {
        int old = this.getModel().getMnemonic();
        if (old != mne) {
            this.getModel().setMnemonic(mne);
            if (this.text != null && !this.text.equals("")) {
                char upperCaseMne = Character.toUpperCase((char)mne);
                String upperCaseText = this.text.toUpperCase();
                this.setDisplayedMnemonicIndex(upperCaseText.indexOf(upperCaseMne));
            }
            this.firePropertyChange(MNEMONIC_CHANGED_PROPERTY, old, mne);
            this.revalidate();
            this.repaint();
        }
    }

    public void setDisplayedMnemonicIndex(int index) {
        if (index < -1 || this.text != null && index >= this.text.length()) {
            throw new IllegalArgumentException();
        }
        this.mnemonicIndex = index;
    }

    public int getDisplayedMnemonicIndex() {
        return this.mnemonicIndex;
    }

    public void setRolloverEnabled(boolean r) {
        if (this.rollOverEnabled != r) {
            this.rollOverEnabled = r;
            this.firePropertyChange(ROLLOVER_ENABLED_CHANGED_PROPERTY, r ^ true, r);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isRolloverEnabled() {
        return this.rollOverEnabled;
    }

    public void setSelected(boolean s) {
        this.getModel().setSelected(s);
    }

    public boolean isSelected() {
        return this.getModel().isSelected();
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.getModel().setEnabled(b);
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int a) {
        int old = this.horizontalAlignment;
        this.horizontalAlignment = a;
        if (old != a) {
            this.firePropertyChange(HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY, old, a);
            this.revalidate();
            this.repaint();
        }
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int t) {
        int old = this.horizontalTextPosition;
        this.horizontalTextPosition = t;
        if (old != t) {
            this.firePropertyChange(HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY, old, t);
            this.revalidate();
            this.repaint();
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int a) {
        int old = this.verticalAlignment;
        this.verticalAlignment = a;
        if (old != a) {
            this.firePropertyChange(VERTICAL_ALIGNMENT_CHANGED_PROPERTY, old, a);
            this.revalidate();
            this.repaint();
        }
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int t) {
        int old = this.verticalTextPosition;
        this.verticalTextPosition = t;
        if (old != t) {
            this.firePropertyChange(VERTICAL_TEXT_POSITION_CHANGED_PROPERTY, old, t);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean b) {
        boolean old = this.borderPainted;
        this.borderPainted = b;
        if (b != old) {
            this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, old, b);
            this.revalidate();
            this.repaint();
        }
    }

    public Action getAction() {
        return this.action;
    }

    public void setAction(Action a) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
            this.removeActionListener(this.action);
            if (this.actionPropertyChangeListener != null) {
                this.action.removePropertyChangeListener(this.actionPropertyChangeListener);
                this.actionPropertyChangeListener = null;
            }
        }
        Action old = this.action;
        this.action = a;
        this.configurePropertiesFromAction(this.action);
        if (this.action != null) {
            this.actionPropertyChangeListener = this.createActionPropertyChangeListener(a);
            this.action.addPropertyChangeListener(this.actionPropertyChangeListener);
            this.addActionListener(this.action);
        }
    }

    public Icon getIcon() {
        return this.default_icon;
    }

    public void setIcon(Icon i) {
        if (this.default_icon != i) {
            Icon old = this.default_icon;
            this.default_icon = i;
            this.firePropertyChange(ICON_CHANGED_PROPERTY, old, i);
            this.revalidate();
            this.repaint();
        }
    }

    public String getText() {
        return this.text;
    }

    public void setLabel(String label) {
        this.setText(label);
    }

    public String getLabel() {
        return this.getText();
    }

    public void setText(String t) {
        String old = this.text;
        this.text = t;
        if (t != old) {
            this.firePropertyChange(TEXT_CHANGED_PROPERTY, old, t);
            this.revalidate();
            this.repaint();
        }
    }

    public void setIconTextGap(int i) {
        int old = this.iconTextGap;
        this.iconTextGap = i;
        if (old != i) {
            this.fireStateChanged(new ChangeEvent(this));
            this.revalidate();
            this.repaint();
        }
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public Insets getMargin() {
        return this.margin;
    }

    public void setMargin(Insets m) {
        Insets old = this.margin;
        this.margin = m;
        if (m != old) {
            this.firePropertyChange(MARGIN_CHANGED_PROPERTY, old, m);
            this.revalidate();
            this.repaint();
        }
    }

    public Icon getPressedIcon() {
        return this.pressed_icon;
    }

    public void setPressedIcon(Icon pressedIcon) {
        Icon old = this.pressed_icon;
        this.pressed_icon = pressedIcon;
        if (this.pressed_icon != old) {
            this.firePropertyChange(PRESSED_ICON_CHANGED_PROPERTY, old, this.pressed_icon);
            this.revalidate();
            this.repaint();
        }
    }

    public Icon getDisabledIcon() {
        if (this.disabeldIcon == null && this.default_icon instanceof ImageIcon) {
            this.disabeldIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.default_icon).getImage()));
        }
        return this.disabeldIcon;
    }

    public void setDisabledIcon(Icon d) {
        this.disabeldIcon = d;
        this.revalidate();
        this.repaint();
    }

    public boolean isFocusPainted() {
        return this.focusPainted;
    }

    public void setFocusPainted(boolean p) {
        boolean old = this.focusPainted;
        this.focusPainted = p;
        if (old != this.focusPainted) {
            this.firePropertyChange(FOCUS_PAINTED_CHANGED_PROPERTY, old, p);
            this.revalidate();
            this.repaint();
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected int checkHorizontalKey(int key, String exception) {
        switch (key) {
            case 0: 
            case 2: 
            case 4: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new IllegalArgumentException(exception);
            }
        }
        return key;
    }

    protected int checkVerticalKey(int key, String exception) {
        switch (key) {
            case 0: 
            case 1: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException(exception);
            }
        }
        return key;
    }

    protected void configurePropertiesFromAction(Action a) {
        if (a == null) {
            this.setText(null);
            this.setIcon(null);
            this.setEnabled(true);
            this.setToolTipText(null);
        } else {
            String actionCommand;
            this.setText((String)a.getValue("Name"));
            this.setIcon((Icon)a.getValue("SmallIcon"));
            this.setEnabled(a.isEnabled());
            this.setToolTipText((String)a.getValue("ShortDescription"));
            if (a.getValue("MnemonicKey") != null) {
                this.setMnemonic((Integer)a.getValue("MnemonicKey"));
            }
            if ((actionCommand = (String)a.getValue("ActionCommandKey")) != null) {
                this.setActionCommand((String)a.getValue("ActionCommandKey"));
            } else {
                this.setActionCommand(this.getText());
            }
        }
    }

    protected ActionListener createActionListener() {
        return new ActionListener(this){
            private /* synthetic */ AbstractButton this$0;
            {
                this.this$0 = this$0;
            }

            public void actionPerformed(ActionEvent e) {
                this.this$0.fireActionPerformed(e);
            }
        };
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action a) {
        return new PropertyChangeListener(this){
            private /* synthetic */ AbstractButton this$0;
            {
                this.this$0 = this$0;
            }

            public void propertyChange(PropertyChangeEvent e) {
                Action act = (Action)e.getSource();
                if (e.getPropertyName().equals("enabled")) {
                    this.this$0.setEnabled(act.isEnabled());
                } else if (e.getPropertyName().equals("Name")) {
                    this.this$0.setText((String)act.getValue("Name"));
                } else if (e.getPropertyName().equals("SmallIcon")) {
                    this.this$0.setIcon((Icon)act.getValue("SmallIcon"));
                } else if (e.getPropertyName().equals("ShortDescription")) {
                    this.this$0.setToolTipText((String)act.getValue("ShortDescription"));
                } else if (e.getPropertyName().equals("MnemonicKey")) {
                    if (act.getValue("MnemonicKey") != null) {
                        this.this$0.setMnemonic((Integer)act.getValue("MnemonicKey"));
                    } else if (e.getPropertyName().equals("ActionCommandKey")) {
                        this.this$0.setActionCommand((String)act.getValue("ActionCommandKey"));
                    }
                }
            }
        };
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(this){
            private /* synthetic */ AbstractButton this$0;
            {
                this.this$0 = this$0;
            }

            public void stateChanged(ChangeEvent e) {
                this.this$0.fireStateChanged(e);
                this.this$0.repaint();
            }
        };
    }

    protected ItemListener createItemListener() {
        return new ItemListener(this){
            private /* synthetic */ AbstractButton this$0;
            {
                this.this$0 = this$0;
            }

            public void itemStateChanged(ItemEvent e) {
                this.this$0.fireItemStateChanged(e);
            }
        };
    }

    public void doClick() {
        this.doClick(100);
    }

    public void doClick(int pressTime) {
        this.getModel().setArmed(true);
        this.getModel().setPressed(true);
        try {
            Thread.sleep(pressTime);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getModel().setPressed(false);
        this.getModel().setArmed(false);
    }

    public Icon getDisabledSelectedIcon() {
        return this.disabledSelectedIcon;
    }

    public void setDisabledSelectedIcon(Icon disabledSelectedIcon) {
        Icon old = disabledSelectedIcon;
        if (old != disabledSelectedIcon) {
            this.firePropertyChange(DISABLED_SELECTED_ICON_CHANGED_PROPERTY, old, disabledSelectedIcon);
            this.revalidate();
            this.repaint();
        }
    }

    public Icon getRolloverIcon() {
        return this.rolloverIcon;
    }

    public void setRolloverIcon(Icon r) {
        Icon old = this.rolloverIcon;
        this.rolloverIcon = r;
        if (old != this.rolloverIcon) {
            this.firePropertyChange(ROLLOVER_ICON_CHANGED_PROPERTY, old, this.rolloverIcon);
            this.revalidate();
            this.repaint();
        }
    }

    public Icon getRolloverSelectedIcon() {
        return this.rolloverSelectedIcon;
    }

    public void setRolloverSelectedIcon(Icon r) {
        Icon old = this.rolloverSelectedIcon;
        this.rolloverSelectedIcon = r;
        if (old != this.rolloverSelectedIcon) {
            this.firePropertyChange(ROLLOVER_SELECTED_ICON_CHANGED_PROPERTY, old, this.rolloverSelectedIcon);
            this.revalidate();
            this.repaint();
        }
    }

    public Icon getSelectedIcon() {
        return this.selectedIcon;
    }

    public void setSelectedIcon(Icon s) {
        Icon old = this.selectedIcon;
        this.selectedIcon = s;
        if (old != this.selectedIcon) {
            this.firePropertyChange(SELECTED_ICON_CHANGED_PROPERTY, old, this.selectedIcon);
            this.revalidate();
            this.repaint();
        }
    }

    public Object[] getSelectedObjects() {
        if (this.isSelected()) {
            Object[] objs = new Object[]{this.getText()};
            return objs;
        }
        return null;
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        return this.current_icon == img;
    }

    public boolean isContentAreaFilled() {
        return this.contentAreaFilled;
    }

    public void setContentAreaFilled(boolean b) {
        boolean old = this.contentAreaFilled;
        this.contentAreaFilled = b;
        if (b != old) {
            this.firePropertyChange(CONTENT_AREA_FILLED_CHANGED_PROPERTY, old, b);
            this.revalidate();
            this.repaint();
        }
    }

    protected void paintBorder(Graphics g) {
        if (this.isBorderPainted()) {
            super.paintBorder(g);
        }
    }

    protected String paramString() {
        return "AbstractButton";
    }

    public void setUI(ButtonUI ui) {
        super.setUI(ui);
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.ui;
    }

    public void updateUI() {
    }

    public long getMultiClickThreshhold() {
        return this.multiClickThreshhold;
    }

    public void setMultiClickThreshhold(long threshhold) {
        if (threshhold < 0L) {
            throw new IllegalArgumentException();
        }
        this.multiClickThreshhold = threshhold;
    }

    protected abstract class AccessibleAbstractButton
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleValue,
    AccessibleText {
        private /* synthetic */ AbstractButton this$0;
        private static final long serialVersionUID = -5673062525319836790L;

        protected AccessibleAbstractButton(AbstractButton this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public String getAccessibleName() {
            return null;
        }

        public AccessibleIcon[] getAccessibleIcon() {
            return null;
        }

        public AccessibleRelationSet getAccessibleRelationSet() {
            return null;
        }

        public AccessibleAction getAccessibleAction() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public String getAccessibleActionDescription(int value0) {
            return null;
        }

        public boolean doAccessibleAction(int value0) {
            return false;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public AccessibleText getAccessibleText() {
            return null;
        }

        public int getIndexAtPoint(Point value0) {
            return 0;
        }

        public Rectangle getCharacterBounds(int value0) {
            return null;
        }

        public int getCharCount() {
            return 0;
        }

        public int getCaretPosition() {
            return 0;
        }

        public String getAtIndex(int value0, int value1) {
            return null;
        }

        public String getAfterIndex(int value0, int value1) {
            return null;
        }

        public String getBeforeIndex(int value0, int value1) {
            return null;
        }

        public AttributeSet getCharacterAttribute(int value0) {
            return null;
        }

        public int getSelectionStart() {
            return 0;
        }

        public int getSelectionEnd() {
            return 0;
        }

        public String getSelectedText() {
            return null;
        }

        private Rectangle getTextRectangle() {
            return null;
        }
    }
}

