/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager2;
import java.io.Serializable;

public class BoxLayout
implements LayoutManager2,
Serializable {
    public static final int X_AXIS = 0;
    public static final int Y_AXIS = 1;
    public static final int LINE_AXIS = 2;
    public static final int PAGE_AXIS = 3;
    private static final long serialVersionUID = -2474455742719112368L;
    private Container container;
    private int way;

    private /* synthetic */ void finit$() {
        this.way = 0;
    }

    public BoxLayout(Container container, int way) {
        this.finit$();
        boolean width = false;
        boolean height = false;
        this.container = container;
        this.way = way;
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    private boolean isHorizontalIn(Container parent) {
        ComponentOrientation orientation = parent.getComponentOrientation();
        return this.way == 0 || this.way == 2 && orientation.isHorizontal() || this.way == 3 && orientation.isHorizontal() ^ true;
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (parent != this.container) {
            throw new AWTError("invalid parent");
        }
        int x = 0;
        int y = 0;
        Component[] children = parent.getComponents();
        if (this.isHorizontalIn(parent)) {
            for (int index = 0; index < children.length; ++index) {
                Component comp = children[index];
                Dimension sz = comp.getPreferredSize();
                x += sz.width;
                y = Math.max(y, sz.height);
            }
        } else {
            for (int index = 0; index < children.length; ++index) {
                Component comp = children[index];
                Dimension sz = comp.getPreferredSize();
                y += sz.height;
                x = Math.max(x, sz.width);
            }
        }
        return new Dimension(x, y);
    }

    public Dimension minimumLayoutSize(Container parent) {
        if (parent != this.container) {
            throw new AWTError("invalid parent");
        }
        int x = 0;
        int y = 0;
        Component[] children = parent.getComponents();
        if (this.isHorizontalIn(parent)) {
            for (int index = 0; index < children.length; ++index) {
                Component comp = children[index];
                Dimension sz = comp.getMinimumSize();
                x += sz.width;
                y = Math.max(y, sz.height);
            }
        } else {
            for (int index = 0; index < children.length; ++index) {
                Component comp = children[index];
                Dimension sz = comp.getMinimumSize();
                y += sz.height;
                x = Math.max(x, sz.width);
            }
        }
        return new Dimension(x, y);
    }

    public void layoutContainer(Container parent) {
        if (parent != this.container) {
            throw new AWTError("invalid parent");
        }
        Dimension size = parent.getSize();
        Component[] children = parent.getComponents();
        if (this.isHorizontalIn(parent)) {
            int x = 0;
            for (int index = 0; index < children.length; ++index) {
                Component comp = children[index];
                Dimension sz = comp.getPreferredSize();
                int width = sz.width;
                int height = sz.height;
                int cy = 0;
                if (height > size.height) {
                    height = size.height;
                } else {
                    cy = (int)((float)(size.height - height) * comp.getAlignmentY());
                }
                comp.setSize(width, height);
                comp.setLocation(x, cy);
                x += width;
            }
        } else {
            int y = 0;
            for (int index = 0; index < children.length; ++index) {
                Component comp = children[index];
                Dimension sz = comp.getPreferredSize();
                int width = sz.width;
                int height = sz.height;
                int cx = 0;
                if (width > size.width) {
                    width = size.width;
                } else {
                    cx = (int)((float)(size.width - width) * comp.getAlignmentX());
                }
                comp.setSize(width, height);
                comp.setLocation(cx, y);
                y += height;
            }
        }
    }

    public void addLayoutComponent(Component child, Object constraints) {
    }

    public float getLayoutAlignmentX(Container parent) {
        if (parent != this.container) {
            throw new AWTError("invalid parent");
        }
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container parent) {
        if (parent != this.container) {
            throw new AWTError("invalid parent");
        }
        return 0.0f;
    }

    public void invalidateLayout(Container parent) {
        if (parent != this.container) {
            throw new AWTError("invalid parent");
        }
    }

    public Dimension maximumLayoutSize(Container parent) {
        if (parent != this.container) {
            throw new AWTError("invalid parent");
        }
        int x = 0;
        int y = 0;
        Component[] children = parent.getComponents();
        if (this.isHorizontalIn(parent)) {
            for (int index = 0; index < children.length; ++index) {
                Component comp = children[index];
                Dimension sz = comp.getMaximumSize();
                x += sz.width;
                y = Math.max(y, sz.height);
            }
        } else {
            for (int index = 0; index < children.length; ++index) {
                Component comp = children[index];
                Dimension sz = comp.getMaximumSize();
                y += sz.height;
                x = Math.max(x, sz.width);
            }
        }
        return new Dimension(x, y);
    }
}

