/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.EventListener;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class DefaultButtonModel
implements ButtonModel,
Serializable {
    static final long serialVersionUID = -5342609566534980231L;
    public static final int ARMED = 1;
    public static final int ENABLED = 8;
    public static final int PRESSED = 4;
    public static final int ROLLOVER = 16;
    public static final int SELECTED = 2;
    protected int stateMask;
    protected EventListenerList listenerList;
    protected ChangeEvent changeEvent;
    protected ButtonGroup group;
    protected int mnemonic;
    protected String actionCommand;

    private /* synthetic */ void finit$() {
        this.stateMask = 8;
        this.listenerList = new EventListenerList();
        this.changeEvent = new ChangeEvent(this);
        this.mnemonic = 0;
    }

    public DefaultButtonModel() {
        this.finit$();
    }

    public Object[] getSelectedObjects() {
        return null;
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(DefaultButtonModel.class$("java.awt.event.ActionListener"), l);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(DefaultButtonModel.class$("java.awt.event.ActionListener"), l);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.listenerList.getListeners(DefaultButtonModel.class$("java.awt.event.ActionListener"));
    }

    public void addItemListener(ItemListener l) {
        this.listenerList.add(DefaultButtonModel.class$("java.awt.event.ItemListener"), l);
    }

    public void removeItemListener(ItemListener l) {
        this.listenerList.remove(DefaultButtonModel.class$("java.awt.event.ItemListener"), l);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.listenerList.getListeners(DefaultButtonModel.class$("java.awt.event.ItemListener"));
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(DefaultButtonModel.class$("javax.swing.event.ChangeListener"), l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(DefaultButtonModel.class$("javax.swing.event.ChangeListener"), l);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(DefaultButtonModel.class$("javax.swing.event.ChangeListener"));
    }

    public void fireItemStateChanged(ItemEvent e) {
        ItemListener[] ll = this.getItemListeners();
        for (int i = 0; i < ll.length; ++i) {
            ll[i].itemStateChanged(e);
        }
    }

    public void fireActionPerformed(ActionEvent e) {
        ActionListener[] ll = this.getActionListeners();
        for (int i = 0; i < ll.length; ++i) {
            ll[i].actionPerformed(e);
        }
    }

    public void fireStateChanged() {
        ChangeListener[] ll = this.getChangeListeners();
        for (int i = 0; i < ll.length; ++i) {
            ll[i].stateChanged(this.changeEvent);
        }
    }

    protected void changeState(int stateflag, boolean b) {
        int oldstate = this.stateMask;
        int newstate = b ? oldstate | stateflag : oldstate & ~stateflag;
        if (oldstate == newstate) {
            return;
        }
        if (stateflag != 2 && stateflag != 8 && (this.stateMask & 8) == 0) {
            return;
        }
        this.stateMask = newstate;
        this.fireStateChanged();
        if ((oldstate & 2) == 0 && (newstate & 2) == 2) {
            this.fireItemStateChanged(new ItemEvent(this, 701, null, 1));
            if (this.group != null) {
                this.group.setSelected(this, true);
            }
        } else if ((oldstate & 2) == 2 && (newstate & 2) == 0) {
            this.fireItemStateChanged(new ItemEvent(this, 701, null, 2));
            if (this.group != null) {
                this.group.setSelected(this, false);
            }
        } else if ((oldstate & 1) == 1 && (oldstate & 4) == 4 && (newstate & 1) == 1 && (newstate & 4) == 0) {
            this.fireActionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    public boolean isArmed() {
        return (this.stateMask & 1) != 0;
    }

    public void setArmed(boolean a) {
        this.changeState(1, a);
    }

    public boolean isEnabled() {
        return (this.stateMask >> 3 & 1) != 0;
    }

    public void setEnabled(boolean e) {
        this.changeState(8, e);
    }

    public void setPressed(boolean p) {
        this.changeState(4, p);
    }

    public boolean isPressed() {
        return (this.stateMask >> 2 & 1) != 0;
    }

    public void setRollover(boolean r) {
        this.changeState(16, r);
    }

    public void setSelected(boolean s) {
        this.changeState(2, s);
    }

    public boolean isSelected() {
        return (this.stateMask >> 1 & 1) != 0;
    }

    public boolean isRollover() {
        return (this.stateMask >> 4 & 1) != 0;
    }

    public int getMnemonic() {
        return this.mnemonic;
    }

    public void setMnemonic(int key) {
        if (this.mnemonic != key) {
            this.mnemonic = key;
            this.fireStateChanged();
        }
    }

    public void setActionCommand(String s) {
        if (this.actionCommand != s) {
            this.actionCommand = s;
            this.fireStateChanged();
        }
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setGroup(ButtonGroup g) {
        if (this.group != g) {
            this.group = g;
            this.fireStateChanged();
        }
    }

    public ButtonGroup getGroup() {
        return this.group;
    }
}

