/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;

public class DefaultDesktopManager
implements DesktopManager,
Serializable {
    static final long serialVersionUID = 4657624909838017887L;
    static final String WAS_ICON_ONCE_PROPERTY = "wasIconOnce";
    private int currentDragMode;
    private transient Rectangle dragCache;
    private transient Container pane;
    private transient Rectangle[] iconRects;

    private /* synthetic */ void finit$() {
        this.currentDragMode = 0;
        this.dragCache = new Rectangle();
    }

    public DefaultDesktopManager() {
        this.finit$();
    }

    public void openFrame(JInternalFrame frame) {
        Container c = frame.getParent();
        if (c == null) {
            c = frame.getDesktopIcon().getParent();
        }
        if (c == null) {
            return;
        }
        c.remove(frame.getDesktopIcon());
        c.add(frame);
        frame.setVisible(true);
    }

    public void closeFrame(JInternalFrame frame) {
        Container c = frame.getParent();
        frame.doDefaultCloseAction();
        if (c != null) {
            if (frame.isIcon()) {
                c.remove(frame.getDesktopIcon());
            } else {
                c.remove(frame);
            }
            c.repaint();
        }
    }

    public void maximizeFrame(JInternalFrame frame) {
        if (frame.isIcon()) {
            return;
        }
        frame.setNormalBounds(frame.getBounds());
        Container p = frame.getParent();
        if (p != null) {
            Rectangle pBounds = p.getBounds();
            Insets insets = p.getInsets();
            pBounds.width -= insets.left + insets.right;
            pBounds.height -= insets.top + insets.bottom;
            this.setBoundsForFrame(frame, 0, 0, pBounds.width, pBounds.height);
        }
        if (p instanceof JDesktopPane) {
            ((JDesktopPane)p).setSelectedFrame(frame);
        } else {
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void minimizeFrame(JInternalFrame frame) {
        Rectangle normalBounds = frame.getNormalBounds();
        JDesktopPane p = frame.getDesktopPane();
        if (p != null) {
            p.setSelectedFrame(frame);
        } else {
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        this.setBoundsForFrame(frame, normalBounds.x, normalBounds.y, normalBounds.width, normalBounds.height);
    }

    public void iconifyFrame(JInternalFrame frame) {
        JDesktopPane p = frame.getDesktopPane();
        JInternalFrame.JDesktopIcon icon = frame.getDesktopIcon();
        if (p != null && p.getSelectedFrame() == frame) {
            p.setSelectedFrame(null);
        } else {
            try {
                frame.setSelected(false);
            }
            catch (PropertyVetoException c) {
                // empty catch block
            }
        }
        Container c = frame.getParent();
        if (!this.wasIcon(frame)) {
            Rectangle r = this.getBoundsForIconOf(frame);
            icon.setBounds(r);
            this.setWasIcon(frame, true);
        }
        if (c != null) {
            if (icon != null) {
                c.add(icon);
                icon.setVisible(true);
            }
            c.remove(frame);
        }
    }

    public void deiconifyFrame(JInternalFrame frame) {
        JInternalFrame.JDesktopIcon icon = frame.getDesktopIcon();
        Container c = icon.getParent();
        this.removeIconFor(frame);
        c.add(frame);
        frame.setVisible(true);
        if (!frame.isSelected()) {
            JDesktopPane p = frame.getDesktopPane();
            if (p != null) {
                p.setSelectedFrame(frame);
            } else {
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
            }
        }
        c.invalidate();
    }

    public void activateFrame(JInternalFrame frame) {
        JDesktopPane p = frame.getDesktopPane();
        if (p != null) {
            p.setSelectedFrame(frame);
        } else {
            try {
                frame.setSelected(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        frame.toFront();
    }

    public void deactivateFrame(JInternalFrame frame) {
        JDesktopPane p = frame.getDesktopPane();
        if (p != null) {
            if (p.getSelectedFrame() == frame) {
                p.setSelectedFrame(null);
            }
        } else {
            try {
                frame.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    public void beginDraggingFrame(JComponent component) {
        this.pane = component instanceof JInternalFrame.JDesktopIcon ? ((JInternalFrame.JDesktopIcon)component).getInternalFrame().getDesktopPane() : ((JInternalFrame)component).getDesktopPane();
        if (this.pane == null) {
            return;
        }
        this.dragCache = component.getBounds();
        this.currentDragMode = !(this.pane instanceof JDesktopPane) ? JDesktopPane.LIVE_DRAG_MODE : ((JDesktopPane)this.pane).getDragMode();
    }

    public void dragFrame(JComponent component, int newX, int newY) {
        if (this.currentDragMode != JDesktopPane.OUTLINE_DRAG_MODE) {
            Rectangle b = component.getBounds();
            if (component instanceof JInternalFrame.JDesktopIcon) {
                component.setBounds(newX, newY, b.width, b.height);
            } else {
                this.setBoundsForFrame((JInternalFrame)component, newX, newY, b.width, b.height);
            }
        }
    }

    public void endDraggingFrame(JComponent component) {
        if (this.currentDragMode == JDesktopPane.OUTLINE_DRAG_MODE) {
            this.setBoundsForFrame((JInternalFrame)component, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
            this.pane = null;
            this.dragCache = null;
        }
        component.repaint();
    }

    public void beginResizingFrame(JComponent component, int direction) {
        this.pane = ((JInternalFrame)component).getDesktopPane();
        if (this.pane == null) {
            return;
        }
        this.dragCache = component.getBounds();
        this.currentDragMode = !(this.pane instanceof JDesktopPane) ? JDesktopPane.LIVE_DRAG_MODE : ((JDesktopPane)this.pane).getDragMode();
    }

    public void resizeFrame(JComponent component, int newX, int newY, int newWidth, int newHeight) {
        this.dragCache.setBounds(newX, newY, newWidth, newHeight);
        if (this.currentDragMode != JDesktopPane.OUTLINE_DRAG_MODE) {
            this.setBoundsForFrame(component, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
        }
    }

    public void endResizingFrame(JComponent component) {
        if (this.currentDragMode == JDesktopPane.OUTLINE_DRAG_MODE) {
            this.setBoundsForFrame((JInternalFrame)component, this.dragCache.x, this.dragCache.y, this.dragCache.width, this.dragCache.height);
            this.pane = null;
            this.dragCache = null;
        }
        component.repaint();
    }

    public void setBoundsForFrame(JComponent component, int newX, int newY, int newWidth, int newHeight) {
        component.setBounds(newX, newY, newWidth, newHeight);
        component.revalidate();
        if (component.getParent() != null) {
            component.getParent().repaint();
        } else {
            component.repaint();
        }
    }

    protected void removeIconFor(JInternalFrame frame) {
        JInternalFrame.JDesktopIcon icon = frame.getDesktopIcon();
        Container c = icon.getParent();
        if (c != null && icon != null) {
            c.remove(icon);
        }
    }

    protected Rectangle getBoundsForIconOf(JInternalFrame frame) {
        int i;
        JDesktopPane desktopPane = frame.getDesktopPane();
        Rectangle paneBounds = desktopPane.getBounds();
        Insets insets = desktopPane.getInsets();
        Dimension pref = frame.getDesktopIcon().getPreferredSize();
        if (desktopPane == null) {
            return frame.getDesktopIcon().getBounds();
        }
        Component[] frames = desktopPane.getComponents();
        int count = 0;
        boolean j = false;
        for (i = 0; i < frames.length; ++i) {
            if (!(frames[i] instanceof JInternalFrame.JDesktopIcon) && (!(frames[i] instanceof JInternalFrame) || !((JInternalFrame)frames[i]).getWasIcon() || frames[i] == frame)) continue;
            ++count;
        }
        this.iconRects = new Rectangle[count];
        j = false;
        for (i = 0; i < frames.length; ++i) {
            if (frames[i] instanceof JInternalFrame.JDesktopIcon) {
                this.iconRects[--count] = frames[i].getBounds();
                continue;
            }
            if (!(frames[i] instanceof JInternalFrame) || !((JInternalFrame)frames[i]).getWasIcon() || frames[i] == frame) continue;
            this.iconRects[--count] = ((JInternalFrame)frames[i]).getDesktopIcon().getBounds();
        }
        int startingX = insets.left;
        int startingY = paneBounds.height - insets.bottom - pref.height;
        Rectangle ideal = new Rectangle(startingX, startingY, pref.width, pref.height);
        boolean clear = true;
        while (this.iconRects.length > 0) {
            clear = true;
            for (int i2 = 0; i2 < this.iconRects.length; ++i2) {
                if (this.iconRects[i2] == null || !this.iconRects[i2].intersects(ideal)) continue;
                clear = false;
                break;
            }
            if (clear) {
                return ideal;
            }
            if ((startingX += pref.width) + pref.width > paneBounds.width - insets.right) {
                startingX = insets.left;
                startingY -= pref.height;
            }
            ideal.setBounds(startingX, startingY, pref.width, pref.height);
        }
        return ideal;
    }

    protected void setPreviousBounds(JInternalFrame frame, Rectangle rect) {
        frame.setNormalBounds(rect);
    }

    protected Rectangle getPreviousBounds(JInternalFrame frame) {
        return frame.getNormalBounds();
    }

    protected void setWasIcon(JInternalFrame frame, boolean value) {
        frame.setWasIcon(value, WAS_ICON_ONCE_PROPERTY);
    }

    protected boolean wasIcon(JInternalFrame frame) {
        return frame.getWasIcon();
    }
}

