/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.io.Serializable;
import java.util.BitSet;
import java.util.EventListener;
import javax.swing.ListSelectionModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DefaultListSelectionModel
implements Cloneable,
ListSelectionModel,
Serializable {
    private static final long serialVersionUID = -5718799865110415860L;
    protected EventListenerList listenerList;
    int selectionMode;
    int leadSelectionIndex;
    int anchorSelectionIndex;
    boolean leadAnchorNotificationEnabled;
    boolean valueIsAdjusting;
    BitSet sel;

    private /* synthetic */ void finit$() {
        this.listenerList = new EventListenerList();
        this.selectionMode = 2;
        this.leadSelectionIndex = -1;
        this.anchorSelectionIndex = -1;
        this.leadAnchorNotificationEnabled = true;
        this.valueIsAdjusting = false;
        this.sel = new BitSet();
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int a) {
        this.selectionMode = a;
    }

    public int getAnchorSelectionIndex() {
        return this.anchorSelectionIndex;
    }

    public void setAnchorSelectionIndex(int anchorIndex) {
        this.anchorSelectionIndex = anchorIndex;
    }

    public int getLeadSelectionIndex() {
        return this.leadSelectionIndex;
    }

    public void setLeadSelectionIndex(int leadIndex) {
        int oldLeadIndex = this.leadSelectionIndex;
        this.leadSelectionIndex = leadIndex;
        if (this.anchorSelectionIndex == -1) {
            return;
        }
        int R1 = Math.min(this.anchorSelectionIndex, oldLeadIndex);
        int R2 = Math.max(this.anchorSelectionIndex, oldLeadIndex);
        int S1 = Math.min(this.anchorSelectionIndex, leadIndex);
        int S2 = Math.max(this.anchorSelectionIndex, leadIndex);
        int lo = Math.min(R1, S1);
        int hi = Math.max(R2, S2);
        BitSet oldRange = this.sel.get(lo, hi + 1);
        if (this.isSelectedIndex(this.anchorSelectionIndex)) {
            this.sel.clear(R1, R2 + 1);
            this.sel.set(S1, S2 + 1);
        } else {
            this.sel.set(R1, R2 + 1);
            this.sel.clear(S1, S2 + 1);
        }
        BitSet newRange = this.sel.get(lo, hi + 1);
        newRange.xor(oldRange);
        int beg = this.sel.nextSetBit(0);
        int end = -1;
        int i = beg;
        while (i >= 0) {
            end = i;
            i = this.sel.nextSetBit(i + 1);
        }
        this.fireValueChanged(beg, end, this.valueIsAdjusting);
    }

    public boolean isLeadAnchorNotificationEnabled() {
        return this.leadAnchorNotificationEnabled;
    }

    public void setLeadAnchorNotificationEnabled(boolean l) {
        this.leadAnchorNotificationEnabled = l;
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean v) {
        this.valueIsAdjusting = v;
    }

    public boolean isSelectionEmpty() {
        return this.sel.isEmpty();
    }

    public int getMinSelectionIndex() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        return this.sel.nextSetBit(0);
    }

    public int getMaxSelectionIndex() {
        if (this.isSelectionEmpty()) {
            return -1;
        }
        int mx = -1;
        int i = this.sel.nextSetBit(0);
        while (i >= 0) {
            mx = i;
            i = this.sel.nextSetBit(i + 1);
        }
        return mx;
    }

    public boolean isSelectedIndex(int a) {
        return this.sel.get(a);
    }

    public void addSelectionInterval(int index0, int index1) {
        if (this.selectionMode == 0 || this.selectionMode == 1) {
            this.sel.clear();
        }
        if (this.selectionMode == 0) {
            index0 = index1;
        }
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        this.sel.set(lo, hi + 1);
        this.fireValueChanged(lo, hi, this.valueIsAdjusting);
    }

    public void removeSelectionInterval(int index0, int index1) {
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        this.sel.clear(lo, hi + 1);
        this.fireValueChanged(lo, hi, this.valueIsAdjusting);
    }

    public void clearSelection() {
        int sz = this.sel.size();
        this.sel.clear();
        this.fireValueChanged(0, sz, this.valueIsAdjusting);
    }

    public void setSelectionInterval(int index0, int index1) {
        this.sel.clear();
        if (this.selectionMode == 0) {
            index0 = index1;
        }
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        this.sel.set(lo, hi + 1);
        this.fireValueChanged(lo, hi, this.valueIsAdjusting);
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        if (!before) {
            ++index;
            --length;
        }
        BitSet tmp = this.sel.get(index, this.sel.size());
        this.sel.clear(index, this.sel.size());
        int n = tmp.size();
        for (int i = 0; i < n; ++i) {
            this.sel.set(index + length + i, tmp.get(i));
        }
    }

    public void removeIndexInterval(int index0, int index1) {
        int lo = Math.min(index0, index1);
        int hi = Math.max(index0, index1);
        BitSet tmp = this.sel.get(hi, this.sel.size());
        this.sel.clear(lo, this.sel.size());
        int n = tmp.size();
        for (int i = 0; i < n; ++i) {
            this.sel.set(lo + i, tmp.get(i));
        }
    }

    protected void fireValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        ListSelectionEvent evt = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
        ListSelectionListener[] listeners = this.getListSelectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].valueChanged(evt);
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(DefaultListSelectionModel.class$("javax.swing.event.ListSelectionListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(DefaultListSelectionModel.class$("javax.swing.event.ListSelectionListener"), listener);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.getListeners(DefaultListSelectionModel.class$("javax.swing.event.ListSelectionListener"));
    }

    public DefaultListSelectionModel() {
        this.finit$();
    }
}

