/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.io.Serializable;
import java.net.URL;
import javax.swing.Icon;

public class ImageIcon
implements Icon,
Serializable {
    private static final long serialVersionUID = 532615968316031794L;
    Image image;
    String description;
    ImageObserver observer;

    public ImageIcon() {
    }

    public ImageIcon(String file) {
        this(file, file);
    }

    public ImageIcon(String file, String description) {
        this(Toolkit.getDefaultToolkit().getImage(file), description);
    }

    public ImageIcon(byte[] imageData) {
        this(imageData, null);
    }

    public ImageIcon(byte[] imageData, String description) {
        this(Toolkit.getDefaultToolkit().createImage(imageData), description);
    }

    public ImageIcon(URL url) {
        this(url, null);
    }

    public ImageIcon(URL url, String description) {
        this(Toolkit.getDefaultToolkit().getImage(url), description);
    }

    public ImageIcon(Image image) {
        this(image, null);
    }

    public ImageIcon(Image image, String description) {
        this.image = Toolkit.getDefaultToolkit().createImage(image.getSource());
        this.description = description;
    }

    public ImageObserver getImageObserver() {
        return this.observer;
    }

    public void setImageObserver(ImageObserver newObserver) {
        this.observer = newObserver;
    }

    public Image getImage() {
        return this.image;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getIconHeight() {
        return this.image.getHeight(this.observer);
    }

    public int getIconWidth() {
        return this.image.getWidth(this.observer);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.drawImage(this.image, x, y, this.observer != null ? this.observer : c);
    }
}

