/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.colorchooser.ColorSelectionModel;
import javax.swing.colorchooser.DefaultColorSelectionModel;
import javax.swing.plaf.ColorChooserUI;

public class JColorChooser
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 9168066781620640889L;
    private ColorSelectionModel selectionModel;
    private JComponent previewPanel;
    private AbstractColorChooserPanel[] chooserPanels;
    private boolean dragEnabled;
    public static final String SELECTION_MODEL_PROPERTY = "selectionModel";
    public static final String PREVIEW_PANEL_PROPERTY = "previewPanel";
    public static final String CHOOSER_PANELS_PROPERTY = "chooserPanels";
    protected AccessibleContext accessibleContext;

    public JColorChooser() {
        this(new DefaultColorSelectionModel());
    }

    public JColorChooser(Color initial) {
        this(new DefaultColorSelectionModel(initial));
    }

    public JColorChooser(ColorSelectionModel model) {
        if (model == null) {
            model = new DefaultColorSelectionModel();
        }
        this.selectionModel = model;
        this.updateUI();
    }

    public void setColor(Color color) {
        if (color != null) {
            this.selectionModel.setSelectedColor(color);
        }
    }

    public void setColor(int r, int g, int b) {
        this.selectionModel.setSelectedColor(new Color(r, g, b));
    }

    public void setColor(int color) {
        this.setColor(new Color(color, false));
    }

    public static Color showDialog(Component component, String title, Color initial) {
        JColorChooser choose = new JColorChooser(initial);
        JDialog dialog = JColorChooser.createDialog(component, title, true, choose, null, null);
        dialog.getContentPane().add(choose);
        dialog.pack();
        dialog.show();
        return choose.getColor();
    }

    private static void makeModal(JDialog dialog) {
        try {
            JDialog jDialog = dialog;
            synchronized (jDialog) {
                try {
                    while (dialog.isVisible()) {
                        dialog.wait();
                    }
                    Object var2_2 = null;
                }
                catch (Throwable throwable) {
                    Object var2_3 = null;
                    throw throwable;
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static Component findParent(Component c) {
        Container parent = SwingUtilities.getAncestorOfClass(JColorChooser.class$("java.awt.Frame"), c);
        if (parent != null) {
            return parent;
        }
        parent = SwingUtilities.getAncestorOfClass(JColorChooser.class$("java.awt.Dialog"), c);
        return parent;
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public static JDialog createDialog(Component component, String title, boolean modal, JColorChooser chooserPane, ActionListener okListener, ActionListener cancelListener) {
        Component parent = JColorChooser.findParent(component);
        if (parent == null) {
            throw new AWTError("No suitable parent found for Component.");
        }
        ModalDialog dialog = parent instanceof Frame ? new ModalDialog((Frame)parent, title) : new ModalDialog((Dialog)parent, title);
        ((Dialog)dialog).setModal(modal);
        dialog.getContentPane().setLayout(new BorderLayout());
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        DefaultOKCancelListener al = new DefaultOKCancelListener(dialog);
        JButton ok = new JButton("OK");
        ok.addActionListener(okListener);
        ok.addActionListener(al);
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(cancelListener);
        cancel.addActionListener(al);
        JButton reset = new JButton("Reset");
        reset.addActionListener(new DefaultResetListener(chooserPane));
        dialog.getContentPane().add((Component)chooserPane, "North");
        panel.add(ok);
        panel.add(cancel);
        panel.add(reset);
        dialog.getContentPane().add((Component)panel, "South");
        return dialog;
    }

    public ColorChooserUI getUI() {
        return (ColorChooserUI)this.ui;
    }

    public void setUI(ColorChooserUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ColorChooserUI)UIManager.getUI(this));
        this.revalidate();
    }

    public String getUIClassID() {
        return "ColorChooserUI";
    }

    public Color getColor() {
        return this.selectionModel.getSelectedColor();
    }

    public void setPreviewPanel(JComponent component) {
        if (component != this.previewPanel) {
            JComponent old = this.previewPanel;
            this.previewPanel = component;
            this.firePropertyChange(PREVIEW_PANEL_PROPERTY, old, this.previewPanel);
        }
    }

    public JComponent getPreviewPanel() {
        return this.previewPanel;
    }

    public void addChooserPanel(AbstractColorChooserPanel panel) {
        if (panel == null) {
            return;
        }
        AbstractColorChooserPanel[] old = this.chooserPanels;
        AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[old == null ? 1 : old.length + 1];
        if (old != null) {
            System.arraycopy(old, 0, newPanels, 0, old.length);
        }
        newPanels[newPanels.length - 1] = panel;
        this.chooserPanels = newPanels;
        panel.installChooserPanel(this);
        this.firePropertyChange(CHOOSER_PANELS_PROPERTY, old, newPanels);
    }

    public AbstractColorChooserPanel removeChooserPanel(AbstractColorChooserPanel panel) {
        int index = -1;
        for (int i = 0; i < this.chooserPanels.length; ++i) {
            if (panel != this.chooserPanels[i]) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return null;
        }
        AbstractColorChooserPanel[] old = this.chooserPanels;
        if (this.chooserPanels.length == 1) {
            this.chooserPanels = null;
        } else {
            AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[this.chooserPanels.length - 1];
            System.arraycopy(this.chooserPanels, 0, newPanels, 0, index);
            System.arraycopy(this.chooserPanels, index, newPanels, index - 1, this.chooserPanels.length - index);
            this.chooserPanels = newPanels;
        }
        panel.uninstallChooserPanel(this);
        this.firePropertyChange(CHOOSER_PANELS_PROPERTY, old, this.chooserPanels);
        return panel;
    }

    public void setChooserPanels(AbstractColorChooserPanel[] panels) {
        if (panels != this.chooserPanels) {
            if (this.chooserPanels != null) {
                for (int i = 0; i < this.chooserPanels.length; ++i) {
                    if (this.chooserPanels[i] == null) continue;
                    this.chooserPanels[i].uninstallChooserPanel(this);
                }
            }
            AbstractColorChooserPanel[] old = this.chooserPanels;
            this.chooserPanels = panels;
            if (panels != null) {
                for (int i = 0; i < panels.length; ++i) {
                    if (panels[i] == null) continue;
                    panels[i].installChooserPanel(this);
                }
            }
            this.firePropertyChange(CHOOSER_PANELS_PROPERTY, old, this.chooserPanels);
        }
    }

    public AbstractColorChooserPanel[] getChooserPanels() {
        return this.chooserPanels;
    }

    public ColorSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ColorSelectionModel model) {
        if (model == null) {
            throw new AWTError("ColorSelectionModel is not allowed to be null.");
        }
        this.selectionModel = model;
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public void setDragEnabled(boolean b) {
        this.dragEnabled = b;
    }

    protected String paramString() {
        return "JColorChooser";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJColorChooser(this);
        }
        return this.accessibleContext;
    }

    static class ModalDialog
    extends JDialog {
        private boolean modal;

        public ModalDialog(Frame parent, String title) {
            super(parent, title);
        }

        public ModalDialog(Dialog parent, String title) {
            super(parent, title);
        }

        public void setModal(boolean modal) {
            this.modal = modal;
        }

        public void show() {
            super.show();
            if (this.modal) {
                JColorChooser.makeModal(this);
            }
        }

        public synchronized void hide() {
            super.hide();
            this.notifyAll();
        }
    }

    static class DefaultResetListener
    implements ActionListener {
        private JColorChooser chooser;
        private Color init;

        public DefaultResetListener(JColorChooser chooser) {
            this.chooser = chooser;
            this.init = chooser.getColor();
        }

        public void actionPerformed(ActionEvent e) {
            this.chooser.setColor(this.init);
        }
    }

    static class DefaultOKCancelListener
    implements ActionListener {
        private JDialog dialog;

        public DefaultOKCancelListener(JDialog dialog) {
            this.dialog = dialog;
        }

        public void actionPerformed(ActionEvent e) {
            this.dialog.hide();
        }
    }

    protected class AccessibleJColorChooser
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JColorChooser this$0;
        private static final long serialVersionUID = -2038297864782299082L;

        protected AccessibleJColorChooser(JColorChooser this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COLOR_CHOOSER;
        }
    }
}

