/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.MutableComboBoxModel;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComboBoxUI;

public class JComboBox
extends JComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final long serialVersionUID = 5654585963292734470L;
    public static final int DEFAULT_MAXIMUM_ROW_COUNT = 8;
    public static final String EDITABLE_CHANGED_PROPERTY = "editable";
    public static final String MAXIMUM_ROW_COUNT_CHANGED_PROPERTY = "maximumRowCount";
    public static final String ENABLED_CHANGED_PROPERTY = "enabled";
    public static final String RENDERER_CHANGED_PROPERTY = "renderer";
    public static final String EDITOR_CHANGED_PROPERTY = "editor";
    public static final String MODEL_CHANGED_PROPERTY = "dataModel";
    private static final String uiClassID = "ComboBoxUI";
    protected ComboBoxModel dataModel;
    protected ListCellRenderer renderer;
    protected ComboBoxEditor editor;
    protected int maximumRowCount;
    protected boolean isEditable;
    protected Object selectedItemReminder;
    protected KeySelectionManager keySelectionManager;
    protected String actionCommand;
    protected boolean lightWeightPopupEnabled;
    private Action action;
    private Object prototypeDisplayValue;

    public JComboBox(ComboBoxModel model) {
        this.setEditable(false);
        this.setEnabled(true);
        this.setMaximumRowCount(8);
        this.setModel(model);
        this.setActionCommand("comboBoxChanged");
        if (this.getItemCount() != 0) {
            this.setSelectedItem(this.getItemAt(0));
        }
        this.lightWeightPopupEnabled = true;
        this.isEditable = false;
        this.updateUI();
    }

    public JComboBox(Object[] itemArray) {
        this(new DefaultComboBoxModel(itemArray));
    }

    public JComboBox(Vector itemVector) {
        this(new DefaultComboBoxModel(itemVector));
    }

    public JComboBox() {
        this(new DefaultComboBoxModel());
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    protected void installAncestorListener() {
    }

    public void setUI(ComboBoxUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel newDataModel) {
        if (this.dataModel == newDataModel) {
            return;
        }
        if (this.dataModel != null) {
            this.dataModel.removeListDataListener(this);
        }
        ComboBoxModel oldDataModel = this.dataModel;
        this.dataModel = newDataModel;
        if (this.dataModel != null) {
            this.dataModel.addListDataListener(this);
        }
        this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldDataModel, this.dataModel);
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public void setLightWeightPopupEnabled(boolean enabled) {
        this.lightWeightPopupEnabled = enabled;
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setEditable(boolean editable) {
        if (this.isEditable != editable) {
            this.isEditable = editable;
            this.firePropertyChange(EDITABLE_CHANGED_PROPERTY, this.isEditable ^ true, this.isEditable);
        }
    }

    public void setMaximumRowCount(int rowCount) {
        if (this.maximumRowCount != rowCount) {
            int oldMaximumRowCount = this.maximumRowCount;
            this.maximumRowCount = rowCount;
            this.firePropertyChange(MAXIMUM_ROW_COUNT_CHANGED_PROPERTY, oldMaximumRowCount, this.maximumRowCount);
        }
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setRenderer(ListCellRenderer aRenderer) {
        if (this.renderer != aRenderer) {
            ListCellRenderer oldRenderer = this.renderer;
            this.renderer = aRenderer;
            this.firePropertyChange(RENDERER_CHANGED_PROPERTY, oldRenderer, this.renderer);
        }
    }

    public ListCellRenderer getRenderer() {
        return this.renderer;
    }

    public void setEditor(ComboBoxEditor newEditor) {
        if (this.editor == newEditor) {
            return;
        }
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        ComboBoxEditor oldEditor = this.editor;
        this.editor = newEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange(EDITOR_CHANGED_PROPERTY, oldEditor, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object item) {
        this.dataModel.setSelectedItem(item);
    }

    public Object getSelectedItem() {
        Object item = this.dataModel.getSelectedItem();
        if (item == null && this.getItemCount() != 0) {
            item = this.getItemAt(0);
        }
        return item;
    }

    public void setSelectedIndex(int index) {
        this.setSelectedItem(this.dataModel.getElementAt(index));
    }

    public int getSelectedIndex() {
        Object selectedItem = this.getSelectedItem();
        if (selectedItem != null && this.dataModel instanceof DefaultComboBoxModel) {
            return ((DefaultComboBoxModel)this.dataModel).getIndexOf(selectedItem);
        }
        return -1;
    }

    public Object getPrototypeDisplayValue() {
        return this.prototypeDisplayValue;
    }

    public void setPrototypeDisplayValue(Object prototypeDisplayValue) {
        this.prototypeDisplayValue = prototypeDisplayValue;
    }

    public void addItem(Object element) {
        ((MutableComboBoxModel)this.dataModel).addElement(element);
    }

    public void insertItemAt(Object element, int index) {
        ((MutableComboBoxModel)this.dataModel).insertElementAt(element, index);
    }

    public void removeItem(Object element) {
        ((MutableComboBoxModel)this.dataModel).removeElement(element);
    }

    public void removeItemAt(int index) {
        ((MutableComboBoxModel)this.dataModel).removeElementAt(index);
    }

    public void removeAllItems() {
        if (this.dataModel instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)this.dataModel).removeAllElements();
        }
    }

    public void showPopup() {
        this.setPopupVisible(true);
    }

    public void hidePopup() {
        this.setPopupVisible(false);
    }

    public void setPopupVisible(boolean visible) {
        this.getUI().setPopupVisible(this, visible);
    }

    public boolean isPopupVisible() {
        return this.getUI().isPopupVisible(this);
    }

    public void setActionCommand(String aCommand) {
        this.actionCommand = aCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    public void setAction(Action a) {
        Action old = this.action;
        this.action = a;
        this.configurePropertiesFromAction(this.action);
        if (this.action != null) {
            this.addActionListener(this.action);
        }
    }

    public Action getAction() {
        return this.action;
    }

    protected void configurePropertiesFromAction(Action a) {
        if (a == null) {
            this.setEnabled(true);
            this.setToolTipText(null);
        } else {
            this.setEnabled(a.isEnabled());
            this.setToolTipText((String)a.getValue("ShortDescription"));
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(this){
            private /* synthetic */ JComboBox this$0;
            {
                this.this$0 = this$0;
            }

            public void propertyChange(PropertyChangeEvent e) {
                Action act = (Action)e.getSource();
                this.this$0.configurePropertiesFromAction(act);
            }
        };
    }

    protected void fireItemStateChanged(ItemEvent e) {
        ItemListener[] ll = this.getItemListeners();
        for (int i = 0; i < ll.length; ++i) {
            ll[i].itemStateChanged(e);
        }
    }

    protected void fireActionEvent() {
        ActionListener[] ll = this.getActionListeners();
        for (int i = 0; i < ll.length; ++i) {
            ll[i].actionPerformed(new ActionEvent(this, 1001, this.actionCommand));
        }
    }

    protected void selectedItemChanged() {
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        Object newSelection = this.getSelectedItem();
        this.fireItemStateChanged(new ItemEvent(this, 701, newSelection, 1));
        this.fireActionEvent();
        this.selectedItemReminder = newSelection;
    }

    public Object[] getSelectedObjects() {
        Object selectedObject = this.getSelectedItem();
        return new Object[]{selectedObject};
    }

    public void actionPerformed(ActionEvent e) {
        this.setSelectedItem(((ComboBoxEditor)e.getSource()).getItem());
        this.setPopupVisible(false);
    }

    public boolean selectWithKeyChar(char keyChar) {
        return false;
    }

    public void intervalAdded(ListDataEvent event) {
        this.repaint();
    }

    public void intervalRemoved(ListDataEvent event) {
        this.repaint();
    }

    public void contentsChanged(ListDataEvent event) {
        if (event.getIndex0() == -1 && event.getIndex1() == -1) {
            this.selectedItemChanged();
        }
    }

    public void setEnabled(boolean enabled) {
        boolean oldEnabled = super.isEnabled();
        if (enabled != oldEnabled) {
            super.setEnabled(enabled);
            this.firePropertyChange(ENABLED_CHANGED_PROPERTY, oldEnabled, enabled);
        }
    }

    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        anEditor.setItem(anItem);
    }

    public void processKeyEvent(KeyEvent e) {
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public void setKeySelectionManager(KeySelectionManager aManager) {
    }

    public KeySelectionManager getKeySelectionManager() {
        return null;
    }

    public int getItemCount() {
        return ((DefaultComboBoxModel)this.dataModel).getSize();
    }

    public Object getItemAt(int index) {
        return ((MutableComboBoxModel)this.dataModel).getElementAt(index);
    }

    protected KeySelectionManager createDefaultKeySelectionManager() {
        return null;
    }

    protected String paramString() {
        return "JComboBox";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJComboBox(this);
        }
        return this.accessibleContext;
    }

    public void addActionListener(ActionListener listener) {
        this.listenerList.add(JComboBox.class$("java.awt.event.ActionListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeActionListener(ActionListener listener) {
        this.listenerList.remove(JComboBox.class$("java.awt.event.ActionListener"), listener);
    }

    public ActionListener[] getActionListeners() {
        return (ActionListener[])this.getListeners(JComboBox.class$("java.awt.event.ActionListener"));
    }

    public void addItemListener(ItemListener listener) {
        this.listenerList.add(JComboBox.class$("java.awt.event.ItemListener"), listener);
    }

    public void removeItemListener(ItemListener listener) {
        this.listenerList.remove(JComboBox.class$("java.awt.event.ItemListener"), listener);
    }

    public ItemListener[] getItemListeners() {
        return (ItemListener[])this.getListeners(JComboBox.class$("java.awt.event.ItemListener"));
    }

    public void addPopupMenuListener(PopupMenuListener listener) {
        this.listenerList.add(JComboBox.class$("javax.swing.event.PopupMenuListener"), listener);
    }

    public void removePopupMenuListener(PopupMenuListener listener) {
        this.listenerList.remove(JComboBox.class$("javax.swing.event.PopupMenuListener"), listener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.getListeners(JComboBox.class$("javax.swing.event.PopupMenuListener"));
    }

    protected class AccessibleJComboBox
    extends JComponent.AccessibleJComponent
    implements AccessibleAction,
    AccessibleSelection {
        private /* synthetic */ JComboBox this$0;
        private static final long serialVersionUID = 8217828307256675666L;

        protected AccessibleJComboBox(JComboBox this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int value0) {
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return null;
        }

        public Accessible getAccessibleSelection(int value0) {
            return null;
        }

        public boolean isAccessibleChildSelected(int value0) {
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.COMBO_BOX;
        }

        public AccessibleAction getAccessibleAction() {
            return null;
        }

        public String getAccessibleActionDescription(int value0) {
            return null;
        }

        public int getAccessibleActionCount() {
            return 0;
        }

        public boolean doAccessibleAction(int value0) {
            return false;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public void addAccessibleSelection(int value0) {
        }

        public void removeAccessibleSelection(int value0) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }

    public static interface KeySelectionManager {
        public int selectionForKey(char var1, ComboBoxModel var2);
    }
}

