/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.SwingPropertyChangeSupport;
import javax.swing.plaf.ComponentUI;

public abstract class JComponent
extends Container
implements Serializable {
    private static final long serialVersionUID = -7908749299918704233L;
    protected AccessibleContext accessibleContext;
    Dimension preferredSize;
    Dimension minimumSize;
    Dimension maximumSize;
    float alignmentX;
    float alignmentY;
    Border border;
    String toolTipText;
    boolean doubleBuffered;
    int debugGraphicsOptions;
    boolean opaque;
    protected ComponentUI ui;
    boolean requestFocusEnabled;
    boolean autoscrolls;
    protected EventListenerList listenerList;
    private SwingPropertyChangeSupport changeSupport;
    private Hashtable clientProperties;
    private InputMap inputMap_whenFocused;
    private InputMap inputMap_whenAncestorOfFocused;
    private InputMap inputMap_whenInFocusedWindow;
    private ActionMap actionMap;
    private static final Object paintLock = new Object();
    private static Locale defaultLocale;
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    public static final int UNDEFINED_CONDITION = -1;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;

    private /* synthetic */ void finit$() {
        this.alignmentX = 0.0f;
        this.alignmentY = 0.0f;
        this.doubleBuffered = false;
        this.opaque = false;
        this.autoscrolls = false;
        this.listenerList = new EventListenerList();
    }

    public JComponent() {
        this.finit$();
        super.setLayout(new FlowLayout());
        defaultLocale = Locale.getDefault();
        this.debugGraphicsOptions = -1;
    }

    private Hashtable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new Hashtable();
        }
        return this.clientProperties;
    }

    public Object getClientProperty(Object key) {
        return this.getClientProperties().get(key);
    }

    public void putClientProperty(Object key, Object value) {
        this.getClientProperties().put(key, value);
    }

    public void removeAncestorListener(AncestorListener listener) {
        this.listenerList.remove(JComponent.class$("javax.swing.event.AncestorListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        if (this.changeSupport != null) {
            this.changeSupport.removePropertyChangeListener(propertyName, listener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.listenerList.remove(JComponent.class$("java.beans.VetoableChangeListener"), listener);
    }

    public void addAncestorListener(AncestorListener listener) {
        this.listenerList.add(JComponent.class$("javax.swing.event.AncestorListener"), listener);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this.changeSupport == null) {
            this.changeSupport = new SwingPropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.listenerList.add(JComponent.class$("java.beans.PropertyChangeListener"), listener);
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.listenerList.add(JComponent.class$("java.beans.VetoableChangeListener"), listener);
    }

    public EventListener[] getListeners(Class listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    public AncestorListener[] getAncestorListeners() {
        return (AncestorListener[])this.getListeners(JComponent.class$("javax.swing.event.AncestorListener"));
    }

    public VetoableChangeListener[] getVetoableChangeListeners() {
        return (VetoableChangeListener[])this.getListeners(JComponent.class$("java.beans.VetoableChangeListener"));
    }

    public PropertyChangeListener[] getPropertyChangeListeners(String property) {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners(property);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Boolean(oldValue), new Boolean(newValue));
        }
    }

    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Byte(oldValue), new Byte(newValue));
        }
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Character(oldValue), new Character(newValue));
        }
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
        }
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
        }
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Integer(oldValue), new Integer(newValue));
        }
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        if (this.changeSupport != null) {
            this.changeSupport.firePropertyChange(propertyName, new Short(oldValue), new Short(newValue));
        }
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        VetoableChangeListener[] listeners = this.getVetoableChangeListeners();
        PropertyChangeEvent evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].vetoableChange(evt);
        }
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public float getAlignmentX() {
        return this.alignmentX;
    }

    public float getAlignmentY() {
        return this.alignmentY;
    }

    public boolean getAutoscrolls() {
        return this.autoscrolls;
    }

    public void setBorder(Border border) {
        this.border = border;
        this.revalidate();
        this.repaint();
    }

    public Border getBorder() {
        return this.border;
    }

    public Rectangle getBounds(Rectangle rv) {
        if (rv == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rv.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rv;
    }

    protected Graphics getComponentGraphics(Graphics g) {
        g.setFont(this.getFont());
        g.setColor(this.getForeground());
        return g;
    }

    public int getDebugGraphicsOptions() {
        return 0;
    }

    public Insets getInsets() {
        if (this.border == null) {
            return super.getInsets();
        }
        return this.getBorder().getBorderInsets(this);
    }

    public Insets getInsets(Insets insets) {
        Insets t = this.getInsets();
        if (insets == null) {
            return t;
        }
        insets.left = t.left;
        insets.right = t.right;
        insets.top = t.top;
        insets.bottom = t.bottom;
        return insets;
    }

    public Point getLocation(Point rv) {
        if (rv == null) {
            return new Point(this.getX(), this.getY());
        }
        rv.setLocation(this.getX(), this.getY());
        return rv;
    }

    public Dimension getMaximumSize() {
        Dimension p;
        Dimension s;
        if (this.maximumSize != null) {
            return this.maximumSize;
        }
        if (this.ui != null && (s = this.ui.getMaximumSize(this)) != null) {
            return p;
        }
        p = super.getMaximumSize();
        return p;
    }

    public Dimension getMinimumSize() {
        Dimension p;
        Dimension s;
        if (this.minimumSize != null) {
            return this.minimumSize;
        }
        if (this.ui != null && (s = this.ui.getMinimumSize(this)) != null) {
            return p;
        }
        p = super.getMinimumSize();
        return p;
    }

    public Dimension getPreferredSize() {
        Dimension p;
        Dimension s;
        if (this.preferredSize != null) {
            return this.preferredSize;
        }
        if (this.ui != null && (s = this.ui.getPreferredSize(this)) != null) {
            return p;
        }
        p = super.getPreferredSize();
        return p;
    }

    public Component getNextFocusableComponent() {
        return null;
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        return null;
    }

    public JRootPane getRootPane() {
        JRootPane p = SwingUtilities.getRootPane(this);
        return p;
    }

    public Dimension getSize(Dimension rv) {
        if (rv == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        rv.setSize(this.getWidth(), this.getHeight());
        return rv;
    }

    public JToolTip createToolTip() {
        JToolTip toolTip = new JToolTip();
        toolTip.setComponent(this);
        toolTip.setTipText(this.toolTipText);
        return toolTip;
    }

    public Point getToolTipLocation(MouseEvent event) {
        return null;
    }

    public void setToolTipText(String text) {
        if (text == null) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
            this.toolTipText = null;
            return;
        }
        String oldText = this.toolTipText;
        this.toolTipText = text;
        if (oldText == null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    public String getToolTipText() {
        return this.toolTipText;
    }

    public String getToolTipText(MouseEvent event) {
        return this.getToolTipText();
    }

    public Container getTopLevelAncestor() {
        Container c;
        for (Container peek = c = this.getParent(); peek != null; peek = peek.getParent()) {
            c = peek;
        }
        return c;
    }

    public void computeVisibleRect(Rectangle rect) {
        Container c = this.getParent();
        if (c != null && c instanceof JComponent) {
            ((JComponent)c).computeVisibleRect(rect);
            rect.translate(-this.getX(), -this.getY());
            Rectangle2D.intersect(rect, new Rectangle(0, 0, this.getWidth(), this.getHeight()), rect);
        } else {
            rect.setRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public Rectangle getVisibleRect() {
        Rectangle r = new Rectangle();
        this.computeVisibleRect(r);
        return r;
    }

    public void grabFocus() {
    }

    public boolean isDoubleBuffered() {
        return this.doubleBuffered;
    }

    public static boolean isLightweightComponent(Component c) {
        return c.getPeer() instanceof LightweightPeer;
    }

    public boolean isManagingFocus() {
        return false;
    }

    public boolean isOpaque() {
        return this.opaque;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    public boolean isPaintingTile() {
        return false;
    }

    public boolean isRequestFocusEnabled() {
        return this.requestFocusEnabled;
    }

    public boolean isValidateRoot() {
        return false;
    }

    public void paint(Graphics g) {
        Graphics g2 = g;
        Image doubleBuffer = null;
        RepaintManager rm = RepaintManager.currentManager(this);
        if (this.isDoubleBuffered() && rm.isDoubleBufferingEnabled() && !Thread.holdsLock(paintLock)) {
            doubleBuffer = rm.getOffscreenBuffer(this, this.getWidth(), this.getHeight());
        }
        Object object = paintLock;
        synchronized (object) {
            block5: {
                try {
                    if (doubleBuffer != null) {
                        g2 = doubleBuffer.getGraphics();
                        g2.setClip(g.getClipBounds());
                    }
                    g2 = this.getComponentGraphics(g2);
                    this.paintComponent(g2);
                    this.paintBorder(g2);
                    this.paintChildren(g2);
                    if (doubleBuffer == null) break block5;
                    g.drawImage(doubleBuffer, 0, 0, null);
                }
                catch (Throwable throwable) {
                    Object var6_7 = null;
                    throw throwable;
                }
            }
            Object var6_6 = null;
        }
    }

    protected void paintBorder(Graphics g) {
        if (this.getBorder() != null) {
            this.getBorder().paintBorder(this, g, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    protected void paintChildren(Graphics g) {
        super.paint(g);
    }

    protected void paintComponent(Graphics g) {
        if (this.ui != null) {
            this.ui.update(g, this);
        }
    }

    public void paintImmediately(int x, int y, int w, int h) {
        this.paintImmediately(new Rectangle(x, y, w, h));
    }

    public void paintImmediately(Rectangle r) {
        Component root = SwingUtilities.getRoot(this);
        if (root == null || !root.isShowing()) {
            return;
        }
        Graphics g = root.getGraphics();
        if (g == null) {
            return;
        }
        Rectangle clip = SwingUtilities.convertRectangle(this, r, root);
        g.setClip(clip);
        root.paint(g);
        g.dispose();
    }

    protected String paramString() {
        return "JComponent";
    }

    public void registerKeyboardAction(ActionListener act, KeyStroke stroke, int cond) {
        this.registerKeyboardAction(act, null, stroke, cond);
    }

    public void registerKeyboardAction(ActionListener act, String cmd, KeyStroke stroke, int cond) {
        this.getInputMap(cond).put(stroke, new ActionListenerProxy(act, cmd));
    }

    public final void setInputMap(int condition, InputMap map) {
        this.enableEvents(8);
        switch (condition) {
            case 0: {
                this.inputMap_whenFocused = map;
                break;
            }
            case 1: {
                this.inputMap_whenAncestorOfFocused = map;
                break;
            }
            case 2: {
                this.inputMap_whenInFocusedWindow = map;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final InputMap getInputMap(int condition) {
        this.enableEvents(8);
        switch (condition) {
            case 0: {
                if (this.inputMap_whenFocused == null) {
                    this.inputMap_whenFocused = new InputMap();
                }
                return this.inputMap_whenFocused;
            }
            case 1: {
                if (this.inputMap_whenAncestorOfFocused == null) {
                    this.inputMap_whenAncestorOfFocused = new InputMap();
                }
                return this.inputMap_whenAncestorOfFocused;
            }
            case 2: {
                if (this.inputMap_whenInFocusedWindow == null) {
                    this.inputMap_whenInFocusedWindow = new InputMap();
                }
                return this.inputMap_whenInFocusedWindow;
            }
        }
        return null;
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0);
    }

    public final ActionMap getActionMap() {
        if (this.actionMap == null) {
            this.actionMap = new ActionMap();
        }
        return this.actionMap;
    }

    public final void setActionMap(ActionMap map) {
        this.actionMap = map;
    }

    public int getConditionForKeyStroke(KeyStroke ks) {
        if (this.inputMap_whenFocused != null && this.inputMap_whenFocused.get(ks) != null) {
            return 0;
        }
        if (this.inputMap_whenAncestorOfFocused != null && this.inputMap_whenAncestorOfFocused.get(ks) != null) {
            return 1;
        }
        if (this.inputMap_whenInFocusedWindow != null && this.inputMap_whenInFocusedWindow.get(ks) != null) {
            return 2;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke ks) {
        Object cmd = this.getInputMap().get(ks);
        if (cmd != null) {
            if (cmd instanceof ActionListenerProxy) {
                return (ActionListenerProxy)cmd;
            }
            if (cmd instanceof String) {
                return this.getActionMap().get(cmd);
            }
        }
        return null;
    }

    protected void processComponentKeyEvent(KeyEvent e) {
    }

    protected void processKeyEvent(KeyEvent e) {
        this.processComponentKeyEvent(e);
        if (!e.isConsumed() && this.processKeyBinding(KeyStroke.getKeyStrokeForEvent(e), e, 0, e.getID() == 401)) {
            e.consume();
        }
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        if (this.isEnabled()) {
            Object cmd;
            Action act = null;
            InputMap map = this.getInputMap(condition);
            if (map != null && (cmd = map.get(ks)) != null) {
                act = cmd instanceof ActionListenerProxy ? (Action)cmd : this.getActionMap().get(cmd);
            }
            if (act != null && act.isEnabled()) {
                return SwingUtilities.notifyAction(act, ks, e, this, e.getModifiers());
            }
        }
        return false;
    }

    public void unregisterKeyboardAction(KeyStroke aKeyStroke) {
    }

    public void resetKeyboardActions() {
        if (this.inputMap_whenFocused != null) {
            this.inputMap_whenFocused.clear();
        }
        if (this.inputMap_whenAncestorOfFocused != null) {
            this.inputMap_whenAncestorOfFocused.clear();
        }
        if (this.inputMap_whenInFocusedWindow != null) {
            this.inputMap_whenInFocusedWindow.clear();
        }
        if (this.actionMap != null) {
            this.actionMap.clear();
        }
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        Rectangle dirty = new Rectangle(x, y, width, height);
        Rectangle vis = this.getVisibleRect();
        dirty = dirty.intersection(vis);
        RepaintManager.currentManager(this).addDirtyRegion(this, dirty.x, dirty.y, dirty.width, dirty.height);
    }

    public void repaint(Rectangle r) {
        this.repaint(0L, (int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public boolean requestDefaultFocus() {
        return false;
    }

    public void revalidate() {
        this.invalidate();
        RepaintManager.currentManager(this).addInvalidComponent(this);
    }

    public void scrollRectToVisible(Rectangle r) {
        Container p = this.getParent();
        if (p instanceof JComponent) {
            ((JComponent)p).scrollRectToVisible(r);
        }
    }

    public void setAlignmentX(float a) {
        this.alignmentX = a;
    }

    public void setAlignmentY(float a) {
        this.alignmentY = a;
    }

    public void setAutoscrolls(boolean a) {
        this.autoscrolls = a;
    }

    public void setDebugGraphicsOptions(int debugOptions) {
        this.debugGraphicsOptions = debugOptions;
    }

    public void setDoubleBuffered(boolean db) {
        this.doubleBuffered = db;
    }

    public void setEnabled(boolean e) {
        super.setEnabled(e);
        this.revalidate();
        this.repaint();
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.revalidate();
        this.repaint();
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        this.revalidate();
        this.repaint();
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        this.revalidate();
        this.repaint();
    }

    public void setMaximumSize(Dimension max) {
        this.maximumSize = max;
        this.revalidate();
        this.repaint();
    }

    public void setMinimumSize(Dimension min) {
        this.minimumSize = min;
        this.revalidate();
        this.repaint();
    }

    public void setPreferredSize(Dimension pref) {
        this.preferredSize = pref;
    }

    public void setNextFocusableComponent(Component aComponent) {
    }

    public void setRequestFocusEnabled(boolean e) {
        this.requestFocusEnabled = e;
    }

    public void setOpaque(boolean isOpaque) {
        this.opaque = isOpaque;
        this.revalidate();
        this.repaint();
    }

    public void setVisible(boolean v) {
        super.setVisible(v);
        this.revalidate();
        this.repaint();
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public String getUIClassID() {
        return "ComponentUI";
    }

    protected void setUI(ComponentUI newUI) {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
        }
        ComponentUI oldUI = this.ui;
        this.ui = newUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", oldUI, newUI);
        this.revalidate();
        this.repaint();
    }

    public void updateUI() {
        System.out.println("update UI not overwritten in class: " + this);
    }

    public static Locale getDefaultLocale() {
        return defaultLocale;
    }

    public static void setDefaultLocale(Locale l) {
        defaultLocale = l;
    }

    static {
        TOOL_TIP_TEXT_KEY = TOOL_TIP_TEXT_KEY;
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public ActionListenerProxy(ActionListener li, String cmd) {
            this.target = li;
            this.bindingCommandName = cmd;
        }

        public void actionPerformed(ActionEvent e) {
            ActionEvent derivedEvent = new ActionEvent(e.getSource(), e.getID(), this.bindingCommandName, e.getModifiers());
            this.target.actionPerformed(derivedEvent);
        }
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer {
        private /* synthetic */ JComponent this$0;
        private static final long serialVersionUID = -7047089700479897799L;
        protected ContainerListener accessibleContainerHandler;
        protected FocusListener accessibleFocusHandler;

        protected AccessibleJComponent(JComponent this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int value0) {
            return null;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public String getAccessibleName() {
            return null;
        }

        public String getAccessibleDescription() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        protected String getBorderTitle(Border value0) {
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            private /* synthetic */ AccessibleJComponent this$1;

            protected AccessibleContainerHandler(AccessibleJComponent this$1) {
                this.this$1 = this$1;
            }

            public void componentAdded(ContainerEvent event) {
            }

            public void componentRemoved(ContainerEvent valevent) {
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            private /* synthetic */ AccessibleJComponent this$1;

            protected AccessibleFocusHandler(AccessibleJComponent this$1) {
                this.this$1 = this$1;
            }

            public void focusGained(FocusEvent event) {
            }

            public void focusLost(FocusEvent valevent) {
            }
        }
    }
}

