/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.beans.PropertyVetoException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.DesktopManager;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;
import javax.swing.plaf.DesktopPaneUI;

public class JDesktopPane
extends JLayeredPane
implements Accessible {
    private static final long serialVersionUID = 766333777224038726L;
    public static int LIVE_DRAG_MODE = 0;
    public static int OUTLINE_DRAG_MODE = 1;
    private transient JInternalFrame selectedFrame;
    transient DesktopManager desktopManager;
    private transient int dragMode;

    private /* synthetic */ void finit$() {
        this.dragMode = LIVE_DRAG_MODE;
    }

    public JDesktopPane() {
        this.finit$();
        this.setLayout(null);
        this.updateUI();
    }

    public DesktopPaneUI getUI() {
        return (DesktopPaneUI)this.ui;
    }

    public void setUI(DesktopPaneUI ui) {
        super.setUI(ui);
    }

    public void setDragMode(int mode) {
        if (mode != LIVE_DRAG_MODE && mode != OUTLINE_DRAG_MODE) {
            throw new IllegalArgumentException("Drag mode not valid.");
        }
        if (mode == OUTLINE_DRAG_MODE) {
            throw new IllegalArgumentException("Outline drag modes are unsupported.");
        }
        this.dragMode = mode;
    }

    public int getDragMode() {
        return this.dragMode;
    }

    public DesktopManager getDesktopManager() {
        return this.desktopManager;
    }

    public void setDesktopManager(DesktopManager manager) {
        this.desktopManager = manager;
    }

    public void updateUI() {
        this.setUI((DesktopPaneUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "DesktopPaneUI";
    }

    public JInternalFrame[] getAllFrames() {
        return JDesktopPane.getFramesFromComponents(this.getComponents());
    }

    public JInternalFrame getSelectedFrame() {
        return this.selectedFrame;
    }

    public void setSelectedFrame(JInternalFrame frame) {
        if (this.selectedFrame != null) {
            try {
                this.selectedFrame.setSelected(false);
            }
            catch (PropertyVetoException e) {
                // empty catch block
            }
        }
        this.selectedFrame = null;
        try {
            if (frame != null) {
                frame.setSelected(true);
            }
            this.selectedFrame = frame;
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
    }

    public JInternalFrame[] getAllFramesInLayer(int layer) {
        return JDesktopPane.getFramesFromComponents(this.getComponentsInLayer(layer));
    }

    public boolean isOpaque() {
        return true;
    }

    protected String paramString() {
        return "JDesktopPane";
    }

    private static JInternalFrame[] getFramesFromComponents(Component[] components) {
        int count = 0;
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof JInternalFrame)) continue;
            ++count;
        }
        JInternalFrame[] value = new JInternalFrame[count];
        int j = 0;
        for (int i = 0; i < components.length && j != count; ++i) {
            if (!(components[i] instanceof JInternalFrame)) continue;
            value[j++] = (JInternalFrame)components[i];
        }
        return value;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJDesktopPane(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleJDesktopPane
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JDesktopPane this$0;
        private static final long serialVersionUID = 6079388927946077570L;

        protected AccessibleJDesktopPane(JDesktopPane this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.DESKTOP_PANE;
        }
    }
}

