/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.beans.PropertyVetoException;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.WindowConstants;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.InternalFrameListener;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.InternalFrameUI;

public class JInternalFrame
extends JComponent
implements Accessible,
WindowConstants,
RootPaneContainer {
    private static final long serialVersionUID = -5425177187760785402L;
    public static String CONTENT_PANE_PROPERTY = "contentPane";
    public static String FRAME_ICON_PROPERTY = "frameIcon";
    public static String GLASS_PANE_PROPERTY = "glassPane";
    public static String IS_CLOSED_PROPERTY = "closed";
    public static String IS_ICON_PROPERTY = "icon";
    public static String IS_MAXIMUM_PROPERTY = "maximum";
    public static String IS_SELECTED_PROPERTY = "selected";
    public static String LAYERED_PANE_PROPERTY = "layeredPane";
    public static String MENU_BAR_PROPERTY = "jMenuBar";
    public static String ROOT_PANE_PROPERTY = "rootPane";
    public static String TITLE_PROPERTY = "title";
    protected boolean closable;
    protected boolean iconable;
    protected boolean isClosed;
    protected boolean isIcon;
    protected boolean isMaximum;
    protected boolean isSelected;
    protected boolean maximizable;
    protected boolean rootPaneCheckingEnabled;
    protected boolean resizable;
    protected JDesktopIcon desktopIcon;
    protected Icon frameIcon;
    protected JRootPane rootPane;
    protected String title;
    private transient Rectangle storedBounds;
    private transient Component defaultFocus;
    private transient int defaultCloseOperation;
    private transient boolean isFirstTimeVisible;
    private transient boolean maxTransition;
    private transient boolean wasIcon;

    private /* synthetic */ void finit$() {
        this.rootPaneCheckingEnabled = true;
        this.defaultCloseOperation = 2;
        this.isFirstTimeVisible = true;
        this.maxTransition = false;
        this.wasIcon = false;
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public JInternalFrame() {
        this(null, false, false, false, false);
    }

    public JInternalFrame(String title) {
        this(title, false, false, false, false);
    }

    public JInternalFrame(String title, boolean resizable) {
        this(title, resizable, false, false, false);
    }

    public JInternalFrame(String title, boolean resizable, boolean closable) {
        this(title, resizable, closable, false, false);
    }

    public JInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable) {
        this(title, resizable, closable, maximizable, false);
    }

    public JInternalFrame(String title, boolean resizable, boolean closable, boolean maximizable, boolean iconifiable) {
        this.finit$();
        this.title = title;
        this.resizable = resizable;
        this.closable = closable;
        this.maximizable = maximizable;
        this.iconable = iconifiable;
        this.storedBounds = new Rectangle();
        this.setRootPaneCheckingEnabled(false);
        this.setRootPane(this.createRootPane());
        this.updateUI();
        this.setRootPaneCheckingEnabled(true);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        if (this.isRootPaneCheckingEnabled()) {
            throw new Error("Do not use add() on JInternalPane directly. Use getContentPane().add() instead");
        }
        super.addImpl(comp, constraints, index);
    }

    public void addInternalFrameListener(InternalFrameListener l) {
        this.listenerList.add(JInternalFrame.class$("javax.swing.event.InternalFrameListener"), l);
    }

    protected JRootPane createRootPane() {
        return new JRootPane();
    }

    public void dispose() {
        this.hide();
        JDesktopPane pane = this.getDesktopPane();
        if (pane != null) {
            pane.setSelectedFrame(null);
        } else {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        this.isClosed = true;
        this.fireInternalFrameEvent(25551);
        this.removeNotify();
    }

    public void doDefaultCloseAction() {
        this.fireInternalFrameEvent(25550);
        switch (this.getDefaultCloseOperation()) {
            case 1: {
                this.hide();
                break;
            }
            case 2: {
                this.dispose();
            }
        }
    }

    protected void fireInternalFrameEvent(int id) {
        Object[] ifListeners = this.listenerList.getListenerList();
        InternalFrameEvent evt = new InternalFrameEvent(this, id);
        switch (id) {
            case 25550: {
                for (int i = ifListeners.length - 2; i >= 0; i -= 2) {
                    if (ifListeners[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)ifListeners[i + 1]).internalFrameClosing(evt);
                }
                break;
            }
            case 25554: {
                for (int i = ifListeners.length - 2; i >= 0; i -= 2) {
                    if (ifListeners[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)ifListeners[i + 1]).internalFrameActivated(evt);
                }
                break;
            }
            case 25551: {
                for (int i = ifListeners.length - 2; i >= 0; i -= 2) {
                    if (ifListeners[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)ifListeners[i + 1]).internalFrameClosed(evt);
                }
                break;
            }
            case 25555: {
                for (int i = ifListeners.length - 2; i >= 0; i -= 2) {
                    if (ifListeners[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)ifListeners[i + 1]).internalFrameDeactivated(evt);
                }
                break;
            }
            case 25553: {
                for (int i = ifListeners.length - 2; i >= 0; i -= 2) {
                    if (ifListeners[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)ifListeners[i + 1]).internalFrameDeiconified(evt);
                }
                break;
            }
            case 25552: {
                for (int i = ifListeners.length - 2; i >= 0; i -= 2) {
                    if (ifListeners[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)ifListeners[i + 1]).internalFrameIconified(evt);
                }
                break;
            }
            case 25549: {
                for (int i = ifListeners.length - 2; i >= 0; i -= 2) {
                    if (ifListeners[i] != JInternalFrame.class$("javax.swing.event.InternalFrameListener")) continue;
                    ((InternalFrameListener)ifListeners[i + 1]).internalFrameOpened(evt);
                }
                break;
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJInternalFrame(this);
        }
        return this.accessibleContext;
    }

    public Container getContentPane() {
        return this.getRootPane().getContentPane();
    }

    public int getDefaultCloseOperation() {
        return this.defaultCloseOperation;
    }

    public JDesktopIcon getDesktopIcon() {
        if (this.desktopIcon == null) {
            this.desktopIcon = new JDesktopIcon(this);
        }
        return this.desktopIcon;
    }

    public JDesktopPane getDesktopPane() {
        JDesktopPane value = (JDesktopPane)SwingUtilities.getAncestorOfClass(JInternalFrame.class$("javax.swing.JDesktopPane"), this);
        if (value == null && this.desktopIcon != null) {
            value = this.desktopIcon.getDesktopPane();
        }
        return value;
    }

    public Container getFocusCycleRootAncestor() {
        return null;
    }

    public Component getFocusOwner() {
        Component focus;
        if (this.isSelected() && SwingUtilities.isDescendingFrom(focus = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner(), this)) {
            this.defaultFocus = focus;
            return focus;
        }
        return null;
    }

    public Icon getFrameIcon() {
        return this.frameIcon;
    }

    public Component getGlassPane() {
        return this.getRootPane().getGlassPane();
    }

    public InternalFrameListener[] getInternalFrameListeners() {
        return (InternalFrameListener[])this.listenerList.getListeners(JInternalFrame.class$("javax.swing.event.InternalFrameListener"));
    }

    public JMenuBar getJMenuBar() {
        return this.getRootPane().getJMenuBar();
    }

    public int getLayer() {
        JDesktopPane pane = this.getDesktopPane();
        if (pane != null) {
            return pane.getLayer(this);
        }
        return -1;
    }

    public JLayeredPane getLayeredPane() {
        return this.getRootPane().getLayeredPane();
    }

    public JMenuBar getMenuBar() {
        return this.getJMenuBar();
    }

    public Component getMostRecentFocusOwner() {
        if (this.isSelected()) {
            return this.getFocusOwner();
        }
        return this.defaultFocus;
    }

    public Rectangle getNormalBounds() {
        if (!this.isMaximum() && !this.maxTransition) {
            return this.getBounds();
        }
        return this.storedBounds;
    }

    public JRootPane getRootPane() {
        return this.rootPane;
    }

    public String getTitle() {
        return this.title;
    }

    public InternalFrameUI getUI() {
        return (InternalFrameUI)this.ui;
    }

    public String getUIClassID() {
        return "InternalFrameUI";
    }

    public String getWarningString() {
        return null;
    }

    public void hide() {
        JDesktopPane pane = this.getDesktopPane();
        if (pane != null) {
            pane.setSelectedFrame(null);
        } else {
            try {
                this.setSelected(false);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
        super.hide();
    }

    public boolean isClosable() {
        return this.closable;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    public boolean isFocusCycleRoot() {
        return true;
    }

    public boolean isIcon() {
        return this.isIcon;
    }

    public boolean isIconifiable() {
        return this.iconable;
    }

    public boolean isMaximizable() {
        return this.maximizable;
    }

    public boolean isMaximum() {
        return this.isMaximum;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    protected boolean isRootPaneCheckingEnabled() {
        return this.rootPaneCheckingEnabled;
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public void moveToBack() {
        if (this.getParent() instanceof JLayeredPane) {
            ((JLayeredPane)this.getParent()).moveToBack(this);
        }
    }

    public void moveToFront() {
        if (this.getParent() instanceof JLayeredPane) {
            ((JLayeredPane)this.getParent()).moveToFront(this);
        }
    }

    public void pack() {
        try {
            if (this.isIcon()) {
                this.setIcon(false);
            } else if (this.isMaximum()) {
                this.setMaximum(false);
            }
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.doLayout();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    protected String paramString() {
        return "JInternalFrame";
    }

    public void remove(Component comp) {
        super.remove(comp);
    }

    public void removeInternalFrameListener(InternalFrameListener l) {
        this.listenerList.remove(JInternalFrame.class$("javax.swing.event.InternalFrameListener"), l);
    }

    public void reshape(int x, int y, int width, int height) {
        super.reshape(x, y, width, height);
        this.invalidate();
        this.doLayout();
    }

    public void restoreSubcomponentFocus() {
        Component c = this.getMostRecentFocusOwner();
        if (c != null) {
            c.requestFocus();
        }
    }

    public void setClosable(boolean b) {
        this.closable = b;
    }

    public void setClosed(boolean b) throws PropertyVetoException {
        if (b && !this.isClosed()) {
            this.fireInternalFrameEvent(25550);
            this.fireVetoableChange(IS_CLOSED_PROPERTY, false, true);
            this.isClosed = b;
            this.firePropertyChange(IS_CLOSED_PROPERTY, false, true);
            this.fireInternalFrameEvent(25551);
        }
    }

    public void setContentPane(Container c) {
        if (c != this.getContentPane()) {
            Container old = this.getContentPane();
            this.getRootPane().setContentPane(c);
            this.firePropertyChange(CONTENT_PANE_PROPERTY, old, c);
        }
    }

    public void setDefaultCloseOperation(int operation) {
        if (operation != 0 || operation != 1 || operation != 2) {
            throw new Error("Close operation must be one of DO_NOTHING_ON_CLOSE, HIDE_ON_CLOSE, or DISPOSE_ON_CLOSE");
        }
        this.defaultCloseOperation = operation;
    }

    public void setDesktopIcon(JDesktopIcon d) {
        d.setInternalFrame(this);
        this.desktopIcon = d;
    }

    public final void setFocusCycleRoot(boolean focusCycleRoot) {
    }

    public void setFrameIcon(Icon icon) {
        if (icon != this.frameIcon) {
            Icon old = this.frameIcon;
            this.frameIcon = icon;
            this.firePropertyChange(FRAME_ICON_PROPERTY, old, this.frameIcon);
        }
    }

    public void setGlassPane(Component glass) {
        if (glass != this.getGlassPane()) {
            Component old = this.getGlassPane();
            this.getRootPane().setGlassPane(glass);
            this.firePropertyChange(GLASS_PANE_PROPERTY, old, glass);
        }
    }

    public void setIcon(boolean b) throws PropertyVetoException {
        if (b != this.isIcon()) {
            this.fireVetoableChange(IS_ICON_PROPERTY, b, this.isIcon);
            this.isIcon = b;
            this.firePropertyChange(IS_ICON_PROPERTY, this.isIcon ^ true, this.isIcon);
            if (b) {
                this.fireInternalFrameEvent(25552);
            } else {
                this.fireInternalFrameEvent(25553);
            }
        }
    }

    public void setIconifiable(boolean b) {
        this.iconable = b;
    }

    public void setJMenuBar(JMenuBar b) {
        this.getRootPane().setJMenuBar(b);
    }

    public void setLayer(int layer) {
        this.setLayer(new Integer(layer));
    }

    public void setLayer(Integer layer) {
        JDesktopPane p = this.getDesktopPane();
        if (p != null) {
            int pos = p.getPosition(this);
            p.setLayer(this, layer, pos);
        }
    }

    public void setLayeredPane(JLayeredPane layered) {
        if (layered != this.getLayeredPane()) {
            JLayeredPane old = this.getLayeredPane();
            this.getRootPane().setLayeredPane(layered);
            this.firePropertyChange(LAYERED_PANE_PROPERTY, old, layered);
        }
    }

    public void setMaximizable(boolean b) {
        this.maximizable = b;
    }

    public void setLayout(LayoutManager manager) {
        if (this.isRootPaneCheckingEnabled()) {
            throw new Error("Cannot set layout. Use getContentPane().setLayout() instead.");
        }
        super.setLayout(manager);
    }

    public void setMaximum(boolean b) throws PropertyVetoException {
        if (b != this.isMaximum()) {
            this.fireVetoableChange(IS_MAXIMUM_PROPERTY, b, this.isMaximum);
            this.isMaximum = b;
            if (b) {
                this.setNormalBounds(this.getBounds());
            }
            this.maxTransition = b ^ true;
            this.firePropertyChange(IS_MAXIMUM_PROPERTY, this.isMaximum ^ true, this.isMaximum);
            this.maxTransition = false;
        }
    }

    public void setMenuBar(JMenuBar m) {
        this.setJMenuBar(m);
    }

    public void setNormalBounds(Rectangle r) {
        this.storedBounds.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setResizable(boolean b) {
        this.resizable = b;
    }

    protected void setRootPane(JRootPane root) {
        if (this.rootPane != null) {
            this.remove(this.rootPane);
        }
        this.rootPane = root;
        this.add(root);
    }

    protected void setRootPaneCheckingEnabled(boolean enabled) {
        this.rootPaneCheckingEnabled = enabled;
    }

    public void setSelected(boolean selected) throws PropertyVetoException {
        if (selected != this.isSelected()) {
            this.fireVetoableChange(IS_SELECTED_PROPERTY, selected, this.isSelected);
            if (!selected) {
                this.defaultFocus = this.getMostRecentFocusOwner();
            }
            this.isSelected = selected;
            if (selected) {
                this.restoreSubcomponentFocus();
            }
            this.firePropertyChange(IS_SELECTED_PROPERTY, this.isSelected ^ true, this.isSelected);
            if (this.isSelected) {
                this.fireInternalFrameEvent(25554);
            } else {
                this.fireInternalFrameEvent(25555);
            }
        }
    }

    public void setTitle(String title) {
        if (title == null && this.title == null) {
            return;
        }
        if (title == null || this.title == null || !this.title.equals(title)) {
            String old = title;
            this.title = title;
            this.firePropertyChange(TITLE_PROPERTY, old, this.title);
        }
    }

    public void show() {
        if (!this.isVisible()) {
            this.moveToFront();
            super.show();
            JDesktopPane pane = this.getDesktopPane();
            if (pane != null) {
                pane.setSelectedFrame(this);
            } else {
                try {
                    this.setSelected(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
            if (this.isFirstTimeVisible) {
                this.isFirstTimeVisible = false;
                this.fireInternalFrameEvent(25549);
            }
        }
    }

    public void setUI(InternalFrameUI ui) {
        super.setUI(ui);
    }

    public void toBack() {
        this.moveToBack();
    }

    public void toFront() {
        this.moveToFront();
    }

    public void updateUI() {
        this.setUI((InternalFrameUI)UIManager.getUI(this));
    }

    void setWasIcon(boolean b, String ID) {
        if (b && !this.wasIcon) {
            this.wasIcon = b;
            this.firePropertyChange(ID, b ^ true, b);
        }
    }

    boolean getWasIcon() {
        return this.wasIcon;
    }

    private void fireVetoableChange(String name, boolean oldValue, boolean newValue) throws PropertyVetoException {
        super.fireVetoableChange(name, new Boolean(oldValue), new Boolean(newValue));
    }

    public static class JDesktopIcon
    extends JComponent
    implements Accessible {
        JInternalFrame frame;

        public JDesktopIcon(JInternalFrame f) {
            this.frame = f;
            this.updateUI();
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleJDesktopIcon(this);
            }
            return this.accessibleContext;
        }

        public JDesktopPane getDesktopPane() {
            JDesktopPane p = (JDesktopPane)SwingUtilities.getAncestorOfClass(JInternalFrame.class$("javax.swing.JDesktopPane"), this);
            return p;
        }

        public JInternalFrame getInternalFrame() {
            return this.frame;
        }

        public DesktopIconUI getUI() {
            return (DesktopIconUI)this.ui;
        }

        public String getUIClassID() {
            return "DesktopIconUI";
        }

        public void setInternalFrame(JInternalFrame f) {
            this.frame = f;
        }

        public void setUI(DesktopIconUI ui) {
            super.setUI(ui);
        }

        public void updateUI() {
            this.setUI((DesktopIconUI)UIManager.getUI(this));
        }

        protected class AccessibleJDesktopIcon
        extends JComponent.AccessibleJComponent
        implements AccessibleValue {
            private /* synthetic */ JDesktopIcon this$1;

            protected AccessibleJDesktopIcon(JDesktopIcon this$1) {
                this.this$1 = this$1;
                super(this$1);
            }

            public AccessibleRole getAccessibleRole() {
                return null;
            }

            public AccessibleValue getAccessibleValue() {
                return null;
            }

            public Number getCurrentAccessibleValue() {
                return null;
            }

            public Number getMaximumAccessibleValue() {
                return null;
            }

            public Number getMinimumAccessibleValue() {
                return null;
            }

            public boolean setCurrentAccessibleValue(Number n) {
                return false;
            }
        }
    }

    protected class AccessibleJInternalFrame
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JInternalFrame this$0;

        protected AccessibleJInternalFrame(JInternalFrame this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public String getAccessibleName() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number n) {
            return false;
        }
    }
}

