/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.GrayFilter;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.plaf.LabelUI;

public class JLabel
extends JComponent
implements Accessible,
SwingConstants {
    private static final long serialVersionUID = 5496508283662221534L;
    protected Component labelFor;
    private transient String text;
    private transient int horizontalAlignment;
    private transient int horizontalTextPosition;
    private transient int verticalAlignment;
    private transient int verticalTextPosition;
    private transient Icon icon;
    private transient Icon disabledIcon;
    private transient int displayedMnemonic;
    private transient int displayedMnemonicIndex;
    private transient int iconTextGap;
    public static final String DISABLED_ICON_CHANGED_PROPERTY = "disabledIcon";
    public static final String DISPLAYED_MNEMONIC_CHANGED_PROPERTY = "displayedMnemonic";
    public static final String DISPLAYED_MNEMONIC_INDEX_CHANGED_PROPERTY = "displayedMnemonicIndex";
    public static final String HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY = "horizontalAlignment";
    public static final String HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY = "horizontalTextPosition";
    public static final String ICON_CHANGED_PROPERTY = "icon";
    public static final String ICON_TEXT_GAP_CHANGED_PROPERTY = "iconTextGap";
    public static final String LABEL_FOR_CHANGED_PROPERTY = "labelFor";
    public static final String TEXT_CHANGED_PROPERTY = "text";
    public static final String VERTICAL_ALIGNMENT_CHANGED_PROPERTY = "verticalAlignment";
    public static final String VERTICAL_TEXT_POSITION_CHANGED_PROPERTY = "verticalTextPosition";

    private /* synthetic */ void finit$() {
        this.horizontalAlignment = 10;
        this.horizontalTextPosition = 11;
        this.verticalAlignment = 0;
        this.verticalTextPosition = 0;
        this.displayedMnemonic = 0;
        this.displayedMnemonicIndex = -1;
        this.iconTextGap = 4;
    }

    public JLabel() {
        this(null, null, 0);
    }

    public JLabel(Icon image) {
        this(null, image, 0);
    }

    public JLabel(Icon image, int horizontalAlignment) {
        this(null, image, horizontalAlignment);
    }

    public JLabel(String text) {
        this(text, null, 0);
    }

    public JLabel(String text, int horizontalAlignment) {
        this(text, null, horizontalAlignment);
    }

    public JLabel(String text, Icon icon, int horizontalAlignment) {
        this.finit$();
        this.text = text;
        this.icon = icon;
        this.horizontalAlignment = horizontalAlignment;
        this.updateUI();
    }

    public LabelUI getUI() {
        return (LabelUI)this.ui;
    }

    public void setUI(LabelUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((LabelUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "LabelUI";
    }

    protected String paramString() {
        return "JLabel";
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        if (this.text != newText) {
            String oldText = this.text;
            this.text = newText;
            this.firePropertyChange(TEXT_CHANGED_PROPERTY, oldText, newText);
            if (this.text != null && this.text.length() <= this.displayedMnemonicIndex) {
                this.setDisplayedMnemonicIndex(this.text.length() - 1);
            }
        }
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon newIcon) {
        if (this.icon != newIcon) {
            Icon oldIcon = this.icon;
            this.icon = newIcon;
            this.firePropertyChange(ICON_CHANGED_PROPERTY, oldIcon, newIcon);
        }
    }

    public Icon getDisabledIcon() {
        if (this.disabledIcon == null && this.icon instanceof ImageIcon) {
            this.disabledIcon = new ImageIcon(GrayFilter.createDisabledImage(((ImageIcon)this.icon).getImage()));
        }
        return this.disabledIcon;
    }

    public void setDisabledIcon(Icon newIcon) {
        if (this.disabledIcon != newIcon) {
            Icon oldIcon = this.disabledIcon;
            this.disabledIcon = newIcon;
            this.firePropertyChange(DISABLED_ICON_CHANGED_PROPERTY, oldIcon, newIcon);
        }
    }

    public void setDisplayedMnemonic(int mnemonic) {
        if (this.displayedMnemonic != mnemonic) {
            this.firePropertyChange(DISPLAYED_MNEMONIC_CHANGED_PROPERTY, this.displayedMnemonic, mnemonic);
            this.displayedMnemonic = mnemonic;
            if (this.text != null) {
                this.setDisplayedMnemonicIndex(this.text.indexOf(mnemonic));
            }
        }
    }

    public void setDisplayedMnemonic(char mnemonic) {
        this.setDisplayedMnemonic((int)mnemonic);
    }

    public int getDisplayedMnemonic() {
        return this.displayedMnemonic;
    }

    public void setDisplayedMnemonicIndex(int newIndex) throws IllegalArgumentException {
        if (newIndex < -1 || this.text != null && newIndex >= this.text.length()) {
            throw new IllegalArgumentException();
        }
        if (this.text == null || this.text.charAt(newIndex) != this.displayedMnemonic) {
            newIndex = -1;
        }
        if (newIndex != this.displayedMnemonicIndex) {
            this.firePropertyChange(DISPLAYED_MNEMONIC_INDEX_CHANGED_PROPERTY, this.displayedMnemonicIndex, newIndex);
            this.displayedMnemonicIndex = newIndex;
        }
    }

    public int getDisplayedMnemonicIndex() {
        return this.displayedMnemonicIndex;
    }

    protected int checkHorizontalKey(int key, String message) {
        if (key != 2 && key != 0 && key != 4 && key != 10 && key != 11) {
            throw new IllegalArgumentException(message);
        }
        return key;
    }

    protected int checkVerticalKey(int key, String message) {
        if (key != 1 && key != 3 && key != 0) {
            throw new IllegalArgumentException(message);
        }
        return key;
    }

    public int getIconTextGap() {
        return this.iconTextGap;
    }

    public void setIconTextGap(int newGap) {
        if (this.iconTextGap != newGap) {
            this.firePropertyChange(ICON_TEXT_GAP_CHANGED_PROPERTY, this.iconTextGap, newGap);
            this.iconTextGap = newGap;
        }
    }

    public int getVerticalAlignment() {
        return this.verticalAlignment;
    }

    public void setVerticalAlignment(int alignment) {
        if (alignment != this.verticalAlignment) {
            int oldAlignment = this.verticalAlignment;
            this.verticalAlignment = this.checkVerticalKey(alignment, VERTICAL_ALIGNMENT_CHANGED_PROPERTY);
            this.firePropertyChange(VERTICAL_ALIGNMENT_CHANGED_PROPERTY, oldAlignment, this.verticalAlignment);
        }
    }

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        int oldAlignment = this.horizontalAlignment;
        this.horizontalAlignment = this.checkHorizontalKey(alignment, HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY);
        this.firePropertyChange(HORIZONTAL_ALIGNMENT_CHANGED_PROPERTY, oldAlignment, this.horizontalAlignment);
    }

    public int getVerticalTextPosition() {
        return this.verticalTextPosition;
    }

    public void setVerticalTextPosition(int textPosition) {
        if (textPosition != this.verticalTextPosition) {
            int oldPos = this.verticalTextPosition;
            this.verticalTextPosition = this.checkVerticalKey(textPosition, VERTICAL_TEXT_POSITION_CHANGED_PROPERTY);
            this.firePropertyChange(VERTICAL_TEXT_POSITION_CHANGED_PROPERTY, oldPos, this.verticalTextPosition);
        }
    }

    public int getHorizontalTextPosition() {
        return this.horizontalTextPosition;
    }

    public void setHorizontalTextPosition(int textPosition) {
        if (textPosition != this.horizontalTextPosition) {
            int oldPos = this.horizontalTextPosition;
            this.horizontalTextPosition = this.checkHorizontalKey(textPosition, HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY);
            this.firePropertyChange(HORIZONTAL_TEXT_POSITION_CHANGED_PROPERTY, oldPos, this.horizontalTextPosition);
        }
    }

    public boolean imageUpdate(Image img, int infoflags, int x, int y, int w, int h) {
        Icon currIcon;
        Icon icon = currIcon = this.isEnabled() ? this.icon : this.disabledIcon;
        if (currIcon != null && currIcon instanceof ImageIcon) {
            return ((ImageIcon)currIcon).getImage() == img;
        }
        return false;
    }

    public Component getLabelFor() {
        return this.labelFor;
    }

    public void setLabelFor(Component c) {
        if (c != this.labelFor) {
            this.firePropertyChange(LABEL_FOR_CHANGED_PROPERTY, this.labelFor, c);
            this.labelFor = c;
        }
    }

    public void setFont(Font f) {
        super.setFont(f);
        this.repaint();
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }
}

