/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.UIManager;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ListUI;

public class JList
extends JComponent
implements Accessible,
Scrollable {
    private static final long serialVersionUID = 4406629526391098046L;
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    public static final String CELL_RENDERER_PROPERTY_CHANGED = "cellRenderer";
    public static final String FIXED_CELL_HEIGHT_PROPERTY_CHANGED = "fixedCellHeight";
    public static final String FIXED_CELL_WIDTH_PROPERTY_CHANGED = "fixedCellWidth";
    public static final String LAYOUT_ORIENTATION_PROPERTY_CHANGED = "layoutOrientation";
    public static final String MODEL_PROPERTY_CHANGED = "model";
    public static final String PROTOTYPE_CELL_VALUE_PROPERTY_CHANGED = "prototypeCellValue";
    public static final String SELECTION_BACKGROUND_PROPERTY_CHANGED = "selectionBackground";
    public static final String SELECTION_FOREGROUND_PROPERTY_CHANGED = "selectionForeground";
    public static final String SELECTION_MODEL_PROPERTY_CHANGED = "selectionModel";
    boolean dragEnabled;
    ListCellRenderer cellRenderer;
    int fixedCellWidth;
    int fixedCellHeight;
    int layoutOrientation;
    ListModel model;
    Object prototypeCellValue;
    Color selectionBackground;
    Color selectionForeground;
    ListSelectionModel selectionModel;
    boolean valueIsAdjusting;
    int visibleRowCount;
    ListListener listListener;

    void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        ListSelectionEvent evt = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
        ListSelectionListener[] listeners = this.getListSelectionListeners();
        for (int i = 0; i < listeners.length; ++i) {
            listeners[i].valueChanged(evt);
        }
    }

    public JList() {
        this.init();
    }

    public JList(Object[] listData) {
        this.init();
        this.setListData(listData);
    }

    public JList(Vector listData) {
        this.init();
        this.setListData(listData);
    }

    public JList(ListModel listData) {
        this.init();
        this.setModel(listData);
    }

    void init() {
        this.dragEnabled = false;
        this.fixedCellHeight = -1;
        this.fixedCellWidth = -1;
        this.layoutOrientation = 0;
        this.opaque = true;
        this.valueIsAdjusting = false;
        this.visibleRowCount = 8;
        this.cellRenderer = new DefaultListCellRenderer();
        this.listListener = new ListListener(this);
        this.setModel(new DefaultListModel());
        this.setSelectionModel(new DefaultListSelectionModel());
        this.updateUI();
    }

    public int getFixedCellHeight() {
        return this.fixedCellHeight;
    }

    public void setFixedCellHeight(int h) {
        int old = this.fixedCellHeight;
        this.fixedCellHeight = h;
        this.firePropertyChange(FIXED_CELL_WIDTH_PROPERTY_CHANGED, old, h);
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellWidth(int h) {
        int old = this.fixedCellHeight;
        this.fixedCellHeight = h;
        this.firePropertyChange(FIXED_CELL_HEIGHT_PROPERTY_CHANGED, old, h);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int vc) {
        this.visibleRowCount = vc;
        this.revalidate();
        this.repaint();
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this.listenerList.add(JList.class$("javax.swing.event.ListSelectionListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        this.listenerList.remove(JList.class$("javax.swing.event.ListSelectionListener"), listener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        return (ListSelectionListener[])this.getListeners(JList.class$("javax.swing.event.ListSelectionListener"));
    }

    public void setSelectionMode(int a) {
        this.selectionModel.setSelectionMode(a);
    }

    public void setSelectedIndex(int a) {
        this.selectionModel.setSelectionInterval(a, a);
    }

    public void setSelectedIndices(int[] a) {
        for (int i = 0; i < a.length; ++i) {
            this.setSelectedIndex(a[i]);
        }
    }

    public int getSelectedIndex() {
        return this.selectionModel.getMinSelectionIndex();
    }

    public boolean isSelectionEmpty() {
        return this.selectionModel.isSelectionEmpty();
    }

    public int getFirstVisibleIndex() {
        ComponentOrientation or = this.getComponentOrientation();
        Rectangle r = this.getVisibleRect();
        if (or == ComponentOrientation.RIGHT_TO_LEFT) {
            r.translate((int)r.getWidth(), 0);
        }
        return this.getUI().locationToIndex(this, r.getLocation());
    }

    public int locationToIndex(Point location) {
        return this.getUI().locationToIndex(this, location);
    }

    public Point indexToLocation(int index) {
        return null;
    }

    public int getLastVisibleIndex() {
        ComponentOrientation or = this.getComponentOrientation();
        Rectangle r = this.getVisibleRect();
        r.translate(0, (int)r.getHeight());
        if (or == ComponentOrientation.LEFT_TO_RIGHT) {
            r.translate((int)r.getWidth(), 0);
        }
        return this.getUI().locationToIndex(this, r.getLocation());
    }

    public int[] getSelectedIndices() {
        int i;
        if (this.selectionModel.isSelectionEmpty()) {
            return new int[0];
        }
        int lo = this.selectionModel.getMinSelectionIndex();
        int hi = this.selectionModel.getMaxSelectionIndex();
        int n = 0;
        for (i = lo; i < hi; ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            ++n;
        }
        int[] v = new int[n];
        int j = 0;
        for (i = lo; i < hi; ++i) {
            if (!this.selectionModel.isSelectedIndex(i)) continue;
            v[j++] = i;
        }
        return v;
    }

    public boolean isSelectedIndex(int a) {
        return this.selectionModel.isSelectedIndex(a);
    }

    public Object getSelectedValue() {
        int index = this.getSelectedIndex();
        if (index == -1) {
            return null;
        }
        return this.getModel().getElementAt(index);
    }

    public Object[] getSelectedValues() {
        int[] idx = this.getSelectedIndices();
        Object[] v = new Object[idx.length];
        for (int i = 0; i < idx.length; ++i) {
            v[i] = this.getModel().getElementAt(i);
        }
        return v;
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color c) {
        Color old = this.selectionBackground;
        this.selectionBackground = c;
        this.firePropertyChange(SELECTION_BACKGROUND_PROPERTY_CHANGED, old, c);
        this.repaint();
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color c) {
        Color old = this.selectionForeground;
        this.selectionForeground = c;
        this.firePropertyChange(SELECTION_FOREGROUND_PROPERTY_CHANGED, old, c);
    }

    public void setSelectedValue(Object obj, boolean scroll) {
        for (int i = 0; i < this.model.getSize(); ++i) {
            if (!this.model.getElementAt(i).equals(obj)) continue;
            this.setSelectedIndex(i);
            if (!scroll) break;
            this.ensureIndexIsVisible(i);
            break;
        }
    }

    public void ensureIndexIsVisible(int i) {
        this.scrollRectToVisible(this.getUI().getCellBounds(this, i, i));
    }

    public void setListData(Object[] listData) {
        this.setModel(new AbstractListModel(this, listData){
            private /* synthetic */ JList this$0;
            private /* synthetic */ Object[] val$listData;
            {
                this.this$0 = this$0;
                this.finit$(parm$listData);
            }

            private /* synthetic */ void finit$(Object[] parm$listData) {
                this.val$listData = parm$listData;
            }

            public int getSize() {
                return this.val$listData.length;
            }

            public Object getElementAt(int i) {
                return this.val$listData[i];
            }
        });
    }

    public void setListData(Vector listData) {
        this.setModel(new AbstractListModel(this, listData){
            private /* synthetic */ JList this$0;
            private /* synthetic */ Vector val$listData;
            {
                this.this$0 = this$0;
                this.finit$(parm$listData);
            }

            private /* synthetic */ void finit$(Vector parm$listData) {
                this.val$listData = parm$listData;
            }

            public int getSize() {
                return this.val$listData.size();
            }

            public Object getElementAt(int i) {
                return this.val$listData.elementAt(i);
            }
        });
    }

    public ListCellRenderer getCellRenderer() {
        return this.cellRenderer;
    }

    public void setCellRenderer(ListCellRenderer cr) {
        ListCellRenderer old = this.cellRenderer;
        this.cellRenderer = cr;
        this.firePropertyChange(CELL_RENDERER_PROPERTY_CHANGED, old, cr);
        this.revalidate();
        this.repaint();
    }

    public ListModel getModel() {
        return this.model;
    }

    public void setModel(ListModel m) {
        ListModel old = this.model;
        if (old != null) {
            old.removeListDataListener(this.listListener);
        }
        this.model = m;
        if (this.model != null) {
            this.model.addListDataListener(this.listListener);
        }
        this.firePropertyChange(MODEL_PROPERTY_CHANGED, old, m);
        this.revalidate();
        this.repaint();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(ListSelectionModel l) {
        ListSelectionModel old = this.selectionModel;
        if (old != null) {
            old.removeListSelectionListener(this.listListener);
        }
        this.selectionModel = l;
        if (this.selectionModel != null) {
            this.selectionModel.addListSelectionListener(this.listListener);
        }
        this.firePropertyChange(SELECTION_MODEL_PROPERTY_CHANGED, old, l);
        this.revalidate();
        this.repaint();
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void setUI(ListUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ListUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "ListUI";
    }

    public Object getPrototypeCellValue() {
        return this.prototypeCellValue;
    }

    public void setPrototypeCellValue(Object obj) {
        Object old = this.prototypeCellValue;
        Component comp = this.getCellRenderer().getListCellRendererComponent(this, obj, 0, false, false);
        Dimension d = comp.getPreferredSize();
        this.fixedCellWidth = d.width;
        this.fixedCellHeight = d.height;
        this.prototypeCellValue = obj;
        this.firePropertyChange(PROTOTYPE_CELL_VALUE_PROPERTY_CHANGED, old, obj);
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public Dimension getPreferredScrollableViewportSize() {
        int vis = this.getVisibleRowCount();
        int nrows = this.getModel() == null ? 0 : this.getModel().getSize();
        Dimension single = new Dimension(10, 10);
        Object bounds = null;
        if (vis > nrows) {
            Rectangle tmp;
            if (this.fixedCellWidth != -1 && this.fixedCellHeight != -1) {
                single = new Dimension(this.fixedCellWidth, this.fixedCellHeight);
            } else if (nrows != 0 && this.getUI() != null && (tmp = this.getUI().getCellBounds(this, 0, 0)) != null) {
                single = tmp.getSize();
            }
        } else if (this.getUI() != null) {
            return this.getUI().getCellBounds(this, 0, vis - 1).getSize();
        }
        return new Dimension(single.width, single.height * vis);
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        ListUI lui = this.getUI();
        if (orientation == 1) {
            if (direction > 0) {
                Point bottomLeft = new Point(visibleRect.x, visibleRect.y + visibleRect.height);
                int curIdx = lui.locationToIndex(this, bottomLeft);
                Rectangle curBounds = lui.getCellBounds(this, curIdx, curIdx);
                if (curBounds.y + curBounds.height == bottomLeft.y) {
                    if (curIdx + 1 < this.model.getSize()) {
                        Rectangle nxtBounds = lui.getCellBounds(this, curIdx + 1, curIdx + 1);
                        return nxtBounds.height;
                    }
                    return 0;
                }
                return curBounds.y + curBounds.height - bottomLeft.y;
            }
            Point topLeft = new Point(visibleRect.x, visibleRect.y);
            int curIdx = lui.locationToIndex(this, topLeft);
            Rectangle curBounds = lui.getCellBounds(this, curIdx, curIdx);
            if (curBounds.y == topLeft.y) {
                if (curIdx > 0) {
                    Rectangle nxtBounds = lui.getCellBounds(this, curIdx - 1, curIdx - 1);
                    return -nxtBounds.height;
                }
                return 0;
            }
            return curBounds.y - topLeft.y;
        }
        return 1;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 0) {
            return visibleRect.height * direction;
        }
        return visibleRect.width * direction;
    }

    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    private class ListListener
    implements ListSelectionListener,
    ListDataListener {
        private /* synthetic */ JList this$0;

        public void contentsChanged(ListDataEvent event) {
            this.this$0.revalidate();
            this.this$0.repaint();
        }

        public void intervalAdded(ListDataEvent event) {
            this.this$0.revalidate();
            this.this$0.repaint();
        }

        public void intervalRemoved(ListDataEvent event) {
            this.this$0.revalidate();
            this.this$0.repaint();
        }

        public void valueChanged(ListSelectionEvent event) {
            this.this$0.fireSelectionValueChanged(event.getFirstIndex(), event.getLastIndex(), event.getValueIsAdjusting());
            this.this$0.repaint();
        }

        ListListener(JList this$0) {
            this.this$0 = this$0;
        }
    }
}

