/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.MenuItemUI;

public class JMenu
extends JMenuItem
implements Accessible,
MenuElement {
    static final long serialVersionUID = 4227225638931828014L;
    private static final String uiClassID = "MenuUI";
    private JPopupMenu popupMenu;
    private MenuEvent menuEvent;
    private int delay;
    protected WinListener popupListener;
    private Point menuLocation;

    private /* synthetic */ void finit$() {
        this.popupMenu = new JPopupMenu();
        this.menuEvent = new MenuEvent(this);
    }

    public JMenu() {
        this.finit$();
    }

    public JMenu(String text) {
        super(text);
        this.finit$();
    }

    public JMenu(Action action) {
        super(action);
        this.finit$();
        this.createActionChangeListener(this);
    }

    public JMenu(String text, boolean tearoff) {
        this.finit$();
        throw new Error("not implemented");
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    public JMenuItem add(JMenuItem item) {
        return this.popupMenu.add(item);
    }

    public Component add(Component component) {
        return this.popupMenu.add(component);
    }

    public Component add(Component component, int index) {
        return this.popupMenu.add(component, index);
    }

    public JMenuItem add(String text) {
        return this.popupMenu.add(text);
    }

    public JMenuItem add(Action action) {
        return this.popupMenu.add(action);
    }

    public void remove(JMenuItem item) {
        this.popupMenu.remove(item);
    }

    public void remove(int index) {
        this.popupMenu.remove(index);
    }

    public void remove(Component component) {
        int index = this.popupMenu.getComponentIndex(component);
        this.popupMenu.remove(index);
    }

    public void removeAll() {
        this.popupMenu.removeAll();
    }

    public void insert(String text, int index) {
        this.insert(new JMenuItem(text), index);
    }

    public JMenuItem insert(JMenuItem item, int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than zero");
        }
        this.popupMenu.insert(item, index);
        return item;
    }

    public JMenuItem insert(Action action, int index) {
        JMenuItem item = new JMenuItem(action);
        this.insert(item, index);
        return item;
    }

    public void updateUI() {
        super.setUI((MenuItemUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public void setModel(ButtonModel model) {
        super.setModel(model);
    }

    public boolean isSelected() {
        return super.isArmed();
    }

    public void setSelected(boolean selected) {
        if (selected) {
            super.setArmed(true);
            super.setSelected(true);
            if (this.isShowing()) {
                this.fireMenuSelected();
                int x = 0;
                int y = 0;
                if (this.menuLocation == null) {
                    if (this.isTopLevelMenu()) {
                        y = this.getHeight();
                    } else {
                        x = this.getWidth();
                    }
                    this.getPopupMenu().show(this, x, y);
                } else {
                    this.getPopupMenu().show(this, this.menuLocation.x, this.menuLocation.y);
                }
            }
        } else {
            super.setSelected(false);
            super.setArmed(false);
            this.fireMenuDeselected();
            this.popupMenu.setVisible(false);
        }
    }

    public boolean isPopupMenuVisible() {
        return this.popupMenu.isVisible();
    }

    public void setPopupMenuVisible(boolean popup) {
        if (this.getModel().isEnabled()) {
            this.popupMenu.setVisible(popup);
        }
    }

    protected Point getPopupMenuOrigin() {
        if (this.isTopLevelMenu()) {
            return new Point(0, this.getHeight());
        }
        return new Point(this.getWidth(), 0);
    }

    public int getDelay() {
        return this.delay;
    }

    public void setDelay(int delay) {
        if (delay < 0) {
            throw new IllegalArgumentException("delay less than 0");
        }
        this.delay = delay;
    }

    public void setMenuLocation(int x, int y) {
        this.menuLocation = new Point(x, y);
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem item) {
        return new ActionChangedListener(this, item);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    public void insertSeparator(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        this.getPopupMenu().insert(new JPopupMenu.Separator(), index);
    }

    public JMenuItem getItem(int index) {
        if (index < 0) {
            throw new IllegalArgumentException("index less than 0");
        }
        Component c = this.popupMenu.getComponentAtIndex(index);
        if (c instanceof JMenuItem) {
            return (JMenuItem)c;
        }
        return null;
    }

    public int getItemCount() {
        return this.getComponents().length;
    }

    public boolean isTearOff() {
        return false;
    }

    public int getMenuComponentCount() {
        return this.popupMenu.getComponentCount();
    }

    public Component getMenuComponent(int index) {
        return this.popupMenu.getComponentAtIndex(index);
    }

    public Component[] getMenuComponents() {
        return this.popupMenu.getComponents();
    }

    public boolean isTopLevelMenu() {
        return this.getParent() instanceof JMenuBar;
    }

    public boolean isMenuComponent(Component component) {
        return false;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public void addMenuListener(MenuListener listener) {
        this.listenerList.add(JMenu.class$("javax.swing.event.MenuListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeMenuListener(MenuListener listener) {
        this.listenerList.remove(JMenu.class$("javax.swing.event.MenuListener"), listener);
    }

    protected void fireMenuSelected() {
        EventListener[] ll = this.listenerList.getListeners(JMenu.class$("javax.swing.event.MenuListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuListener)ll[i]).menuSelected(this.menuEvent);
        }
    }

    protected void fireMenuDeselected() {
        EventListener[] ll = this.listenerList.getListeners(JMenu.class$("javax.swing.event.MenuListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuListener)ll[i]).menuDeselected(this.menuEvent);
        }
    }

    protected void fireMenuCanceled() {
        EventListener[] ll = this.listenerList.getListeners(JMenu.class$("javax.swing.event.MenuListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuListener)ll[i]).menuCanceled(this.menuEvent);
        }
    }

    protected WinListener createWinListener(JPopupMenu popup) {
        return new WinListener(this, popup);
    }

    public void menuSelectionChanged(boolean changed) {
        this.setSelected(changed);
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[]{this.popupMenu};
    }

    public Component getComponent() {
        return this;
    }

    public void setAccelerator(KeyStroke keystroke) {
        throw new Error("setAccelerator() is not defined for JMenu.  Use setMnemonic() instead.");
    }

    protected void processKeyEvent(KeyEvent event) {
    }

    public void doClick(int time) {
        this.getModel().setArmed(true);
        this.getModel().setPressed(true);
        try {
            Thread.sleep(time);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getModel().setPressed(false);
        this.getModel().setArmed(false);
        this.popupMenu.show(this, this.getWidth(), 0);
    }

    protected String paramString() {
        return "JMenu";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenu(this);
        }
        return this.accessibleContext;
    }

    protected class ActionChangedListener
    implements PropertyChangeListener {
        private /* synthetic */ JMenu this$0;
        private JMenuItem menuItem;

        public ActionChangedListener(JMenu this$0, JMenuItem menuItem) {
            this.this$0 = this$0;
            this.menuItem = menuItem;
            Action a = menuItem.getAction();
            if (a != null) {
                a.addPropertyChangeListener(this);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
        }
    }

    protected class WinListener
    extends WindowAdapter
    implements Serializable {
        private /* synthetic */ JMenu this$0;
        JPopupMenu popupMenu;
        private static final long serialVersionUID = -6415815570638474823L;

        public WinListener(JMenu this$0, JPopupMenu popup) {
            this.this$0 = this$0;
        }

        public void windowClosing(WindowEvent event) {
        }
    }

    protected class AccessibleJMenu
    extends JMenuItem.AccessibleJMenuItem
    implements AccessibleSelection {
        private /* synthetic */ JMenu this$0;

        protected AccessibleJMenu(JMenu this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int value0) {
            return null;
        }

        public AccessibleSelection getAccessibleSelection() {
            return null;
        }

        public Accessible getAccessibleSelection(int value0) {
            return null;
        }

        public boolean isAccessibleChildSelected(int value0) {
            return false;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU;
        }

        public int getAccessibleSelectionCount() {
            return 0;
        }

        public void addAccessibleSelection(int value0) {
        }

        public void removeAccessibleSelection(int value0) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }
}

