/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.UIManager;
import javax.swing.plaf.MenuBarUI;

public class JMenuBar
extends JComponent
implements Accessible,
MenuElement {
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String MARGIN_CHANGED_PROPERTY = "margin";
    private static final long serialVersionUID = -8191026883931977036L;
    private transient SingleSelectionModel selectionModel = new DefaultSingleSelectionModel();
    private boolean borderPainted = true;
    private Insets margin;

    public JMenuBar() {
        this.updateUI();
    }

    public JMenu add(JMenu c) {
        c.setAlignmentX(0.0f);
        super.add(c);
        return c;
    }

    public void addNotify() {
        super.addNotify();
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    public Component getComponent() {
        return this;
    }

    public Component getComponentAtIndex(int i) {
        return this.getComponent(i);
    }

    public int getComponentIndex(Component c) {
        Component[] comps = this.getComponents();
        int index = -1;
        for (int i = 0; i < comps.length; ++i) {
            if (!comps[i].equals(c)) continue;
            index = i;
            break;
        }
        return index;
    }

    public JMenu getHelpMenu() {
        return null;
    }

    public Insets getMargin() {
        if (this.margin == null) {
            return new Insets(0, 0, 0, 0);
        }
        return this.margin;
    }

    public JMenu getMenu(int index) {
        if (this.getComponentAtIndex(index) instanceof JMenu) {
            return (JMenu)this.getComponentAtIndex(index);
        }
        return null;
    }

    public int getMenuCount() {
        return this.getComponentCount();
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public MenuElement[] getSubElements() {
        MenuElement[] subElements = new MenuElement[this.getComponentCount()];
        for (int i = 0; i < this.getComponentCount(); ++i) {
            subElements[i] = this.getMenu(i);
        }
        return subElements;
    }

    public MenuBarUI getUI() {
        return (MenuBarUI)this.ui;
    }

    public String getUIClassID() {
        return "MenuBarUI";
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public boolean isSelected() {
        return this.selectionModel.isSelected();
    }

    public void menuSelectionChanged(boolean isIncluded) {
    }

    protected void paintBorder(Graphics g) {
        if (this.borderPainted) {
            this.getBorder().paintBorder(this, g, 0, 0, this.getSize(null).width, this.getSize(null).height);
        }
    }

    protected String paramString() {
        return "JMenuBar";
    }

    public void processKeyEvent(KeyEvent e, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void removeNotify() {
        super.removeNotify();
    }

    public void setBorderPainted(boolean b) {
        boolean old = this.borderPainted;
        this.borderPainted = b;
        if (b != old) {
            this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, old, b);
            this.revalidate();
            this.repaint();
        }
    }

    public void setHelpMenu(JMenu menu) {
    }

    public void setMargin(Insets m) {
        if (m.equals(this.margin)) {
            Insets oldMargin = this.margin;
            this.margin = m;
            this.firePropertyChange(MARGIN_CHANGED_PROPERTY, oldMargin, this.margin);
        }
        this.margin = m;
    }

    public void setSelected(Component sel) {
        int index = this.getComponentIndex(sel);
        this.selectionModel.setSelectedIndex(index);
    }

    public void setSelectionModel(SingleSelectionModel model) {
        this.selectionModel = model;
        if (this.selectionModel != model) {
            SingleSelectionModel oldModel = this.selectionModel;
            this.selectionModel = model;
            this.firePropertyChange(MODEL_CHANGED_PROPERTY, oldModel, this.selectionModel);
        }
    }

    public void setUI(MenuBarUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        MenuBarUI ui = (MenuBarUI)UIManager.getUI(this);
        this.setUI(ui);
        this.invalidate();
    }

    static {
        BORDER_PAINTED_CHANGED_PROPERTY = BORDER_PAINTED_CHANGED_PROPERTY;
        MODEL_CHANGED_PROPERTY = MODEL_CHANGED_PROPERTY;
        MARGIN_CHANGED_PROPERTY = MARGIN_CHANGED_PROPERTY;
    }
}

