/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuDragMouseEvent;
import javax.swing.event.MenuDragMouseListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.plaf.MenuItemUI;

public class JMenuItem
extends AbstractButton
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -1681004643499461044L;
    private static final String uiClassID = "MenuItemUI";
    private KeyStroke accelerator;

    public JMenuItem() {
        super(null, null);
    }

    public JMenuItem(Icon icon) {
        super(null, icon);
    }

    public JMenuItem(String text) {
        super(text, null);
    }

    public JMenuItem(Action action) {
        super(null, null);
        super.setAction(action);
    }

    public JMenuItem(String text, Icon icon) {
        super(text, icon);
    }

    public JMenuItem(String text, int mnemonic) {
        super(text, null);
        this.setMnemonic(mnemonic);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    protected void init(String text, Icon icon) {
        super.init(text, icon);
        this.focusPainted = false;
        this.horizontalAlignment = 2;
        this.horizontalTextPosition = 2;
    }

    public void setUI(MenuItemUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        MenuItemUI mi = (MenuItemUI)UIManager.getUI(this);
        this.setUI(mi);
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public boolean isArmed() {
        return this.getModel().isArmed();
    }

    public void setArmed(boolean armed) {
        this.getModel().setArmed(armed);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
    }

    public KeyStroke getAccelerator() {
        return this.accelerator;
    }

    public void setAccelerator(KeyStroke keystroke) {
        this.accelerator = keystroke;
    }

    protected void configurePropertiesFromAction(Action action) {
        super.configurePropertiesFromAction(action);
        if (!(this instanceof JMenu) && action != null) {
            this.setAccelerator((KeyStroke)action.getValue("AcceleratorKey"));
        }
    }

    protected PropertyChangeListener createActionPropertyChangeListener(Action action) {
        return new PropertyChangeListener(this){
            private /* synthetic */ JMenuItem this$0;
            {
                this.this$0 = this$0;
            }

            public void propertyChange(PropertyChangeEvent e) {
                Action act = (Action)e.getSource();
                this.this$0.configurePropertiesFromAction(act);
            }
        };
    }

    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
        boolean dragged;
        boolean bl = dragged = (event.getModifiersEx() & 0x400) != 0;
        if (dragged) {
            this.processMenuDragMouseEvent(this.createMenuDragMouseEvent(event, path, manager));
        }
        switch (event.getID()) {
            case 500: {
                break;
            }
            case 504: {
                if (!this.isRolloverEnabled()) break;
                this.model.setRollover(true);
                break;
            }
            case 505: {
                if (this.isRolloverEnabled()) {
                    this.model.setRollover(false);
                }
                if (path[path.length - 1] instanceof JPopupMenu || dragged) break;
                this.setArmed(false);
                break;
            }
            case 501: {
                if ((event.getModifiersEx() & 0x400) == 0) break;
                this.model.setArmed(true);
                this.model.setPressed(true);
                break;
            }
            case 502: {
                break;
            }
            case 503: {
                break;
            }
        }
    }

    private MenuDragMouseEvent createMenuDragMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
        return new MenuDragMouseEvent((Component)event.getSource(), event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger(), path, manager);
    }

    public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void processMenuDragMouseEvent(MenuDragMouseEvent event) {
        switch (event.getID()) {
            case 504: {
                this.fireMenuDragMouseEntered(event);
                break;
            }
            case 505: {
                this.fireMenuDragMouseExited(event);
                break;
            }
            case 506: {
                this.fireMenuDragMouseDragged(event);
                break;
            }
            case 502: {
                this.fireMenuDragMouseReleased(event);
            }
        }
    }

    public void processMenuKeyEvent(MenuKeyEvent event) {
    }

    protected void fireMenuDragMouseEntered(MenuDragMouseEvent event) {
        EventListener[] ll = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuDragMouseListener)ll[i]).menuDragMouseEntered(event);
        }
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    protected void fireMenuDragMouseExited(MenuDragMouseEvent event) {
        EventListener[] ll = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuDragMouseListener)ll[i]).menuDragMouseExited(event);
        }
    }

    protected void fireMenuDragMouseDragged(MenuDragMouseEvent event) {
        EventListener[] ll = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuDragMouseListener)ll[i]).menuDragMouseDragged(event);
        }
    }

    protected void fireMenuDragMouseReleased(MenuDragMouseEvent event) {
        EventListener[] ll = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuDragMouseListener)ll[i]).menuDragMouseReleased(event);
        }
    }

    protected void fireMenuKeyPressed(MenuKeyEvent event) {
        EventListener[] ll = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuKeyListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuKeyListener)ll[i]).menuKeyPressed(event);
        }
    }

    protected void fireMenuKeyReleased(MenuKeyEvent event) {
        EventListener[] ll = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuKeyListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuKeyListener)ll[i]).menuKeyTyped(event);
        }
    }

    protected void fireMenuKeyTyped(MenuKeyEvent event) {
        EventListener[] ll = this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuKeyListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((MenuKeyListener)ll[i]).menuKeyTyped(event);
        }
    }

    public void menuSelectionChanged(boolean changed) {
        if (changed) {
            this.model.setArmed(true);
            if (this.getParent() instanceof JPopupMenu) {
                ((JPopupMenu)this.getParent()).setSelected(this);
            }
        } else {
            this.model.setArmed(false);
            if (this.getParent() instanceof JPopupMenu) {
                ((JPopupMenu)this.getParent()).getSelectionModel().clearSelection();
            }
        }
    }

    public MenuElement[] getSubElements() {
        return new MenuElement[0];
    }

    public Component getComponent() {
        return this;
    }

    public void addMenuDragMouseListener(MenuDragMouseListener listener) {
        this.listenerList.add(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"), listener);
    }

    public void removeMenuDragMouseListener(MenuDragMouseListener listener) {
        this.listenerList.remove(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"), listener);
    }

    public MenuDragMouseListener[] getMenuDragMouseListeners() {
        return (MenuDragMouseListener[])this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuDragMouseListener"));
    }

    public void addMenuKeyListener(MenuKeyListener listener) {
        this.listenerList.add(JMenuItem.class$("javax.swing.event.MenuKeyListener"), listener);
    }

    public void removeMenuKeyListener(MenuKeyListener listener) {
        this.listenerList.remove(JMenuItem.class$("javax.swing.event.MenuKeyListener"), listener);
    }

    public MenuKeyListener[] getMenuKeyListeners() {
        return (MenuKeyListener[])this.listenerList.getListeners(JMenuItem.class$("javax.swing.event.MenuKeyListener"));
    }

    protected String paramString() {
        return "JMenuItem";
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJMenuItem(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleJMenuItem
    extends AbstractButton.AccessibleAbstractButton
    implements ChangeListener {
        private /* synthetic */ JMenuItem this$0;
        private static final long serialVersionUID = 6748924232082076534L;

        AccessibleJMenuItem(JMenuItem this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public void stateChanged(ChangeEvent event) {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_ITEM;
        }
    }
}

