/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.plaf.OptionPaneUI;

public class JOptionPane
extends JComponent
implements Accessible {
    private static final long serialVersionUID = 5231143276678566796L;
    public static final int CANCEL_OPTION = 2;
    public static final int CLOSED_OPTION = -1;
    public static final int DEFAULT_OPTION = -1;
    public static final int NO_OPTION = 1;
    public static final int OK_CANCEL_OPTION = 2;
    public static final int OK_OPTION = 0;
    public static final int YES_NO_CANCEL_OPTION = 1;
    public static final int YES_NO_OPTION = 0;
    public static final int YES_OPTION = 0;
    public static final int ERROR_MESSAGE = 0;
    public static final int INFORMATION_MESSAGE = 1;
    public static final int PLAIN_MESSAGE = -1;
    public static final int QUESTION_MESSAGE = 3;
    public static final int WARNING_MESSAGE = 2;
    public static final String ICON_PROPERTY = "icon";
    public static final String INITIAL_SELECTION_VALUE_PROPERTY = "initialSelectionValue";
    public static final String INITIAL_VALUE_PROPERTY = "initialValue";
    public static final String INPUT_VALUE_PROPERTY = "inputValue";
    public static final String MESSAGE_PROPERTY = "message";
    public static final String MESSAGE_TYPE_PROPERTY = "messageType";
    public static final String OPTION_TYPE_PROPERTY = "optionType";
    public static final String OPTIONS_PROPERTY = "options";
    public static final String SELECTION_VALUES_PROPERTY = "selectionValues";
    public static final String VALUE_PROPERTY = "value";
    public static final String WANTS_INPUT_PROPERTY = "wantsInput";
    public static Object UNINITIALIZED_VALUE;
    protected Icon icon;
    protected Object initialSelectionValue;
    protected Object initialValue;
    protected Object inputValue;
    protected Object message;
    protected int messageType;
    protected Object[] options;
    protected int optionType;
    protected Object[] selectionValues;
    protected Object value;
    protected boolean wantsInput;
    private static Frame privFrame;

    private /* synthetic */ void finit$() {
        this.inputValue = UNINITIALIZED_VALUE;
        this.messageType = -1;
        this.optionType = -1;
        this.value = UNINITIALIZED_VALUE;
    }

    public JOptionPane() {
        this("JOptionPane message", -1, -1, null, null, null);
    }

    public JOptionPane(Object message) {
        this(message, -1, -1, null, null, null);
    }

    public JOptionPane(Object message, int messageType) {
        this(message, messageType, -1, null, null, null);
    }

    public JOptionPane(Object message, int messageType, int optionType) {
        this(message, messageType, optionType, null, null, null);
    }

    public JOptionPane(Object message, int messageType, int optionType, Icon icon) {
        this(message, messageType, optionType, icon, null, null);
    }

    public JOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options) {
        this(message, messageType, optionType, icon, options, null);
    }

    public JOptionPane(Object message, int messageType, int optionType, Icon icon, Object[] options, Object initialValue) {
        this.finit$();
        this.message = message;
        if (!this.validMessageType(messageType)) {
            throw new IllegalArgumentException("Message Type not legal value.");
        }
        this.messageType = messageType;
        if (!this.validOptionType(optionType)) {
            throw new IllegalArgumentException("Option Type not legal value.");
        }
        this.optionType = optionType;
        this.icon = icon;
        this.options = options;
        this.initialValue = initialValue;
        this.setLayout(new BoxLayout(this, 1));
        this.updateUI();
        this.invalidate();
        this.repaint();
    }

    public JDialog createDialog(Component parentComponent, String title) {
        Frame toUse = JOptionPane.getFrameForComponent(parentComponent);
        if (toUse == null) {
            toUse = JOptionPane.getRootFrame();
        }
        JDialog dialog = new JDialog(toUse, title);
        this.inputValue = UNINITIALIZED_VALUE;
        this.value = UNINITIALIZED_VALUE;
        dialog.getContentPane().add(this);
        dialog.setModal(true);
        dialog.setResizable(false);
        dialog.invalidate();
        dialog.repaint();
        return dialog;
    }

    public JInternalFrame createInternalFrame(Component parentComponent, String title) throws RuntimeException {
        JDesktopPane toUse = JOptionPane.getDesktopPaneForComponent(parentComponent);
        if (toUse == null) {
            throw new RuntimeException("parentComponent does not have a valid parent");
        }
        JInternalFrame frame = new JInternalFrame(title);
        this.inputValue = UNINITIALIZED_VALUE;
        this.value = UNINITIALIZED_VALUE;
        frame.setClosable(true);
        toUse.add(frame);
        return frame;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJOptionPane(this);
        }
        return this.accessibleContext;
    }

    public static JDesktopPane getDesktopPaneForComponent(Component parentComponent) {
        return (JDesktopPane)SwingUtilities.getAncestorOfClass(JOptionPane.class$("javax.swing.JDesktopPane"), parentComponent);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public static Frame getFrameForComponent(Component parentComponent) {
        return (Frame)SwingUtilities.getAncestorOfClass(JOptionPane.class$("java.awt.Frame"), parentComponent);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Object getInitialSelectionValue() {
        return this.initialSelectionValue;
    }

    public Object getInitialValue() {
        return this.initialValue;
    }

    public Object getInputValue() {
        return this.inputValue;
    }

    public int getMaxCharactersPerLineCount() {
        return Integer.MAX_VALUE;
    }

    public Object getMessage() {
        return this.message;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public Object[] getOptions() {
        return this.options;
    }

    public int getOptionType() {
        return this.optionType;
    }

    public static Frame getRootFrame() {
        return privFrame;
    }

    public Object[] getSelectionValues() {
        return this.selectionValues;
    }

    public OptionPaneUI getUI() {
        return (OptionPaneUI)this.ui;
    }

    public String getUIClassID() {
        return "OptionPaneUI";
    }

    public Object getValue() {
        return this.value;
    }

    public boolean getWantsInput() {
        return this.wantsInput;
    }

    protected String paramString() {
        return "JOptionPane";
    }

    public void selectInitialValue() {
        if (this.ui != null) {
            ((OptionPaneUI)this.ui).selectInitialValue(this);
        }
    }

    public void setIcon(Icon newIcon) {
        if (this.icon != newIcon) {
            Icon old = this.icon;
            this.icon = newIcon;
            this.firePropertyChange(ICON_PROPERTY, old, this.icon);
        }
    }

    public void setInitialSelectionValue(Object newValue) {
        if (this.initialSelectionValue != newValue) {
            Object old = this.initialSelectionValue;
            this.initialSelectionValue = newValue;
            this.firePropertyChange(INITIAL_SELECTION_VALUE_PROPERTY, old, this.initialSelectionValue);
        }
    }

    public void setInitialValue(Object newValue) {
        if (this.initialValue != newValue) {
            Object old = this.initialValue;
            this.initialValue = newValue;
            this.firePropertyChange(INITIAL_VALUE_PROPERTY, old, this.initialValue);
        }
    }

    public void setInputValue(Object newValue) {
        if (this.inputValue != newValue) {
            Object old = this.inputValue;
            this.inputValue = newValue;
            this.firePropertyChange(INPUT_VALUE_PROPERTY, old, this.inputValue);
        }
    }

    public void setMessage(Object newMessage) {
        if (this.message != newMessage) {
            Object old = this.message;
            this.message = newMessage;
            this.firePropertyChange(MESSAGE_PROPERTY, old, this.message);
        }
    }

    public void setMessageType(int newType) {
        if (!this.validMessageType(newType)) {
            throw new IllegalArgumentException("Message Type not legal value.");
        }
        if (newType != this.messageType) {
            int old = this.messageType;
            this.messageType = newType;
            this.firePropertyChange(MESSAGE_TYPE_PROPERTY, old, this.messageType);
        }
    }

    public void setOptions(Object[] newOptions) {
        if (this.options != newOptions) {
            Object[] old = this.options;
            this.options = newOptions;
            this.firePropertyChange(OPTIONS_PROPERTY, old, this.options);
        }
    }

    public void setOptionType(int newType) {
        if (!this.validOptionType(newType)) {
            throw new IllegalArgumentException("Option Type not legal value.");
        }
        if (newType != this.optionType) {
            int old = this.optionType;
            this.optionType = newType;
            this.firePropertyChange(OPTION_TYPE_PROPERTY, old, this.optionType);
        }
    }

    public static void setRootFrame(Frame newRootFrame) {
        privFrame = newRootFrame;
    }

    public void setSelectionValues(Object[] newValues) {
        if (newValues != this.selectionValues) {
            if (newValues != null) {
                this.wantsInput = true;
            }
            Object[] old = this.selectionValues;
            this.selectionValues = newValues;
            this.firePropertyChange(SELECTION_VALUES_PROPERTY, old, this.selectionValues);
        }
    }

    public void setUI(OptionPaneUI ui) {
        super.setUI(ui);
    }

    public void setValue(Object newValue) {
        if (this.value != newValue) {
            Object old = this.value;
            this.value = newValue;
            this.firePropertyChange(VALUE_PROPERTY, old, this.value);
        }
    }

    public void setWantsInput(boolean newValue) {
        if (this.wantsInput != newValue) {
            boolean old = this.wantsInput;
            this.wantsInput = newValue;
            this.firePropertyChange(WANTS_INPUT_PROPERTY, old, this.wantsInput);
        }
    }

    public static int showConfirmDialog(Component parentComponent, Object message) {
        JOptionPane pane = new JOptionPane(message);
        JDialog dialog = pane.createDialog(parentComponent, "Select an Option");
        dialog.pack();
        dialog.show();
        return (Integer)pane.getValue();
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        JOptionPane pane = new JOptionPane(message, -1, optionType);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.pack();
        dialog.show();
        return (Integer)pane.getValue();
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.pack();
        dialog.show();
        return (Integer)pane.getValue();
    }

    public static int showConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.pack();
        dialog.show();
        return (Integer)pane.getValue();
    }

    public static String showInputDialog(Component parentComponent, Object message) {
        JOptionPane pane = new JOptionPane(message, 3);
        pane.setWantsInput(true);
        JDialog dialog = pane.createDialog(parentComponent, null);
        dialog.pack();
        dialog.show();
        return (String)pane.getInputValue();
    }

    public static String showInputDialog(Component parentComponent, Object message, Object initialSelectionValue) {
        JOptionPane pane = new JOptionPane(message, 3);
        pane.setInitialSelectionValue(initialSelectionValue);
        pane.setWantsInput(true);
        JDialog dialog = pane.createDialog(parentComponent, null);
        dialog.pack();
        dialog.show();
        return (String)pane.getInputValue();
    }

    public static String showInputDialog(Component parentComponent, Object message, String title, int messageType) {
        JOptionPane pane = new JOptionPane(message, messageType);
        pane.setWantsInput(true);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.pack();
        dialog.show();
        return (String)pane.getInputValue();
    }

    public static Object showInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        JOptionPane pane = new JOptionPane(message, messageType);
        pane.setWantsInput(true);
        pane.setIcon(icon);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.pack();
        dialog.show();
        return pane.getInputValue();
    }

    public static String showInputDialog(Object message) {
        JOptionPane pane = new JOptionPane(message, 3);
        pane.setWantsInput(true);
        JDialog dialog = pane.createDialog(null, null);
        dialog.pack();
        dialog.show();
        return (String)pane.getInputValue();
    }

    public static String showInputDialog(Object message, Object initialSelectionValue) {
        JOptionPane pane = new JOptionPane(message, 3);
        pane.setWantsInput(true);
        pane.setInitialSelectionValue(initialSelectionValue);
        JDialog dialog = pane.createDialog(null, null);
        dialog.pack();
        dialog.show();
        return (String)pane.getInputValue();
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message) {
        JOptionPane pane = new JOptionPane(message);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, null);
        JOptionPane.startModal(frame, pane);
        return (Integer)pane.getValue();
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType) {
        JOptionPane pane = new JOptionPane(message, -1, optionType);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, title);
        JOptionPane.startModal(frame, pane);
        return (Integer)pane.getValue();
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, title);
        JOptionPane.startModal(frame, pane);
        return (Integer)pane.getValue();
    }

    public static int showInternalConfirmDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, title);
        JOptionPane.startModal(frame, pane);
        return (Integer)pane.getValue();
    }

    public static String showInternalInputDialog(Component parentComponent, Object message) {
        JOptionPane pane = new JOptionPane(message);
        pane.setWantsInput(true);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, null);
        JOptionPane.startModal(frame, pane);
        return (String)pane.getInputValue();
    }

    public static String showInternalInputDialog(Component parentComponent, Object message, String title, int messageType) {
        JOptionPane pane = new JOptionPane(message, messageType);
        pane.setWantsInput(true);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, title);
        JOptionPane.startModal(frame, pane);
        return (String)pane.getInputValue();
    }

    public static Object showInternalInputDialog(Component parentComponent, Object message, String title, int messageType, Icon icon, Object[] selectionValues, Object initialSelectionValue) {
        JOptionPane pane = new JOptionPane(message, messageType);
        pane.setWantsInput(true);
        pane.setIcon(icon);
        pane.setSelectionValues(selectionValues);
        pane.setInitialSelectionValue(initialSelectionValue);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, title);
        JOptionPane.startModal(frame, pane);
        return pane.getInputValue();
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message) {
        JOptionPane pane = new JOptionPane(message);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, null);
        JOptionPane.startModal(frame, pane);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        JOptionPane pane = new JOptionPane(message, messageType);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, title);
        JOptionPane.startModal(frame, pane);
    }

    public static void showInternalMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        JOptionPane pane = new JOptionPane(message, messageType);
        pane.setIcon(icon);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, title);
        JOptionPane.startModal(frame, pane);
    }

    public static int showInternalOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        JInternalFrame frame = pane.createInternalFrame(parentComponent, title);
        JOptionPane.startModal(frame, pane);
        return (Integer)pane.getValue();
    }

    public static void showMessageDialog(Component parentComponent, Object message) {
        JOptionPane pane = new JOptionPane(message, 1);
        JDialog dialog = pane.createDialog(parentComponent, null);
        dialog.pack();
        dialog.show();
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType) {
        JOptionPane pane = new JOptionPane(message, messageType);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.pack();
        dialog.show();
    }

    public static void showMessageDialog(Component parentComponent, Object message, String title, int messageType, Icon icon) {
        JOptionPane pane = new JOptionPane(message, messageType);
        pane.setIcon(icon);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.pack();
        dialog.show();
    }

    public static int showOptionDialog(Component parentComponent, Object message, String title, int optionType, int messageType, Icon icon, Object[] options, Object initialValue) {
        JOptionPane pane = new JOptionPane(message, messageType, optionType, icon, options, initialValue);
        JDialog dialog = pane.createDialog(parentComponent, title);
        dialog.pack();
        dialog.show();
        return (Integer)pane.getValue();
    }

    public void updateUI() {
        this.setUI((OptionPaneUI)UIManager.getUI(this));
        this.invalidate();
    }

    private boolean validMessageType(int key) {
        switch (key) {
            case -1: 
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    private boolean validOptionType(int key) {
        switch (key) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                return true;
            }
        }
        return false;
    }

    private static void startModal(JInternalFrame f, JOptionPane pane) {
        f.getContentPane().add(pane);
        f.pack();
        f.show();
        Dimension pref = f.getPreferredSize();
        f.setBounds(0, 0, pref.width, pref.height);
        JInternalFrame jInternalFrame = f;
        synchronized (jInternalFrame) {
            try {
                JInternalFrame tmp = f;
                tmp.toFront();
                f.addInternalFrameListener(new InternalFrameAdapter(null, tmp){
                    private /* synthetic */ JOptionPane this$0;
                    private /* synthetic */ JInternalFrame val$tmp;
                    {
                        this.this$0 = this$0;
                        this.finit$(parm$tmp);
                    }

                    private /* synthetic */ void finit$(JInternalFrame parm$tmp) {
                        this.val$tmp = parm$tmp;
                    }

                    public void internalFrameClosed(InternalFrameEvent e) {
                        JInternalFrame jInternalFrame = this.val$tmp;
                        synchronized (jInternalFrame) {
                            try {
                                this.val$tmp.removeInternalFrameListener(this);
                                this.val$tmp.notifyAll();
                            }
                            finally {
                                Object var3_3 = null;
                            }
                            return;
                        }
                    }
                });
                try {
                    while (!f.isClosed()) {
                        f.wait();
                    }
                }
                catch (InterruptedException ignored) {
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    static {
        ICON_PROPERTY = ICON_PROPERTY;
        INITIAL_SELECTION_VALUE_PROPERTY = INITIAL_SELECTION_VALUE_PROPERTY;
        INITIAL_VALUE_PROPERTY = INITIAL_VALUE_PROPERTY;
        INPUT_VALUE_PROPERTY = INPUT_VALUE_PROPERTY;
        MESSAGE_PROPERTY = MESSAGE_PROPERTY;
        MESSAGE_TYPE_PROPERTY = MESSAGE_TYPE_PROPERTY;
        OPTION_TYPE_PROPERTY = OPTION_TYPE_PROPERTY;
        OPTIONS_PROPERTY = OPTIONS_PROPERTY;
        SELECTION_VALUES_PROPERTY = SELECTION_VALUES_PROPERTY;
        VALUE_PROPERTY = VALUE_PROPERTY;
        WANTS_INPUT_PROPERTY = WANTS_INPUT_PROPERTY;
        UNINITIALIZED_VALUE = "uninitializedValue";
        privFrame = SwingUtilities.getOwnerFrame();
    }

    protected class AccessibleJOptionPane
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JOptionPane this$0;
        private static final long serialVersionUID = 686071432213084821L;

        protected AccessibleJOptionPane(JOptionPane this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleRole getAccessibleRole() {
            return null;
        }
    }
}

