/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Action;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;

public class JPopupMenu
extends JComponent
implements Accessible,
MenuElement {
    private static final long serialVersionUID = -8336996630009646009L;
    private static final String uiClassID = "PopupMenuUI";
    public static final String LABEL_CHANGED_PROPERTY = "label";
    private boolean borderPainted;
    private static boolean DefaultLightWeightPopupEnabled;
    transient Component invoker;
    private String label;
    private Insets margin;
    private boolean lightWeightPopupEnabled;
    private SingleSelectionModel selectionModel;
    private transient Popup popup;
    private Point popupLocation;
    private boolean visible;
    public static final String VISIBLE_CHANGED_PROPERTY = "visible";

    private /* synthetic */ void finit$() {
        this.borderPainted = true;
        this.visible = false;
    }

    public JPopupMenu() {
        this.finit$();
        this.updateUI();
        this.lightWeightPopupEnabled = DefaultLightWeightPopupEnabled;
        this.selectionModel = new DefaultSingleSelectionModel();
        super.setVisible(false);
    }

    public JPopupMenu(String label) {
        this.finit$();
        this.setLabel(label);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
    }

    public JMenuItem add(JMenuItem item) {
        this.insert(item, -1);
        return item;
    }

    public JMenuItem add(String text) {
        JMenuItem item = new JMenuItem(text);
        return this.add(item);
    }

    public JMenuItem add(Action action) {
        JMenuItem item = this.createActionComponent(action);
        if (action != null) {
            action.addPropertyChangeListener(this.createActionChangeListener(item));
        }
        return this.add(item);
    }

    public void remove(int index) {
        super.remove(index);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 100.0;
        constraints.weighty = 100.0;
        Component[] items = this.getComponents();
        for (int i = index; i < items.length; ++i) {
            constraints.gridy = i;
            super.add(items[i], constraints, i);
        }
    }

    public void insert(Action action, int index) {
        JMenuItem item = new JMenuItem(action);
        this.insert(item, index);
    }

    public void insert(Component component, int index) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.weightx = 100.0;
        constraints.weighty = 100.0;
        if (index == -1) {
            index = this.getComponents().length;
        }
        constraints.gridy = index;
        super.add(component, constraints, index);
        if (index != -1) {
            Component[] items = this.getComponents();
            for (int i = index + 1; i < items.length; ++i) {
                constraints.gridy = i;
                super.add(items[i], constraints, i);
            }
        }
    }

    protected void borderPainted(Graphics graphics) {
        if (this.borderPainted) {
            this.getBorder().paintBorder(this, graphics, 0, 0, this.getSize(null).width, this.getSize(null).height);
        }
    }

    public static boolean getDefaultLightWeightPopupEnabled() {
        return DefaultLightWeightPopupEnabled;
    }

    public static void setDefaultLightWeightPopupEnabled(boolean enabled) {
        DefaultLightWeightPopupEnabled = enabled;
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.ui;
    }

    public void setUI(PopupMenuUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((PopupMenuUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public SingleSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    public void setSelectionModel(SingleSelectionModel model) {
        if (this.selectionModel != model) {
            SingleSelectionModel singleSelectionModel = this.selectionModel;
        }
    }

    protected JMenuItem createActionComponent(Action action) {
        return new JMenuItem(action);
    }

    protected PropertyChangeListener createActionChangeListener(JMenuItem item) {
        return new ActionChangeListener(this);
    }

    public boolean isLightWeightPopupEnabled() {
        return this.lightWeightPopupEnabled;
    }

    public void setLightWeightPopupEnabled(boolean enabled) {
        this.lightWeightPopupEnabled = enabled;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        if (label != this.label) {
            String oldLabel = this.label;
            this.label = label;
            this.firePropertyChange(LABEL_CHANGED_PROPERTY, oldLabel, label);
        }
    }

    public void addSeparator() {
        this.insert(new Separator(), -1);
    }

    public void addPopupMenuListener(PopupMenuListener listener) {
        this.listenerList.add(JPopupMenu.class$("javax.swing.event.PopupMenuListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removePopupMenuListener(PopupMenuListener listener) {
        this.listenerList.remove(JPopupMenu.class$("javax.swing.event.PopupMenuListener"), listener);
    }

    public PopupMenuListener[] getPopupMenuListeners() {
        return (PopupMenuListener[])this.listenerList.getListeners(JPopupMenu.class$("javax.swing.event.PopupMenuListener"));
    }

    protected void firePopupMenuWillBecomeVisible() {
        EventListener[] ll = this.listenerList.getListeners(JPopupMenu.class$("javax.swing.event.PopupMenuListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((PopupMenuListener)ll[i]).popupMenuWillBecomeVisible(new PopupMenuEvent(this));
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        EventListener[] ll = this.listenerList.getListeners(JPopupMenu.class$("javax.swing.event.PopupMenuListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((PopupMenuListener)ll[i]).popupMenuWillBecomeInvisible(new PopupMenuEvent(this));
        }
    }

    protected void firePopupMenuCanceled() {
        EventListener[] ll = this.listenerList.getListeners(JPopupMenu.class$("javax.swing.event.PopupMenuListener"));
        for (int i = 0; i < ll.length; ++i) {
            ((PopupMenuListener)ll[i]).popupMenuCanceled(new PopupMenuEvent(this));
        }
    }

    public void pack() {
        super.setSize(null);
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        boolean old = this.isVisible();
        this.visible = visible;
        if (old != this.isVisible()) {
            this.firePropertyChange(VISIBLE_CHANGED_PROPERTY, old, this.isVisible());
            if (visible) {
                this.firePopupMenuWillBecomeVisible();
                Container rootContainer = (Container)SwingUtilities.getRoot(this.invoker);
                boolean fit = true;
                Dimension size = this.getSize().width == 0 && this.getSize().width == 0 ? this.getPreferredSize() : this.getSize();
                if (size.width > rootContainer.getWidth() - this.popupLocation.x || size.height > rootContainer.getHeight() - this.popupLocation.y) {
                    fit = false;
                }
                this.popup = this.lightWeightPopupEnabled && fit ? new LightWeightPopup(this, this) : (fit ? new MediumWeightPopup(this, this) : new HeavyWeightPopup(this, this));
                if (this.popup instanceof LightWeightPopup || this.popup instanceof MediumWeightPopup) {
                    JLayeredPane layeredPane = SwingUtilities.getRootPane(this.invoker).getLayeredPane();
                    Point p = new Point(this.popupLocation.x, this.popupLocation.y);
                    SwingUtilities.convertPointFromScreen(p, layeredPane);
                    this.popup.show(p.x, p.y, size.width, size.height);
                } else {
                    Insets insets = rootContainer.getInsets();
                    this.popup.show(this.popupLocation.x - insets.left, this.popupLocation.y - insets.top, size.width, size.height);
                }
            } else {
                this.firePopupMenuWillBecomeInvisible();
                this.popup.hide();
            }
        }
    }

    public void setLocation(int x, int y) {
        if (this.popupLocation == null) {
            this.popupLocation = new Point();
        }
        this.popupLocation.x = x;
        this.popupLocation.y = y;
    }

    public Component getInvoker() {
        return this.invoker;
    }

    public void setInvoker(Component component) {
        this.invoker = component;
    }

    public void show(Component component, int x, int y) {
        this.setInvoker(component);
        Point p = new Point(x, y);
        SwingUtilities.convertPointToScreen(p, component);
        this.setLocation(p.x, p.y);
        this.setVisible(true);
    }

    public Component getComponentAtIndex(int index) {
        return this.getComponent(index);
    }

    public int getComponentIndex(Component component) {
        Component[] items = this.getComponents();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(component)) continue;
            return i;
        }
        return -1;
    }

    public void setPopupSize(Dimension size) {
        super.setSize(size);
    }

    public void setPopupSize(int width, int height) {
        super.setSize(width, height);
    }

    public void setSelected(Component selected) {
        int index = this.getComponentIndex(selected);
        this.selectionModel.setSelectedIndex(index);
    }

    public boolean isBorderPainted() {
        return this.borderPainted;
    }

    public void setBorderPainted(boolean painted) {
        this.borderPainted = painted;
    }

    public Insets getMargin() {
        return this.margin;
    }

    protected String paramString() {
        return "JPopupMenu";
    }

    public void processMouseEvent(MouseEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void processKeyEvent(KeyEvent event, MenuElement[] path, MenuSelectionManager manager) {
    }

    public void menuSelectionChanged(boolean changed) {
        if (!changed) {
            this.setVisible(false);
        }
    }

    public MenuElement[] getSubElements() {
        Component[] items = this.getComponents();
        MenuElement[] subElements = new MenuElement[items.length];
        for (int i = 0; i < items.length; ++i) {
            subElements[i] = (MenuElement)((Object)items[i]);
        }
        return subElements;
    }

    public Component getComponent() {
        return this;
    }

    public boolean isPopupTrigger(MouseEvent event) {
        return this.getUI().isPopupTrigger(event);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJPopupMenu(this);
        }
        return this.accessibleContext;
    }

    static {
        uiClassID = uiClassID;
        LABEL_CHANGED_PROPERTY = LABEL_CHANGED_PROPERTY;
        DefaultLightWeightPopupEnabled = true;
        VISIBLE_CHANGED_PROPERTY = VISIBLE_CHANGED_PROPERTY;
    }

    protected class ActionChangeListener
    implements PropertyChangeListener {
        private /* synthetic */ JPopupMenu this$0;

        public void propertyChange(PropertyChangeEvent evt) {
            this.this$0.revalidate();
            this.this$0.repaint();
        }

        ActionChangeListener(JPopupMenu this$0) {
            this.this$0 = this$0;
        }
    }

    protected class AccessibleJPopupMenu
    extends JComponent.AccessibleJComponent {
        private /* synthetic */ JPopupMenu this$0;
        private static final long serialVersionUID = 7423261328879849768L;

        protected AccessibleJPopupMenu(JPopupMenu this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.POPUP_MENU;
        }
    }

    public static class Separator
    extends JSeparator {
        public String getUIClassID() {
            return "PopupMenuSeparatorUI";
        }
    }

    private class HeavyWeightPopup
    extends JWindow
    implements Popup {
        private /* synthetic */ JPopupMenu this$0;

        public HeavyWeightPopup(JPopupMenu this$0, Container c) {
            this.this$0 = this$0;
            this.setContentPane(c);
        }

        public void show(int x, int y, int width, int height) {
            this.setBounds(x, y, width, height);
            this.show();
        }

        public void hide() {
            super.hide();
        }
    }

    private class MediumWeightPopup
    extends Panel
    implements Popup {
        private /* synthetic */ JPopupMenu this$0;

        public MediumWeightPopup(JPopupMenu this$0, Container c) {
            this.this$0 = this$0;
            this.add(c);
        }

        public void show(int x, int y, int width, int height) {
            JLayeredPane layeredPane = SwingUtilities.getRootPane(this.this$0.invoker).getLayeredPane();
            layeredPane.add(this, JLayeredPane.POPUP_LAYER, 0);
            this.setBounds(x, y, width, height);
        }

        public void hide() {
            JLayeredPane layeredPane = SwingUtilities.getRootPane(this.this$0.invoker).getLayeredPane();
            int index = layeredPane.getIndexOf(this);
            layeredPane.remove(index);
        }
    }

    private class LightWeightPopup
    extends Container
    implements Popup {
        private /* synthetic */ JPopupMenu this$0;
        private Component c;

        public LightWeightPopup(JPopupMenu this$0, Container c) {
            this.this$0 = this$0;
            this.c = c;
        }

        public void show(int x, int y, int width, int height) {
            JLayeredPane layeredPane = SwingUtilities.getRootPane(this.this$0.invoker).getLayeredPane();
            this.c.setBounds(x, y, width, height);
            layeredPane.add(this.c, JLayeredPane.POPUP_LAYER, 0);
        }

        public void hide() {
            JLayeredPane layeredPane = SwingUtilities.getRootPane(this.this$0.invoker).getLayeredPane();
            int index = layeredPane.getIndexOf(this.c);
            layeredPane.remove(index);
        }
    }

    private interface Popup {
        public void show(int var1, int var2, int var3, int var4);

        public void hide();
    }
}

