/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Graphics;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.BoundedRangeModel;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ProgressBarUI;

public class JProgressBar
extends JComponent
implements SwingConstants,
Accessible {
    private static final long serialVersionUID = 1980046021813598781L;
    public static final String BORDER_PAINTED_CHANGED_PROPERTY = "borderPainted";
    public static final String ORIENTATION_CHANGED_PROPERTY = "orientation";
    public static final String STRING_CHANGED_PROPERTY = "string";
    public static final String STRING_PAINTED_CHANGED_PROPERTY = "stringPainted";
    public static final String INDETERMINATE_CHANGED_PROPERTY = "indeterminate";
    private transient boolean indeterminate;
    protected int orientation;
    protected boolean paintBorder;
    protected BoundedRangeModel model;
    protected String progressString;
    protected boolean paintString;
    protected transient ChangeEvent changeEvent;
    protected ChangeListener changeListener;

    private /* synthetic */ void finit$() {
        this.indeterminate = false;
        this.orientation = 0;
        this.paintBorder = true;
        this.paintString = false;
    }

    public JProgressBar() {
        this(0, 100, 0);
    }

    public JProgressBar(int orientation) {
        this(0, 100, orientation);
    }

    public JProgressBar(int minimum, int maximum) {
        this(minimum, maximum, 0);
    }

    public JProgressBar(int minimum, int maximum, int orientation) {
        this.finit$();
        this.model = new DefaultBoundedRangeModel(minimum, 0, minimum, maximum);
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException(orientation + " is not a legal orientation");
        }
        this.orientation = orientation;
        this.changeListener = this.createChangeListener();
        this.model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public JProgressBar(BoundedRangeModel model) {
        this.finit$();
        this.model = model;
        this.changeListener = this.createChangeListener();
        model.addChangeListener(this.changeListener);
        this.updateUI();
    }

    public int getValue() {
        return this.model.getValue();
    }

    public void setValue(int value) {
        this.model.setValue(value);
    }

    protected void paintBorder(Graphics graphics) {
        this.getBorder().paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 1 && orientation != 0) {
            throw new IllegalArgumentException("orientation must be one of VERTICAL or HORIZONTAL");
        }
        if (this.orientation != orientation) {
            int oldOrientation = this.orientation;
            this.orientation = orientation;
            this.firePropertyChange(ORIENTATION_CHANGED_PROPERTY, oldOrientation, this.orientation);
        }
    }

    public boolean isStringPainted() {
        return this.paintString;
    }

    public void setStringPainted(boolean painted) {
        if (this.paintString != painted) {
            boolean oldPainted = this.paintString;
            this.paintString = painted;
            this.firePropertyChange(STRING_PAINTED_CHANGED_PROPERTY, oldPainted, this.paintString);
        }
    }

    public String getString() {
        if (this.progressString != null) {
            return this.progressString;
        }
        return (int)(this.getPercentComplete() * 100.0) + "%";
    }

    public void setString(String string) {
        if ((string == null || this.progressString == null) && string != this.progressString || string != null && !string.equals(this.progressString)) {
            String oldString = this.progressString;
            this.progressString = string;
            this.firePropertyChange(STRING_CHANGED_PROPERTY, oldString, this.progressString);
        }
    }

    public double getPercentComplete() {
        if (this.getMaximum() == this.getMinimum()) {
            return 1.0;
        }
        return (double)(this.model.getValue() - this.model.getMinimum()) / (double)(this.model.getMaximum() - this.model.getMinimum());
    }

    public boolean isBorderPainted() {
        return this.paintBorder;
    }

    public void setBorderPainted(boolean painted) {
        if (painted != this.paintBorder) {
            boolean oldPainted = this.paintBorder;
            this.paintBorder = painted;
            this.firePropertyChange(BORDER_PAINTED_CHANGED_PROPERTY, oldPainted, this.paintBorder);
        }
    }

    public ProgressBarUI getUI() {
        return (ProgressBarUI)this.ui;
    }

    public void setUI(ProgressBarUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ProgressBarUI)UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return "ProgressBarUI";
    }

    protected ChangeListener createChangeListener() {
        return new ChangeListener(this){
            private /* synthetic */ JProgressBar this$0;
            {
                this.this$0 = this$0;
            }

            public void stateChanged(ChangeEvent ce) {
                this.this$0.fireStateChanged();
            }
        };
    }

    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(JProgressBar.class$("javax.swing.event.ChangeListener"), listener);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(JProgressBar.class$("javax.swing.event.ChangeListener"), listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(JProgressBar.class$("javax.swing.event.ChangeListener"));
    }

    protected void fireStateChanged() {
        Object[] changeListeners = this.listenerList.getListenerList();
        if (this.changeEvent == null) {
            this.changeEvent = new ChangeEvent(this);
        }
        for (int i = changeListeners.length - 2; i >= 0; i -= 2) {
            if (changeListeners[i] != JProgressBar.class$("javax.swing.event.ChangeListener")) continue;
            ((ChangeListener)changeListeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    public BoundedRangeModel getModel() {
        return this.model;
    }

    public void setModel(BoundedRangeModel model) {
        if (model != this.model) {
            this.model.removeChangeListener(this.changeListener);
            this.model = model;
            this.model.addChangeListener(this.changeListener);
            this.fireStateChanged();
        }
    }

    public int getMinimum() {
        return this.model.getMinimum();
    }

    public void setMinimum(int minimum) {
        this.model.setMinimum(minimum);
    }

    public int getMaximum() {
        return this.model.getMaximum();
    }

    public void setMaximum(int maximum) {
        this.model.setMaximum(maximum);
    }

    protected String paramString() {
        return "JProgressBar";
    }

    public void setIndeterminate(boolean newValue) {
        if (this.indeterminate != newValue) {
            boolean olddeter = this.indeterminate;
            this.indeterminate = newValue;
            this.firePropertyChange(INDETERMINATE_CHANGED_PROPERTY, olddeter, this.indeterminate);
        }
    }

    public boolean isIndeterminate() {
        return this.indeterminate;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJProgressBar(this);
        }
        return this.accessibleContext;
    }

    protected class AccessibleJProgressBar
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private /* synthetic */ JProgressBar this$0;
        private static final long serialVersionUID = -2938130009392721813L;

        protected AccessibleJProgressBar(JProgressBar this$0) {
            this.this$0 = this$0;
            super(this$0);
        }

        public AccessibleStateSet getAccessibleStateSet() {
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        public AccessibleValue getAccessibleValue() {
            return null;
        }

        public Number getCurrentAccessibleValue() {
            return null;
        }

        public boolean setCurrentAccessibleValue(Number value0) {
            return false;
        }

        public Number getMinimumAccessibleValue() {
            return null;
        }

        public Number getMaximumAccessibleValue() {
            return null;
        }
    }
}

