/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.io.Serializable;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.RootPaneUI;

public class JRootPane
extends JComponent {
    private static final long serialVersionUID = 8690748000348575668L;
    protected Component glassPane;
    protected JLayeredPane layeredPane;
    protected JMenuBar menuBar;
    protected Container contentPane;

    public void setJMenuBar(JMenuBar m) {
        this.menuBar = m;
        this.getLayeredPane().add((Component)this.menuBar, JLayeredPane.FRAME_CONTENT_LAYER);
    }

    public JMenuBar getJMenuBar() {
        return this.menuBar;
    }

    public boolean isValidateRoot() {
        return true;
    }

    public Container getContentPane() {
        if (this.contentPane == null) {
            this.setContentPane(this.createContentPane());
        }
        return this.contentPane;
    }

    public void setContentPane(Container p) {
        this.contentPane = p;
        this.getLayeredPane().add((Component)this.contentPane, JLayeredPane.FRAME_CONTENT_LAYER);
    }

    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
    }

    public Component getGlassPane() {
        if (this.glassPane == null) {
            this.setGlassPane(this.createGlassPane());
        }
        return this.glassPane;
    }

    public void setGlassPane(Component f) {
        if (this.glassPane != null) {
            this.remove(this.glassPane);
        }
        this.glassPane = f;
        this.glassPane.setVisible(false);
        this.add(this.glassPane, 0);
    }

    public JLayeredPane getLayeredPane() {
        if (this.layeredPane == null) {
            this.setLayeredPane(this.createLayeredPane());
        }
        return this.layeredPane;
    }

    public void setLayeredPane(JLayeredPane f) {
        if (this.layeredPane != null) {
            this.remove(this.layeredPane);
        }
        this.layeredPane = f;
        this.add((Component)f, -1);
    }

    public JRootPane() {
        this.setLayout(this.createRootLayout());
        this.getGlassPane();
        this.getLayeredPane();
        this.getContentPane();
        this.setDoubleBuffered(true);
        this.updateUI();
    }

    protected LayoutManager createRootLayout() {
        return new RootLayout(this);
    }

    protected JComponent createContentPane() {
        JPanel p = new JPanel();
        p.setName(this.getName() + ".contentPane");
        p.setLayout(new BorderLayout());
        return p;
    }

    protected Component createGlassPane() {
        JPanel p = new JPanel();
        p.setName(this.getName() + ".glassPane");
        p.setLayout(new BorderLayout());
        p.setVisible(false);
        p.setOpaque(false);
        return p;
    }

    protected JLayeredPane createLayeredPane() {
        JLayeredPane l = new JLayeredPane();
        l.setLayout(null);
        return l;
    }

    public RootPaneUI getUI() {
        return (RootPaneUI)this.ui;
    }

    public void setUI(RootPaneUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((RootPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "RootPaneUI";
    }

    protected class RootLayout
    implements LayoutManager2,
    Serializable {
        private /* synthetic */ JRootPane this$0;
        private static final long serialVersionUID = -4100116998559815027L;

        protected RootLayout(JRootPane this$0) {
            this.this$0 = this$0;
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public float getLayoutAlignmentX(Container target) {
            return target.getAlignmentX();
        }

        public float getLayoutAlignmentY(Container target) {
            return target.getAlignmentY();
        }

        public void invalidateLayout(Container target) {
        }

        public void layoutContainer(Container c) {
            Dimension containerSize = c.getSize(null);
            Dimension contentPaneSize = this.this$0.contentPane.getPreferredSize();
            if (containerSize.width == 0 && containerSize.height == 0) {
                if (this.this$0.menuBar != null) {
                    Dimension menuBarSize = this.this$0.menuBar.getPreferredSize();
                    int maxWidth = Math.max(menuBarSize.width, contentPaneSize.width);
                    this.this$0.menuBar.setBounds(0, 0, maxWidth, menuBarSize.height);
                    this.this$0.glassPane.setBounds(0, menuBarSize.height, maxWidth, contentPaneSize.height);
                    this.this$0.contentPane.setBounds(0, menuBarSize.height, maxWidth, contentPaneSize.height);
                    this.this$0.layeredPane.setSize(maxWidth, menuBarSize.height + contentPaneSize.height);
                } else {
                    this.this$0.glassPane.setBounds(0, 0, contentPaneSize.width, contentPaneSize.height);
                    this.this$0.contentPane.setBounds(0, 0, contentPaneSize.width, contentPaneSize.height);
                    this.this$0.layeredPane.setSize(contentPaneSize.width, contentPaneSize.height);
                }
            } else {
                if (this.this$0.menuBar != null) {
                    Dimension menuBarSize = this.this$0.menuBar.getPreferredSize();
                    if (menuBarSize.height > containerSize.height) {
                        menuBarSize.height = containerSize.height;
                    }
                    this.this$0.menuBar.setBounds(0, 0, containerSize.width, menuBarSize.height);
                    int remainingHeight = containerSize.height - menuBarSize.height;
                    this.this$0.glassPane.setBounds(0, menuBarSize.height, containerSize.width, containerSize.height - menuBarSize.height);
                    this.this$0.contentPane.setBounds(0, menuBarSize.height, containerSize.width, containerSize.height - menuBarSize.height);
                } else {
                    this.this$0.glassPane.setBounds(0, 0, containerSize.width, containerSize.height);
                    this.this$0.contentPane.setBounds(0, 0, containerSize.width, containerSize.height);
                }
                this.this$0.layeredPane.setSize(containerSize.width, containerSize.height);
            }
        }

        public Dimension maximumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        public Dimension minimumLayoutSize(Container target) {
            return this.preferredLayoutSize(target);
        }

        public Dimension preferredLayoutSize(Container c) {
            Dimension prefSize;
            Dimension containerSize = c.getSize();
            Dimension contentPaneSize = this.this$0.contentPane.getPreferredSize();
            if (containerSize.width == 0 && containerSize.height == 0) {
                if (this.this$0.menuBar != null) {
                    Dimension menuBarSize = this.this$0.menuBar.getPreferredSize();
                    int maxWidth = Math.max(menuBarSize.width, contentPaneSize.width);
                    prefSize = new Dimension(maxWidth, contentPaneSize.height + menuBarSize.height);
                } else {
                    prefSize = contentPaneSize;
                }
            } else {
                prefSize = c.getSize();
            }
            return prefSize;
        }

        public void removeLayoutComponent(Component comp) {
        }
    }

    protected static class AccessibleJRootPane {
        private static final long serialVersionUID = 1082432482784468088L;

        protected AccessibleJRootPane() {
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.ROOT_PANE;
        }
    }
}

